/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.event.Event;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;

public class DataScript
implements IScriptHandler {
    private List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    private String scriptLanguage = "ECMAScript";
    private EntityNPCInterface npc;
    private boolean enabled = false;
    public long lastInited = -1L;

    public DataScript(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public void load(class_2487 compound) {
        this.scripts = NBTTags.GetScript(compound.method_10554("Scripts", 10), this);
        this.scriptLanguage = compound.method_10558("ScriptLanguage");
        this.enabled = compound.method_10577("ScriptEnabled");
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10566("Scripts", (class_2520)NBTTags.NBTScript(this.scripts));
        compound.method_10582("ScriptLanguage", this.scriptLanguage);
        compound.method_10556("ScriptEnabled", this.enabled);
        return compound;
    }

    @Override
    public void runScript(EnumScriptType type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (type != EnumScriptType.INIT) {
                EventHooks.onNPCInit(this.npc);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.npc.method_37908().field_9236;
    }

    @Override
    public boolean isClient() {
        return this.npc.isClientSide();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String noticeString() {
        class_2338 pos = this.npc.method_24515();
        return MoreObjects.toStringHelper((Object)((Object)this.npc)).add("x", pos.method_10263()).add("y", pos.method_10264()).add("z", pos.method_10260()).toString();
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                map.put(entry.getKey(), " tab " + tab + ":\n" + entry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }
}

