/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import noppes.npcs.EventHooks;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketCustomGuiScrollClick
extends PacketServerBasic {
    private final UUID id;
    private final int slotId;
    private final boolean doubleClicked;

    public SPacketCustomGuiScrollClick(UUID id, int slotId, boolean doubleClicked) {
        this.id = id;
        this.slotId = slotId;
        this.doubleClicked = doubleClicked;
    }

    @Override
    public boolean toolAllowed(class_1799 item) {
        return true;
    }

    public static void encode(SPacketCustomGuiScrollClick msg, class_2540 buf) {
        buf.method_10797(msg.id);
        buf.method_53002(msg.slotId);
        buf.method_52964(msg.doubleClicked);
    }

    public static SPacketCustomGuiScrollClick decode(class_2540 buf) {
        return new SPacketCustomGuiScrollClick(buf.method_10790(), buf.readInt(), buf.readBoolean());
    }

    @Override
    protected void handle() {
        class_1703 class_17032 = this.player.field_7512;
        if (class_17032 instanceof ContainerCustomGui) {
            ContainerCustomGui container = (ContainerCustomGui)class_17032;
            ICustomGuiComponent comp = container.activeGui.getComponentUuid(this.id);
            if (comp instanceof CustomGuiScrollWrapper) {
                CustomGuiScrollWrapper scroll = (CustomGuiScrollWrapper)comp;
                if (scroll.isMultiSelect()) {
                    List list = Arrays.stream(scroll.getSelection()).boxed().collect(Collectors.toList());
                    if (list.contains(this.slotId)) {
                        list.remove((Object)this.slotId);
                    } else {
                        list.add(this.slotId);
                    }
                    scroll.setSelection(list.stream().mapToInt(Integer::intValue).toArray());
                } else {
                    scroll.setSelection(this.slotId);
                }
                if (this.doubleClicked) {
                    scroll.onDoubleClick(container.activeGui);
                } else {
                    scroll.onClick(container.activeGui);
                }
                PlayerWrapper pw = (PlayerWrapper)NpcAPI.Instance().getIEntity((class_1297)this.player);
                EventHooks.onCustomGuiScrollClick(pw, container.activeGui, scroll, this.slotId, scroll.getSelectionList(), this.doubleClicked);
            }
        }
    }
}

