/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobConversation
extends JobInterface {
    public Availability availability = new Availability();
    private ArrayList<String> names = new ArrayList();
    private HashMap<String, EntityNPCInterface> npcs = new HashMap();
    public HashMap<Integer, ConversationLine> lines = new HashMap();
    public int quest = -1;
    public String questTitle = "";
    public int generalDelay = 400;
    public int ticks = 100;
    public int range = 20;
    private ConversationLine nextLine;
    private boolean hasStarted = false;
    private int startedTicks = 20;
    public int mode = 0;

    public JobConversation(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public class_2487 save(class_2487 compound) {
        compound.method_10566("ConversationAvailability", (class_2520)this.availability.save((class_7225.class_7874)this.npc.method_56673(), new class_2487()));
        compound.method_10569("ConversationQuest", this.quest);
        compound.method_10569("ConversationDelay", this.generalDelay);
        compound.method_10569("ConversationRange", this.range);
        compound.method_10569("ConversationMode", this.mode);
        class_2499 nbttaglist = new class_2499();
        for (int slot : this.lines.keySet()) {
            ConversationLine line = this.lines.get(slot);
            class_2487 nbttagcompound = new class_2487();
            nbttagcompound.method_10569("Slot", slot);
            line.addAdditionalSaveData(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.method_10566("ConversationLines", (class_2520)nbttaglist);
        if (this.hasQuest()) {
            compound.method_10582("ConversationQuestTitle", this.getQuest().title);
        }
        return compound;
    }

    @Override
    public void load(class_2487 compound) {
        this.names.clear();
        this.availability.load((class_7225.class_7874)this.npc.method_56673(), compound.method_10562("ConversationAvailability"));
        this.quest = compound.method_10550("ConversationQuest");
        this.generalDelay = compound.method_10550("ConversationDelay");
        this.questTitle = compound.method_10558("ConversationQuestTitle");
        this.range = compound.method_10550("ConversationRange");
        this.mode = compound.method_10550("ConversationMode");
        class_2499 nbttaglist = compound.method_10554("ConversationLines", 10);
        HashMap<Integer, ConversationLine> map = new HashMap<Integer, ConversationLine>();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            class_2487 nbttagcompound = nbttaglist.method_10602(i);
            ConversationLine line = new ConversationLine(this);
            line.readAdditionalSaveData(nbttagcompound);
            if (!line.npc.isEmpty() && !this.names.contains(line.npc.toLowerCase(Locale.ROOT))) {
                this.names.add(line.npc.toLowerCase(Locale.ROOT));
            }
            map.put(nbttagcompound.method_10550("Slot"), line);
        }
        this.lines = map;
        this.ticks = this.generalDelay;
    }

    public boolean hasQuest() {
        return this.getQuest() != null;
    }

    public Quest getQuest() {
        if (this.npc.isClientSide()) {
            return null;
        }
        return QuestController.instance.quests.get(this.quest);
    }

    @Override
    public void aiUpdateTask() {
        --this.ticks;
        if (this.ticks > 0 || this.nextLine == null) {
            return;
        }
        this.say(this.nextLine);
        boolean seenNext = false;
        ConversationLine compare = this.nextLine;
        this.nextLine = null;
        for (ConversationLine line : this.lines.values()) {
            if (line.isEmpty()) continue;
            if (seenNext) {
                this.nextLine = line;
                break;
            }
            if (line != compare) continue;
            seenNext = true;
        }
        if (this.nextLine != null) {
            this.ticks = this.nextLine.delay;
        } else if (this.hasQuest()) {
            List inRange = this.npc.method_37908().method_18467(class_1657.class, this.npc.method_5829().method_1009((double)this.range, (double)this.range, (double)this.range));
            for (class_1657 player : inRange) {
                if (!this.availability.isAvailable(player)) continue;
                PlayerQuestController.addActiveQuest(this.getQuest(), player);
            }
        }
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.lines.isEmpty() || this.npc.isKilled() || this.npc.isAttacking() || !this.shouldRun()) {
            return false;
        }
        if (!this.hasStarted && this.mode == 1) {
            if (this.startedTicks-- > 0) {
                return false;
            }
            this.startedTicks = 10;
            if (this.npc.method_37908().method_18467(class_1657.class, this.npc.method_5829().method_1009((double)this.range, (double)this.range, (double)this.range)).isEmpty()) {
                return false;
            }
        }
        for (ConversationLine line : this.lines.values()) {
            if (line == null || line.isEmpty()) continue;
            this.nextLine = line;
            break;
        }
        return this.nextLine != null;
    }

    private boolean shouldRun() {
        boolean bo;
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.npcs.clear();
        List list = this.npc.method_37908().method_18467(EntityNPCInterface.class, this.npc.method_5829().method_1009(10.0, 10.0, 10.0));
        for (EntityNPCInterface npc : list) {
            String name = npc.method_5477().getString().toLowerCase(Locale.ROOT);
            if (npc.isKilled() || npc.isAttacking() || !this.names.contains(name)) continue;
            this.npcs.put(name, npc);
        }
        boolean bl = bo = this.names.size() == this.npcs.size();
        if (!bo) {
            this.ticks = 20;
        }
        return bo;
    }

    @Override
    public boolean aiContinueExecute() {
        for (EntityNPCInterface npc : this.npcs.values()) {
            if (!npc.isKilled() && !npc.isAttacking()) continue;
            return false;
        }
        return this.nextLine != null;
    }

    @Override
    public void stop() {
        this.nextLine = null;
        this.ticks = this.generalDelay;
        this.hasStarted = false;
    }

    @Override
    public void aiStartExecuting() {
        this.startedTicks = 20;
        this.hasStarted = true;
    }

    private void say(ConversationLine line) {
        List inRange = this.npc.method_37908().method_18467(class_1657.class, this.npc.method_5829().method_1009((double)this.range, (double)this.range, (double)this.range));
        EntityNPCInterface npc = this.npcs.get(line.npc.toLowerCase(Locale.ROOT));
        if (npc == null) {
            return;
        }
        for (class_1657 player : inRange) {
            if (!this.availability.isAvailable(player)) continue;
            npc.say(player, line);
        }
    }

    @Override
    public void reset() {
        this.hasStarted = false;
        this.stop();
        this.ticks = 60;
    }

    @Override
    public void killed() {
        this.reset();
    }

    public ConversationLine getLine(int slot) {
        if (this.lines.containsKey(slot)) {
            return this.lines.get(slot);
        }
        ConversationLine line = new ConversationLine(this);
        this.lines.put(slot, line);
        return line;
    }

    @Override
    public int getType() {
        return 7;
    }

    public class ConversationLine
    extends Line {
        public String npc = "";
        public int delay = 40;

        public ConversationLine(JobConversation this$0) {
        }

        public void addAdditionalSaveData(class_2487 compound) {
            compound.method_10582("Line", this.text);
            compound.method_10582("Npc", this.npc);
            compound.method_10582("Sound", this.sound);
            compound.method_10569("Delay", this.delay);
        }

        public void readAdditionalSaveData(class_2487 compound) {
            this.text = compound.method_10558("Line");
            this.npc = compound.method_10558("Npc");
            this.sound = compound.method_10558("Sound");
            this.delay = compound.method_10550("Delay");
        }

        public boolean isEmpty() {
            return this.npc.isEmpty() || this.text.isEmpty();
        }
    }
}

