/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2513;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_4538;
import net.minecraft.class_52;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.role.IJobFarmer;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.data.BlockData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobFarmer
extends JobInterface
implements MassBlockController.IMassBlock,
IJobFarmer {
    public int chestMode = 1;
    private List<class_2338> trackedBlocks = new ArrayList<class_2338>();
    private int ticks = 0;
    private int walkTicks = 0;
    private int blockTicks = 800;
    private boolean waitingForBlocks = false;
    private class_2338 ripe = null;
    private class_2338 chest = null;
    private class_1799 holding = class_1799.field_8037;

    public JobFarmer(EntityNPCInterface npc) {
        super(npc);
        this.overrideMainHand = true;
    }

    @Override
    public IItemStack getMainhand() {
        String name = this.npc.getJobData();
        class_1799 item = this.stringToItem(name);
        if (item.method_7960()) {
            return this.npc.inventory.weapons.get(0);
        }
        return NpcAPI.Instance().getIItemStack(item);
    }

    @Override
    public class_2487 save(class_2487 compound) {
        compound.method_10569("JobChestMode", this.chestMode);
        if (!this.holding.method_7960()) {
            compound.method_10566("JobHolding", this.holding.method_57376((class_7225.class_7874)this.npc.method_56673(), (class_2520)new class_2487()));
        }
        return compound;
    }

    @Override
    public void load(class_2487 compound) {
        this.chestMode = compound.method_10550("JobChestMode");
        this.holding = class_1799.method_57359((class_7225.class_7874)this.npc.method_56673(), (class_2487)compound.method_10562("JobHolding"));
        this.blockTicks = 1100;
    }

    public void setHolding(class_1799 item) {
        this.holding = item;
        this.npc.setJobData(this.itemToString(this.holding));
    }

    @Override
    public boolean aiShouldExecute() {
        if (!this.holding.method_7960()) {
            if (this.chestMode == 0) {
                this.setHolding(class_1799.field_8037);
            } else if (this.chestMode == 1) {
                if (this.chest == null) {
                    this.dropItem(this.holding);
                    this.setHolding(class_1799.field_8037);
                } else {
                    this.chest();
                }
            } else if (this.chestMode == 2) {
                this.dropItem(this.holding);
                this.setHolding(class_1799.field_8037);
            }
            return false;
        }
        if (this.ripe != null) {
            this.pluck();
            return false;
        }
        if (!this.waitingForBlocks && this.blockTicks++ > 1200) {
            this.blockTicks = 0;
            this.waitingForBlocks = true;
            MassBlockController.Queue(this);
        }
        if (this.ticks++ < 100) {
            return false;
        }
        this.ticks = 0;
        return true;
    }

    private void dropItem(class_1799 item) {
        class_1542 entityitem = new class_1542(this.npc.method_37908(), this.npc.method_23317(), this.npc.method_23318(), this.npc.method_23321(), item);
        entityitem.method_6988();
        this.npc.method_37908().method_8649((class_1297)entityitem);
    }

    private void chest() {
        class_2338 pos = this.chest;
        this.npc.method_5942().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.0);
        this.npc.method_5988().method_6230((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10.0f, (float)this.npc.method_5978());
        if (this.npc.nearPosition(pos) || this.walkTicks++ > 400) {
            class_1263 inventory;
            if (this.walkTicks < 400) {
                this.npc.method_6104(class_1268.field_5808);
            }
            this.npc.method_5942().method_6340();
            this.ticks = 100;
            this.walkTicks = 0;
            class_2680 state = this.npc.method_37908().method_8320(pos);
            class_2586 tile = this.npc.method_37908().method_8321(pos);
            class_1263 class_12632 = inventory = tile instanceof class_1263 ? (class_1263)tile : null;
            if (state.method_26204() instanceof class_2281) {
                inventory = class_2281.method_17458((class_2281)((class_2281)state.method_26204()), (class_2680)state, (class_1937)this.npc.method_37908(), (class_2338)pos, (boolean)true);
            }
            if (inventory != null) {
                int i;
                for (i = 0; !this.holding.method_7960() && i < inventory.method_5439(); ++i) {
                    this.holding = this.mergeStack(inventory, i, this.holding);
                }
                for (i = 0; !this.holding.method_7960() && i < inventory.method_5439(); ++i) {
                    class_1799 item = inventory.method_5438(i);
                    if (!item.method_7960()) continue;
                    inventory.method_5447(i, this.holding);
                    this.holding = class_1799.field_8037;
                }
                if (!this.holding.method_7960()) {
                    this.dropItem(this.holding);
                    this.holding = class_1799.field_8037;
                }
            } else {
                this.chest = null;
            }
            this.setHolding(this.holding);
        }
    }

    private class_1799 mergeStack(class_1263 inventory, int slot, class_1799 item) {
        class_1799 item2 = inventory.method_5438(slot);
        if (!NoppesUtilPlayer.compareItems(item, item2, false, false)) {
            return item;
        }
        int size = item2.method_7914() - item2.method_7947();
        if (size >= item.method_7947()) {
            item2.method_7939(item2.method_7947() + item.method_7947());
            return class_1799.field_8037;
        }
        item2.method_7939(item2.method_7914());
        item.method_7939(item.method_7947() - size);
        if (item.method_7960()) {
            return class_1799.field_8037;
        }
        return item;
    }

    private void pluck() {
        class_2338 pos = this.ripe;
        this.npc.method_5942().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.0);
        this.npc.method_5988().method_6230((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10.0f, (float)this.npc.method_5978());
        if (this.npc.nearPosition(pos) || this.walkTicks++ > 400) {
            if (this.walkTicks > 400) {
                pos = NoppesUtilServer.GetClosePos(pos, this.npc.method_37908());
                this.npc.method_5859((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            }
            this.ripe = null;
            this.npc.method_5942().method_6340();
            this.ticks = 90;
            this.walkTicks = 0;
            this.npc.method_6104(class_1268.field_5808);
            class_2680 state = this.npc.method_37908().method_8320(pos);
            class_2248 b = state.method_26204();
            if (b instanceof class_2302 && ((class_2302)b).method_9825(state)) {
                class_2302 crop = (class_2302)b;
                class_1792 item = crop.method_9574((class_4538)this.npc.method_37908(), pos, state).method_7909();
                class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.npc.method_37908()).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)this.npc.method_6047()).method_51874(class_181.field_1224, (Object)state).method_51877(class_181.field_1228, (Object)this.npc.method_37908().method_8321(pos));
                class_52 loottable = this.npc.method_5682().method_58576().method_58295(b.method_26162());
                ObjectArrayList l = loottable.method_51878(builder.method_51875(class_173.field_1172));
                this.npc.method_37908().method_8652(pos, crop.method_9828(0), 2);
                if (l.isEmpty()) {
                    this.holding = class_1799.field_8037;
                } else if (l.size() == 1) {
                    this.holding = (class_1799)l.get(0);
                } else {
                    ObjectArrayList fl = l.stream().filter(t -> t.method_7909() != item).collect(Collectors.toList());
                    if (fl.isEmpty()) {
                        fl = l;
                    }
                    this.holding = (class_1799)fl.get(this.npc.method_59922().method_43048(fl.size()));
                }
                this.holding.method_7939(1);
            }
            if (b == class_2246.field_46282 || b == class_2246.field_46283) {
                b = this.npc.method_37908().method_8320(pos).method_26204();
                this.npc.method_37908().method_8650(pos, false);
                this.holding = new class_1799((class_1935)b);
            }
            this.setHolding(this.holding);
        }
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void aiUpdateTask() {
        Iterator<class_2338> ite = this.trackedBlocks.iterator();
        while (ite.hasNext() && this.ripe == null) {
            class_2338 pos = ite.next();
            class_2680 state = this.npc.method_37908().method_8320(pos);
            class_2248 b = state.method_26204();
            if ((b instanceof class_2302 && ((class_2302)b).method_9825(state) || b == class_2246.field_46282 || b == class_2246.field_46283) && b.method_26162() != class_39.field_844) {
                this.ripe = pos;
                continue;
            }
            ite.remove();
        }
        boolean bl = this.npc.ais.returnToStart = this.ripe == null;
        if (this.ripe != null) {
            this.npc.method_5942().method_6340();
            this.npc.method_5988().method_6230((double)this.ripe.method_10263(), (double)this.ripe.method_10264(), (double)this.ripe.method_10260(), 10.0f, (float)this.npc.method_5978());
        }
    }

    @Override
    public boolean isPlucking() {
        return this.ripe != null || !this.holding.method_7960();
    }

    @Override
    public EntityNPCInterface getNpc() {
        return this.npc;
    }

    @Override
    public int getRange() {
        return 16;
    }

    @Override
    public void processed(List<BlockData> list) {
        ArrayList<class_2338> trackedBlocks = new ArrayList<class_2338>();
        class_2338 chest = null;
        for (BlockData data : list) {
            class_2586 tile = this.npc.method_37908().method_8321(data.pos);
            class_2248 b = data.state.method_26204();
            if (tile instanceof class_2621) {
                if (chest != null && !(this.npc.method_5649(chest.method_10263(), chest.method_10264(), chest.method_10260()) > this.npc.method_5649(data.pos.method_10263(), data.pos.method_10264(), data.pos.method_10260()))) continue;
                chest = data.pos;
                continue;
            }
            if (!(b instanceof class_2302) && !(b instanceof class_2513) || trackedBlocks.contains(data.pos)) continue;
            trackedBlocks.add(data.pos);
        }
        this.chest = chest;
        this.trackedBlocks = trackedBlocks;
        this.waitingForBlocks = false;
    }

    @Override
    public EnumSet<class_1352.class_4134> getFlags() {
        return EnumSet.of(class_1352.class_4134.field_18405);
    }

    @Override
    public int getType() {
        return 11;
    }
}

