/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import noppes.npcs.schematics.Blueprint;

public class BlueprintUtil {
    public static class_2487 writeBlueprintToNBT(Blueprint schem) {
        class_2487 compound = new class_2487();
        compound.method_10567("version", (byte)1);
        compound.method_10575("size_x", schem.getSizeX());
        compound.method_10575("size_y", schem.getSizeY());
        compound.method_10575("size_z", schem.getSizeZ());
        class_2680[] palette = schem.getPallete();
        class_2499 paletteTag = new class_2499();
        for (short i = 0; i < schem.getPalleteSize(); i = (short)(i + 1)) {
            paletteTag.add((Object)class_2512.method_10686((class_2680)palette[i]));
        }
        compound.method_10566("palette", (class_2520)paletteTag);
        int[] blockInt = BlueprintUtil.convertBlocksToSaveData(schem.getStructure(), schem.getSizeX(), schem.getSizeY(), schem.getSizeZ());
        compound.method_10539("blocks", blockInt);
        class_2499 finishedTes = new class_2499();
        class_2487[] tes = schem.getTileEntities();
        for (int i = 0; i < tes.length; ++i) {
            finishedTes.add((Object)tes[i]);
        }
        compound.method_10566("tile_entities", (class_2520)finishedTes);
        List<String> requiredMods = schem.getRequiredMods();
        class_2499 modsList = new class_2499();
        for (int i = 0; i < requiredMods.size(); ++i) {
            modsList.add((Object)class_2519.method_23256((String)requiredMods.get(i)));
        }
        compound.method_10566("required_mods", (class_2520)modsList);
        String name = schem.getName();
        String[] architects = schem.getArchitects();
        if (name != null) {
            compound.method_10582("name", name);
        }
        if (architects != null) {
            class_2499 architectsTag = new class_2499();
            for (String architect : architects) {
                architectsTag.add((Object)class_2519.method_23256((String)architect));
            }
            compound.method_10566("architects", (class_2520)architectsTag);
        }
        return compound;
    }

    public static Blueprint readBlueprintFromNBT(class_2487 tag) {
        byte version = tag.method_10571("version");
        if (version == 1) {
            short sizeX = tag.method_10568("size_x");
            short sizeY = tag.method_10568("size_y");
            short sizeZ = tag.method_10568("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            class_2499 modsList = tag.method_10554("required_mods", 8);
            int modListSize = modsList.size();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(((class_2519)modsList.method_10534(i)).method_10714());
                if (FabricLoader.getInstance().isModLoaded((String)requiredMods.get(i))) continue;
                Logger.getGlobal().log(Level.WARNING, "Couldn't load Blueprint, the following mod is missing: " + (String)requiredMods.get(i));
                return null;
            }
            class_2499 paletteTag = tag.method_10554("palette", 10);
            short paletteSize = (short)paletteTag.size();
            class_2680[] palette = new class_2680[paletteSize];
            for (int i = 0; i < palette.length; i = (int)((short)(i + 1))) {
                palette[i] = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)paletteTag.method_10602(i));
            }
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.method_10561("blocks"), sizeX, sizeY, sizeZ);
            class_2499 teTag = tag.method_10554("tile_entities", 10);
            class_2487[] tileEntities = new class_2487[teTag.size()];
            for (int i = 0; i < tileEntities.length; i = (int)((short)(i + 1))) {
                tileEntities[i] = teTag.method_10602(i);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, paletteSize, palette, blocks, tileEntities, requiredMods);
            if (tag.method_10545("name")) {
                schem.setName(tag.method_10558("name"));
            }
            if (tag.method_10545("architects")) {
                class_2499 architectsTag = tag.method_10554("architects", 8);
                String[] architects = new String[architectsTag.size()];
                for (int i = 0; i < architectsTag.size(); ++i) {
                    architects[i] = architectsTag.method_10608(i);
                }
                schem.setArchitects(architects);
            }
            return schem;
        }
        return null;
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        int currentInt = 0;
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
            currentInt = 0;
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }

    public static short[][][] convertSaveDataToBlocks(int[] ints, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[ints.length * 2];
        for (int i = 0; i < ints.length; ++i) {
            oneDimArray[i * 2] = (short)(ints[i] >> 16);
            oneDimArray[i * 2 + 1] = (short)ints[i];
        }
        short[][][] multDimArray = new short[sizeY][sizeZ][sizeX];
        int i = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    multDimArray[y][z][x] = oneDimArray[i++];
                }
            }
        }
        return multDimArray;
    }
}

