/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1329;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_2751;
import net.minecraft.class_2757;
import net.minecraft.class_2995;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import nikedemos.markovnames.generators.MarkovGenerator;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomContainer;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomTabs;
import noppes.npcs.ScriptPlayerEventHandler;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.ServerTickHandler;
import noppes.npcs.SkinEventHandler;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.command.CmdNoppes;
import noppes.npcs.command.CmdSchematics;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.ScoreBoardMixin;
import noppes.npcs.packets.Packets;
import noppes.npcs.shared.common.util.LogWriter;

public class CustomNpcs
implements ModInitializer,
CommandRegistrationCallback,
ServerLifecycleEvents.ServerStarting,
ServerLifecycleEvents.ServerStarted {
    public static final String MODID = "customnpcs";
    public static final String VERSION = "1.20.1";
    @ConfigProp(info="Whether scripting is enabled or not")
    public static boolean EnableScripting = true;
    @ConfigProp(info="Arguments given to the Nashorn scripting library")
    public static String NashorArguments = "-strict";
    @ConfigProp(info="Disable Chat Bubbles")
    public static boolean EnableChatBubbles = true;
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Limit too how many npcs can be in one chunk for natural spawning")
    public static int NpcNaturalSpawningChunkLimit = 4;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp(info="If set to true only opped people can use the /noppes command")
    public static boolean NoppesCommandOpOnly = false;
    @ConfigProp
    public static boolean InventoryGuiEnabled = true;
    public static boolean FixUpdateFromPre_1_12 = false;
    public static boolean DisablePermissions = false;
    @ConfigProp
    public static boolean SceneButtonsEnabled = true;
    public static long ticks;
    @ConfigProp(info="Enables CustomNpcs startup update message")
    public static boolean EnableUpdateChecker;
    public static CustomNpcs instance;
    public static boolean FreezeNPCs;
    public static boolean OpsOnly;
    @ConfigProp(info="Default interact line. Leave empty to not have one")
    public static String DefaultInteractLine;
    @ConfigProp(info="Number of chunk loading npcs that can be active at the same time")
    public static int ChuckLoaders;
    public static File Dir;
    @ConfigProp(info="Enables leaves decay")
    public static boolean LeavesDecayEnabled;
    @ConfigProp(info="Enables Vine Growth")
    public static boolean VineGrowthEnabled;
    @ConfigProp(info="Enables Ice Melting")
    public static boolean IceMeltsEnabled;
    @ConfigProp(info="Normal players can use soulstone on animals")
    public static boolean SoulStoneAnimals;
    @ConfigProp(info="Normal players can use soulstone on all npcs")
    public static boolean SoulStoneNPCs;
    @ConfigProp(info="Type 0 = Normal, Type 1 = Solid")
    public static int HeadWearType;
    @ConfigProp(info="When set to Minecraft it will use minecrafts font, when Default it will use OpenSans. Can only use fonts installed on your PC")
    public static String FontType;
    @ConfigProp(info="Font size for custom fonts (doesn't work with minecrafts font)")
    public static int FontSize;
    @ConfigProp(info="On some servers or with certain plugins, it doesnt work, so you can disable it here")
    public static boolean EnableInvisibleNpcs;
    @ConfigProp
    public static boolean NpcSpeachTriggersChatEvent;
    public static ConfigLoader Config;
    public static boolean VerboseDebug;
    public static MinecraftServer Server;
    public static CommonProxy proxy;

    public static File getLevelSaveDirectory() {
        return CustomNpcs.getLevelSaveDirectory(null);
    }

    public static File getLevelSaveDirectory(String s) {
        try {
            File dir = new File(".");
            if (Server != null) {
                if (!Server.method_3816()) {
                    dir = new File(class_310.method_1551().field_1697, "saves");
                }
                dir = Server.method_27050(new class_5218(MODID)).toFile();
            }
            if (s != null) {
                dir = new File(dir, s);
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
        catch (Exception e) {
            LogWriter.error("Error getting worldsave", e);
            return null;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (IllegalAccessException e) {
            LogWriter.error("setPrivateValue error", e);
        }
    }

    public void onInitialize() {
        instance = this;
        File dir = new File(Paths.get("config", new String[0]).toFile(), "..");
        Config = new ConfigLoader(this.getClass(), new File(dir, "config"), "CustomNpcs");
        Config.loadConfig();
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        CustomBlocks.registerBlocks();
        CustomItems.registerItems();
        CustomTabs.registerCreativeTab();
        CustomEntities.registerEntities();
        CustomEntities.attribute();
        CustomContainer.registerContainers();
        Packets.register();
        ServerLifecycleEvents.SERVER_STARTING.register((Object)this);
        ServerLifecycleEvents.SERVER_STARTED.register((Object)this);
        ServerTickEvents.END_SERVER_TICK.register((Object)new SkinEventHandler());
        ServerPlayConnectionEvents.JOIN.register((Object)new SkinEventHandler());
        UseEntityCallback.EVENT.register((Object)new ServerEventsHandler());
        ServerLivingEntityEvents.AFTER_DEATH.register((Object)new ServerEventsHandler());
        ServerTickEvents.START_SERVER_TICK.register((Object)new ServerTickHandler());
        ServerPlayConnectionEvents.JOIN.register((Object)new ServerTickHandler());
        CommandRegistrationCallback.EVENT.register((Object)this);
        proxy.load();
        PixelmonHelper.load();
        ScriptController controller = new ScriptController();
        if (EnableScripting && controller.languages.size() > 0) {
            ServerTickEvents.START_SERVER_TICK.register((Object)new ScriptPlayerEventHandler());
            AttackBlockCallback.EVENT.register((Object)new ScriptPlayerEventHandler());
            UseBlockCallback.EVENT.register((Object)new ScriptPlayerEventHandler());
            UseEntityCallback.EVENT.register((Object)new ScriptPlayerEventHandler());
            UseItemCallback.EVENT.register((Object)new ScriptPlayerEventHandler());
            PlayerBlockBreakEvents.BEFORE.register((Object)new ScriptPlayerEventHandler());
            ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((Object)new ScriptPlayerEventHandler());
            ServerLivingEntityEvents.ALLOW_DAMAGE.register((Object)new ScriptPlayerEventHandler());
            ServerLivingEntityEvents.ALLOW_DEATH.register((Object)new ScriptPlayerEventHandler());
            ServerPlayConnectionEvents.JOIN.register((Object)new ScriptPlayerEventHandler());
            ServerPlayConnectionEvents.DISCONNECT.register((Object)new ScriptPlayerEventHandler());
        }
        CustomNpcs.setPrivateValue(class_1329.class, (class_1329)class_5134.field_23716, Double.MAX_VALUE, 1);
        new RecipeController();
        proxy.postload();
        CustomItems.registerDispenser();
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        CmdNoppes.register(dispatcher);
    }

    public void onServerStarted(MinecraftServer server) {
        EntityNPCInterface.ChatEventPlayer = FakePlayer.get((class_3218)server.method_3847(class_1937.field_25179), (GameProfile)EntityNPCInterface.ChatEventProfile);
        EntityNPCInterface.CommandPlayer = FakePlayer.get((class_3218)server.method_3847(class_1937.field_25179), (GameProfile)EntityNPCInterface.CommandProfile);
        EntityNPCInterface.GenericPlayer = FakePlayer.get((class_3218)server.method_3847(class_1937.field_25179), (GameProfile)EntityNPCInterface.GenericProfile);
        for (class_3218 level : Server.method_3738()) {
            class_2995 board = level.method_14170();
            board.method_12935(() -> {
                for (String objective : Availability.scores) {
                    class_266 so = board.method_1170(objective);
                    if (so == null) continue;
                    for (class_3222 player : Server.method_3760().method_14571()) {
                        if (!board.method_1183(player.method_5820(), so) && board.method_12936(so) == 0) {
                            player.field_13987.method_14364((class_2596)new class_2751(so, 0));
                        }
                        ScoreBoardMixin mixin = (ScoreBoardMixin)board;
                        Map map = mixin.getScores().computeIfAbsent(player.method_5820(), p_197898_0_ -> Maps.newHashMap());
                        class_267 sco = map.computeIfAbsent(so, ob -> new class_267((class_269)board, ob, player.method_5820()));
                        player.field_13987.method_14364((class_2596)new class_2757(class_2995.class_2996.field_13431, so.method_1113(), sco.method_1129(), sco.method_1126()));
                    }
                }
            });
            board.method_12935(() -> {
                List players = Server.method_3760().method_14571();
                for (class_3222 playerMP : players) {
                    VisibilityController.instance.onUpdate(playerMP);
                }
            });
        }
        RecipeController.instance.load();
        new BankController();
        ServerCloneController.Instance = new ServerCloneController();
        DialogController.instance.load();
        QuestController.instance.load();
        ScriptController.HasStart = true;
    }

    public void onServerStarting(MinecraftServer server) {
        Availability.scores.clear();
        Server = server;
        MarkovGenerator.load();
        ChunkController.instance.clear();
        FactionController.instance.load();
        new PlayerDataController();
        new TransportController();
        new GlobalDataController();
        new SpawnController();
        new LinkedNpcController();
        new MassBlockController();
        VisibilityController.instance = new VisibilityController();
        ScriptController.Instance.loadCategories();
        ScriptController.Instance.loadStoredData();
        ScriptController.Instance.loadPlayerScripts();
        ScriptController.Instance.loadForgeScripts();
        ScriptController.HasStart = false;
        WrapperNpcAPI.clearCache();
        CmdSchematics.names.clear();
        CmdSchematics.names.addAll(SchematicController.Instance.list());
    }

    static {
        EnableUpdateChecker = true;
        FreezeNPCs = false;
        OpsOnly = true;
        DefaultInteractLine = "Hello @p";
        ChuckLoaders = 20;
        LeavesDecayEnabled = true;
        VineGrowthEnabled = true;
        IceMeltsEnabled = true;
        SoulStoneAnimals = true;
        SoulStoneNPCs = false;
        HeadWearType = 1;
        FontType = "Default";
        FontSize = 18;
        EnableInvisibleNpcs = true;
        NpcSpeachTriggersChatEvent = false;
        VerboseDebug = false;
        proxy = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? new ClientProxy() : new CommonProxy();
        File dir = new File(Paths.get("config", new String[0]).toFile(), "..");
        Dir = new File(dir, MODID);
        if (!Dir.exists()) {
            Dir.mkdir();
        }
    }
}

