/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import noppes.npcs.ModelEyeData;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.client.parts.MpmPart;
import noppes.npcs.client.parts.MpmPartData;
import noppes.npcs.constants.BodyPart;
import noppes.npcs.constants.EnumParts;

public abstract class ModelDataShared {
    public ModelPartConfig arm1 = new ModelPartConfig();
    public ModelPartConfig arm2 = new ModelPartConfig();
    public ModelPartConfig body = new ModelPartConfig();
    public ModelPartConfig leg1 = new ModelPartConfig();
    public ModelPartConfig leg2 = new ModelPartConfig();
    public ModelPartConfig head = new ModelPartConfig();
    protected class_2960 entityName = null;
    protected class_1309 entity;
    public class_2487 extra = new class_2487();
    public class_2499 oldPartData = new class_2499();
    public List<MpmPartData> mpmParts = new ArrayList<MpmPartData>();
    public List<BodyPart> hiddenParts = new ArrayList<BodyPart>();
    public int wingMode = 0;
    public String url = "";
    public String displayName = "";
    public long lastEdited = System.currentTimeMillis();
    public int inLove = 0;
    public int animationTime = -1;
    public int modelType = 0;
    public int moveAnimation = 16;
    public int prevMoveAnimation = 16;
    public boolean startMoveAnimation = false;
    public int animation = 0;
    public int prevAnimation = 0;
    public boolean startAnimation = false;
    public int animationStart = 0;
    public float sleepRotation;

    public class_2487 save() {
        class_2487 compound = new class_2487();
        if (this.entityName != null) {
            compound.method_10582("EntityName", this.entityName.toString());
        }
        compound.method_10566("ArmsConfig", (class_2520)this.arm1.writeToNBT());
        compound.method_10566("Arms2Config", (class_2520)this.arm2.writeToNBT());
        compound.method_10566("BodyConfig", (class_2520)this.body.writeToNBT());
        compound.method_10566("LegsConfig", (class_2520)this.leg1.writeToNBT());
        compound.method_10566("Legs2Config", (class_2520)this.leg2.writeToNBT());
        compound.method_10566("HeadConfig", (class_2520)this.head.writeToNBT());
        compound.method_10566("ExtraData", (class_2520)this.extra);
        compound.method_10569("WingMode", this.wingMode);
        compound.method_10582("CustomSkinUrl", this.url);
        compound.method_10582("DisplayName", this.displayName);
        compound.method_10569("Animation", this.animation);
        compound.method_10569("MoveAnimation", this.moveAnimation);
        compound.method_10569("ModelType", this.modelType);
        compound.method_10544("LastEdited", this.lastEdited);
        compound.method_10566("Parts", (class_2520)this.oldPartData);
        class_2499 list = new class_2499();
        for (MpmPartData e : this.mpmParts) {
            list.add((Object)e.getNbt());
        }
        compound.method_10566("NewParts", (class_2520)list);
        return compound;
    }

    public void load(class_2487 compound) {
        int i;
        String rl = compound.method_10558("EntityName");
        this.setEntity(rl.isEmpty() ? null : new class_2960(rl));
        this.arm1.readFromNBT(compound.method_10562("ArmsConfig"));
        this.arm2.readFromNBT(compound.method_10562("Arms2Config"));
        this.body.readFromNBT(compound.method_10562("BodyConfig"));
        this.leg1.readFromNBT(compound.method_10562("LegsConfig"));
        this.leg2.readFromNBT(compound.method_10562("Legs2Config"));
        this.head.readFromNBT(compound.method_10562("HeadConfig"));
        this.extra = compound.method_10562("ExtraData");
        this.wingMode = compound.method_10550("WingMode");
        this.url = compound.method_10558("CustomSkinUrl");
        this.displayName = compound.method_10558("DisplayName");
        this.animation = compound.method_10550("Animation");
        this.moveAnimation = compound.method_10550("MoveAnimation");
        this.modelType = compound.method_10550("ModelType");
        this.lastEdited = compound.method_10537("LastEdited");
        ArrayList<MpmPartData> mpmParts = new ArrayList<MpmPartData>();
        class_2499 list = compound.method_10554("NewParts", 10);
        for (i = 0; i < list.size(); ++i) {
            MpmPartData part = new MpmPartData();
            part.setNbt(list.method_10602(i));
            if (part.partId.equals((Object)ModelEyeData.RESOURCE) || part.partId.equals((Object)ModelEyeData.RESOURCE_RIGHT) || part.partId.equals((Object)ModelEyeData.RESOURCE_LEFT)) {
                part = new ModelEyeData();
                part.setNbt(list.method_10602(i));
            }
            mpmParts.add(part);
        }
        this.mpmParts = mpmParts;
        this.oldPartData = compound.method_10554("Parts", 10);
        if (this.mpmParts.isEmpty()) {
            for (i = 0; i < list.size(); ++i) {
                this.mpmParts.add(EnumParts.convertOldPart(list.method_10602(i)));
            }
        }
        this.refreshParts();
        this.updateTransate();
    }

    public void setMoveAnimation(int ani) {
        this.startMoveAnimation = this.moveAnimation != ani;
        this.moveAnimation = ani;
    }

    public int getMoveAnimtion(class_1309 player) {
        if (player.method_5765()) {
            return 1;
        }
        if (player.method_6113()) {
            return 2;
        }
        if (this.moveAnimation == 16 && player.method_18276()) {
            return 4;
        }
        return this.moveAnimation;
    }

    public boolean isMovementAnimation(int ani) {
        return ani == 2 || ani == 7 || ani == 4 || ani == 1 || ani == 14 || ani == 15 || ani == 16 || ani == 18 || ani == 17;
    }

    public void setAnimation(int ani) {
        if (this.isMovementAnimation(ani)) {
            this.setMoveAnimation(ani);
            return;
        }
        this.animationTime = -1;
        this.animation = ani;
        this.lastEdited = System.currentTimeMillis();
        boolean bl = this.startAnimation = this.animation != ani;
        if (this.animation == 10) {
            this.animationTime = 80;
        }
        if (this.animation == 13 || this.animation == 12) {
            this.animationTime = 60;
        }
        this.animationStart = this.getOwner() == null || ani == 0 ? -1 : this.getOwner().field_6012;
    }

    public void updateTransate() {
        for (EnumParts part : EnumParts.values()) {
            float y;
            float x;
            ModelPartConfig body;
            ModelPartConfig config = this.getPartConfig(part);
            if (config == null) continue;
            if (part == EnumParts.HEAD) {
                config.setTranslate(0.0f, this.getBodyY(), 0.0f);
                continue;
            }
            if (part == EnumParts.ARM_LEFT) {
                body = this.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scaleX) * 0.25f + (1.0f - config.scaleX) * 0.0625f;
                y = this.getBodyY() + (1.0f - config.scaleY) * -0.125f;
                config.setTranslate(-x, y, 0.0f);
                if (config.notShared) continue;
                ModelPartConfig arm = this.getPartConfig(EnumParts.ARM_RIGHT);
                arm.copyValues(config);
                continue;
            }
            if (part == EnumParts.ARM_RIGHT) {
                body = this.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scaleX) * 0.25f + (1.0f - config.scaleX) * 0.0625f;
                y = this.getBodyY() + (1.0f - config.scaleY) * -0.125f;
                config.setTranslate(x, y, 0.0f);
                continue;
            }
            if (part == EnumParts.LEG_LEFT) {
                config.setTranslate(-(1.0f - config.scaleX) * 0.118f, this.getLegsY(), -(1.0f - config.scaleZ) * 0.00625f);
                if (config.notShared) continue;
                ModelPartConfig leg = this.getPartConfig(EnumParts.LEG_RIGHT);
                leg.copyValues(config);
                continue;
            }
            if (part == EnumParts.LEG_RIGHT) {
                config.setTranslate((1.0f - config.scaleX) * 0.118f, this.getLegsY(), -(1.0f - config.scaleZ) * 0.00625f);
                continue;
            }
            if (part != EnumParts.BODY) continue;
            config.setTranslate(0.0f, this.getBodyY(), 0.0f);
        }
    }

    public void setEntity(class_2960 resourceLocation) {
        this.entityName = resourceLocation;
        this.clearEntity();
        this.extra = new class_2487();
    }

    public class_2960 getEntityName() {
        return this.entityName;
    }

    public boolean hasEntity() {
        return this.entityName != null;
    }

    public float offsetY() {
        if (this.entity == null) {
            return -this.getBodyY();
        }
        return this.entity.method_17682() - 1.8f;
    }

    public void clearEntity() {
        this.entity = null;
    }

    public ModelPartConfig getPartConfig(EnumParts type) {
        if (type == EnumParts.BODY) {
            return this.body;
        }
        if (type == EnumParts.ARM_LEFT) {
            return this.arm1;
        }
        if (type == EnumParts.ARM_RIGHT) {
            return this.arm2;
        }
        if (type == EnumParts.LEG_LEFT) {
            return this.leg1;
        }
        if (type == EnumParts.LEG_RIGHT) {
            return this.leg2;
        }
        return this.head;
    }

    public abstract class_1309 getOwner();

    public float getBodyY() {
        if (this.entity != null) {
            return this.entity.method_17682();
        }
        return (1.0f - this.body.scaleY) * 0.75f + this.getLegsY();
    }

    public float getLegsY() {
        ModelPartConfig legs = this.leg1;
        if (this.leg1.notShared && this.leg2.scaleY > this.leg1.scaleY) {
            legs = this.leg2;
        }
        return (1.0f - legs.scaleY) * 0.75f;
    }

    public void refreshParts() {
        this.hiddenParts = this.mpmParts.stream().flatMap(part -> {
            MpmPart p = part.getPart();
            if (p != null) {
                return p.hiddenParts.stream();
            }
            return Stream.empty();
        }).distinct().collect(Collectors.toList());
    }
}

