/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1682;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.CustomContainer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketDialog;
import noppes.npcs.packets.client.PacketDialogDummy;
import noppes.npcs.packets.client.PacketGuiClose;
import noppes.npcs.packets.client.PacketGuiError;
import noppes.npcs.packets.client.PacketGuiScrollData;
import noppes.npcs.packets.client.PacketNpcEdit;
import noppes.npcs.packets.client.PacketParticle;
import noppes.npcs.packets.server.SPacketGuiOpen;
import noppes.npcs.shared.common.CommonUtil;
import noppes.npcs.shared.common.util.LogWriter;

public class NoppesUtilServer {
    private static HashMap<UUID, Quest> editingQuests = new HashMap();
    private static HashMap<UUID, Quest> editingQuestsClient = new HashMap();

    public static void setEditingNpc(class_1657 player, EntityNPCInterface npc) {
        PlayerData data = PlayerData.get(player);
        data.editingNpc = npc;
        if (npc != null) {
            Packets.send((class_3222)player, new PacketNpcEdit(npc.method_5628()));
        }
    }

    public static EntityNPCInterface getEditingNpc(class_1657 player) {
        PlayerData data = PlayerData.get(player);
        return data.editingNpc;
    }

    public static void setEditingQuest(class_1657 player, Quest quest) {
        if (player.method_37908().field_9236) {
            editingQuestsClient.put(player.method_5667(), quest);
        } else {
            editingQuests.put(player.method_5667(), quest);
        }
    }

    public static Quest getEditingQuest(class_1657 player) {
        if (player.method_37908().field_9236) {
            return editingQuestsClient.get(player.method_5667());
        }
        return editingQuests.get(player.method_5667());
    }

    public static void openDialog(class_1657 player, EntityNPCInterface npc, Dialog dia) {
        Dialog dialog = dia.copy(player);
        PlayerData playerdata = PlayerData.get(player);
        if (EventHooks.onNPCDialog(npc, player, dialog)) {
            playerdata.dialogId = -1;
            return;
        }
        playerdata.dialogId = dialog.id;
        if (npc instanceof EntityDialogNpc || dia.id < 0) {
            dialog.hideNPC = true;
            Packets.send((class_3222)player, new PacketDialogDummy(npc.method_5477().getString(), dialog.save(new class_2487())));
        } else {
            Packets.send((class_3222)player, new PacketDialog(npc.method_5628(), dialog.id));
        }
        dia.factionOptions.addPoints(player);
        if (dialog.hasQuest()) {
            PlayerQuestController.addActiveQuest(dialog.getQuest(), player);
        }
        if (!dialog.command.isEmpty()) {
            NoppesUtilServer.runCommand((class_1297)npc, npc.method_5477().getString(), dialog.command, player);
        }
        if (dialog.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.method_5682(), player.method_5477().getString(), dialog.mail);
        }
        PlayerDialogData data = playerdata.dialogData;
        if (!data.dialogsRead.contains(dialog.id) && dialog.id >= 0) {
            data.dialogsRead.add(dialog.id);
            playerdata.updateClient = true;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        playerdata.questData.checkQuestCompletion(player, 1);
    }

    public static String runCommand(class_1297 executer, String name, String command, class_1657 player) {
        return NoppesUtilServer.runCommand(executer.method_5770(), executer.method_24515(), name, command, player, executer);
    }

    public static String runCommand(final class_1937 level, class_2338 pos, String name, String command, class_1657 player, class_1297 executer) {
        if (!level.method_8503().method_3812()) {
            CommonUtil.NotifyOPs(level.method_8503(), "Cant run commands if CommandBlocks are disabled", new Object[0]);
            LogWriter.warn("Cant run commands if CommandBlocks are disabled");
            return "Cant run commands if CommandBlocks are disabled";
        }
        if (player != null) {
            command = command.replace("@dp", player.method_5477().getString());
        }
        command = command.replace("@npc", name);
        class_5250 output = class_2561.method_43470((String)"");
        class_2165 icommandsender = new class_2165(){
            final /* synthetic */ class_2561 val$output;
            final /* synthetic */ class_1937 val$level;
            {
                this.val$output = class_25612;
                this.val$level = class_19372;
            }

            public void method_43496(class_2561 component) {
                ((class_5250)this.val$output).method_10852(component);
            }

            public boolean method_9200() {
                return true;
            }

            public boolean method_9201() {
                return this.val$level.method_8450().method_8355(class_1928.field_19394);
            }

            public boolean method_9202() {
                return true;
            }
        };
        int permLvl = CustomNpcs.NpcUseOpCommands ? 4 : 2;
        class_243 point = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        class_2168 commandSource = new class_2168(icommandsender, point, class_241.field_1340, (class_3218)level, permLvl, "@CustomNPCs-" + name, (class_2561)class_2561.method_43470((String)("@CustomNPCs-" + name)), level.method_8503(), executer){

            public void method_9213(class_2561 text) {
                super.method_9213(text);
                CommonUtil.NotifyOPs(level.method_8503(), text);
            }
        };
        class_2170 icommandmanager = level.method_8503().method_3734();
        icommandmanager.method_44252(commandSource, command);
        if (output.getString().isEmpty()) {
            return null;
        }
        return output.getString();
    }

    public static void sendOpenGui(class_1657 player, EnumGuiType gui, EntityNPCInterface npc) {
        SPacketGuiOpen.sendOpenGui(player, gui, npc, class_2338.field_10980);
    }

    private static class_3917 getType(EnumGuiType gui) {
        if (gui == EnumGuiType.PlayerAnvil) {
            return CustomContainer.container_carpentrybench;
        }
        if (gui == EnumGuiType.CustomGui) {
            return CustomContainer.container_customgui;
        }
        if (gui == EnumGuiType.PlayerBankUnlock) {
            return CustomContainer.container_bankunlock;
        }
        if (gui == EnumGuiType.PlayerBankLarge) {
            return CustomContainer.container_banklarge;
        }
        if (gui == EnumGuiType.PlayerBankUprade) {
            return CustomContainer.container_bankupgrade;
        }
        if (gui == EnumGuiType.PlayerBankSmall) {
            return CustomContainer.container_banksmall;
        }
        if (gui == EnumGuiType.PlayerMailman) {
            return CustomContainer.container_mail;
        }
        if (gui == EnumGuiType.MainMenuInv) {
            return CustomContainer.container_inv;
        }
        if (gui == EnumGuiType.QuestItem) {
            return CustomContainer.container_questtypeitem;
        }
        if (gui == EnumGuiType.QuestReward) {
            return CustomContainer.container_questreward;
        }
        if (gui == EnumGuiType.CompanionInv) {
            return CustomContainer.container_companion;
        }
        if (gui == EnumGuiType.PlayerTrader) {
            return CustomContainer.container_trader;
        }
        if (gui == EnumGuiType.PlayerFollower) {
            return CustomContainer.container_follower;
        }
        if (gui == EnumGuiType.PlayerFollowerHire) {
            return CustomContainer.container_followerhire;
        }
        if (gui == EnumGuiType.SetupTrader) {
            return CustomContainer.container_tradersetup;
        }
        if (gui == EnumGuiType.SetupFollower) {
            return CustomContainer.container_followersetup;
        }
        if (gui == EnumGuiType.SetupItemGiver) {
            return CustomContainer.container_itemgiver;
        }
        if (gui == EnumGuiType.ManageBanks) {
            return CustomContainer.container_managebanks;
        }
        if (gui == EnumGuiType.ManageRecipes) {
            return CustomContainer.container_managerecipes;
        }
        return null;
    }

    public static void openContainerGui(class_3222 player, final EnumGuiType gui, Consumer<class_2540> extraDataWriter) {
        final class_2540 outerbuf = new class_2540(Unpooled.buffer());
        extraDataWriter.accept(outerbuf);
        final ByteBuf copy = outerbuf.copy();
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeBytes(copy);
            }

            public class_1703 createMenu(int p_createMenu_1_, class_1661 p_createMenu_2_, class_1657 p_createMenu_3_) {
                return ((ExtendedScreenHandlerType)NoppesUtilServer.getType(gui)).create(p_createMenu_1_, p_createMenu_2_, outerbuf);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)gui.name());
            }
        });
    }

    public static void spawnParticle(class_1297 entity, String particle, int dimension) {
        Packets.sendNearby(entity, new PacketParticle(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_17682(), entity.method_17681(), particle));
    }

    public static void sendScrollData(class_3222 player, Map<String, Integer> map) {
        Packets.send(player, new PacketGuiScrollData(map));
    }

    public static void sendGuiError(class_1657 player, int i) {
        Packets.send((class_3222)player, new PacketGuiError(i, new class_2487()));
    }

    public static void sendGuiClose(class_3222 player, int i, class_2487 comp) {
        Packets.send(player, new PacketGuiClose(comp));
    }

    public static void GivePlayerItem(class_1297 entity, class_1657 player, class_1799 item) {
        if (entity.method_37908().field_9236 || item == null || item.method_7960()) {
            return;
        }
        item = item.method_7972();
        float f = 0.7f;
        double d = (double)(entity.method_37908().field_9229.method_43057() * f) + (double)(1.0f - f);
        double d1 = (double)(entity.method_37908().field_9229.method_43057() * f) + (double)(1.0f - f);
        double d2 = (double)(entity.method_37908().field_9229.method_43057() * f) + (double)(1.0f - f);
        class_1542 entityitem = new class_1542(entity.method_37908(), entity.method_23317() + d, entity.method_23318() + d1, entity.method_23321() + d2, item);
        entityitem.method_6982(2);
        entity.method_37908().method_8649((class_1297)entityitem);
        if (player.method_31548().method_7394(item)) {
            entity.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_6051().method_43057() - player.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            player.method_6103((class_1297)entityitem, item.method_7947());
            PlayerQuestData playerdata = PlayerData.get((class_1657)player).questData;
            playerdata.checkQuestCompletion(player, 0);
            if (item.method_7947() <= 0) {
                entityitem.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    public static class_2338 GetClosePos(class_2338 origin, class_1937 level) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 2; y >= -2; --y) {
                    class_2338 pos = origin.method_10069(x, y, z);
                    class_2680 state = level.method_8320(pos.method_10084());
                    if (!state.method_26212((class_1922)level, pos) || !level.method_22347(pos.method_10084()) || !level.method_22347(pos.method_10086(2))) continue;
                    return pos.method_10084();
                }
            }
        }
        return level.method_8598(class_2902.class_2903.field_13203, origin);
    }

    public static void playSound(class_1309 entity, class_3414 sound, float volume, float pitch) {
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, class_3419.field_15254, volume, pitch);
    }

    public static void playSound(class_1937 level, class_2338 pos, class_3414 sound, class_3419 cat, float volume, float pitch) {
        level.method_8396(null, pos, sound, cat, volume, pitch);
    }

    public static class_1657 getPlayer(MinecraftServer minecraftserver, UUID id) {
        List list = minecraftserver.method_3760().method_14571();
        for (class_1657 player : list) {
            if (!id.equals(player.method_5667())) continue;
            return player;
        }
        return null;
    }

    public static class_1297 GetDamageSourcee(class_1282 damagesource) {
        class_1297 entity = damagesource.method_5529();
        if (entity == null) {
            entity = damagesource.method_5526();
        }
        if (entity instanceof EntityProjectile && ((EntityProjectile)entity).method_24921() instanceof class_1309) {
            entity = ((class_1665)entity).method_24921();
        } else if (entity instanceof class_1682) {
            entity = ((class_1682)entity).method_24921();
        }
        return entity;
    }

    public static boolean IsItemStackNull(class_1799 is) {
        return is == null || is.method_7960() || is == class_1799.field_8037 || is.method_7909() == null;
    }

    public static class_1799 ChangeItemStack(class_1799 is, class_1792 item) {
        class_2487 comp = is.method_7953(new class_2487());
        class_2960 resourcelocation = class_7923.field_41178.method_10221((Object)item);
        comp.method_10582("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        return class_1799.method_7915((class_2487)comp);
    }
}

