/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2556;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemNbtBook;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketItemUpdate;
import org.jetbrains.annotations.Nullable;

public class ScriptPlayerEventHandler
implements ServerTickEvents.StartTick,
AttackBlockCallback,
UseBlockCallback,
UseEntityCallback,
UseItemCallback,
PlayerBlockBreakEvents.Before,
ServerMessageEvents.AllowChatMessage,
ServerLivingEntityEvents.AllowDamage,
ServerLivingEntityEvents.AllowDeath,
ServerPlayConnectionEvents.Join,
ServerPlayConnectionEvents.Disconnect {
    public void onStartTick(MinecraftServer server) {
        for (class_1657 player : server.method_3760().method_14571()) {
            PlayerData data = PlayerData.get(player);
            if (player.field_6012 % 10 == 0) {
                EventHooks.onPlayerTick(data.scriptData);
                for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                    class_1799 item = player.method_31548().method_5438(i);
                    if (item.method_7960() || item.method_7909() != CustomItems.scripted_item) continue;
                    ItemScriptedWrapper isw = (ItemScriptedWrapper)NpcAPI.Instance().getIItemStack(item);
                    EventHooks.onScriptItemUpdate(isw, player);
                    if (!isw.updateClient) continue;
                    isw.updateClient = false;
                    Packets.send((class_3222)player, new PacketItemUpdate(i, isw.getMCNbt()));
                }
            }
            if (data.playerLevel != player.field_7520) {
                EventHooks.onPlayerLevelUp(data.scriptData, data.playerLevel - player.field_7520);
                data.playerLevel = player.field_7520;
            }
            data.timers.update();
        }
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (world.field_9236 || hand != class_1268.field_5808 || !(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        if (player.method_5998(hand).method_7909() == CustomItems.teleporter) {
            return class_1269.field_5814;
        }
        boolean isCancelled = false;
        PlayerScriptData handler = PlayerData.get((class_1657)player).scriptData;
        PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(world, pos));
        isCancelled = EventHooks.onPlayerAttack(handler, ev);
        if (player.method_5998(hand).method_7909() == CustomItems.scripted_item && !isCancelled) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(player.method_5998(hand));
            ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent((IItemScripted)isw, handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(world, pos));
            eve.setCanceled(isCancelled);
            isCancelled = EventHooks.onScriptItemAttack(isw, eve);
        }
        return isCancelled ? class_1269.field_5814 : class_1269.field_5811;
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (player.method_37908().field_9236 || hand != class_1268.field_5808 || !(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        if (player.method_5998(hand).method_7909() == CustomItems.nbt_book) {
            ((ItemNbtBook)player.method_5998(hand).method_7909()).blockEvent(player, world, hand, hitResult);
            return class_1269.field_5814;
        }
        if (player.method_5998(hand).method_7909() == CustomItems.teleporter) {
            return class_1269.field_5814;
        }
        boolean isCancelled = false;
        PlayerScriptData handler = PlayerData.get((class_1657)player).scriptData;
        handler.hadInteract = true;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(world, hitResult.method_17777()));
        isCancelled = EventHooks.onPlayerInteract(handler, ev);
        if (player.method_5998(hand).method_7909() == CustomItems.scripted_item && !isCancelled) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(player.method_5998(hand));
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(world, hitResult.method_17777()));
            isCancelled = EventHooks.onScriptItemInteract(isw, eve);
        }
        return isCancelled ? class_1269.field_5814 : class_1269.field_5811;
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (world.field_9236 || hand != class_1268.field_5808 || !(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        if (player.method_5998(hand).method_7909() == CustomItems.nbt_book) {
            ((ItemNbtBook)player.method_5998(hand).method_7909()).entityEvent(player, world, hand, entity, hitResult);
            return class_1269.field_5814;
        }
        PlayerScriptData handler = PlayerData.get((class_1657)player).scriptData;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 1, NpcAPI.Instance().getIEntity(entity));
        boolean isCancelled = false;
        isCancelled = EventHooks.onPlayerInteract(handler, ev);
        if (player.method_5998(hand).method_7909() == CustomItems.scripted_item && !isCancelled) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(player.method_5998(hand));
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 1, NpcAPI.Instance().getIEntity(entity));
            isCancelled = EventHooks.onScriptItemInteract(isw, eve);
        }
        return isCancelled ? class_1269.field_5814 : class_1269.field_5811;
    }

    public class_1271<class_1799> interact(class_1657 player, class_1937 world, class_1268 hand) {
        if (world.field_9236 || hand != class_1268.field_5808 || !(world instanceof class_3218)) {
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        if (player.method_7337() && player.method_18276() && player.method_5998(hand).method_7909() == CustomItems.scripted_item) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.ScriptItem, null);
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        PlayerScriptData handler = PlayerData.get((class_1657)player).scriptData;
        if (handler.hadInteract) {
            handler.hadInteract = false;
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 0, null);
        boolean isCancelled = EventHooks.onPlayerInteract(handler, ev);
        if (player.method_5998(hand).method_7909() == CustomItems.scripted_item && !isCancelled) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(player.method_5998(hand));
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 0, null);
            isCancelled = EventHooks.onScriptItemInteract(isw, eve);
        }
        return isCancelled ? class_1271.method_22431((Object)player.method_5998(hand)) : class_1271.method_22430((Object)player.method_5998(hand));
    }

    public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        if (player.method_37908().field_9236 || !(world instanceof class_3218)) {
            return true;
        }
        PlayerScriptData handler = PlayerData.get((class_1657)player).scriptData;
        PlayerEvent.BreakEvent ev = new PlayerEvent.BreakEvent(handler.getPlayer(), NpcAPI.Instance().getIBlock((class_1937)((class_3218)world), pos));
        return !EventHooks.onPlayerBreak(handler, ev);
    }

    public boolean allowDeath(class_1309 entity, class_1282 damageSource, float damageAmount) {
        PlayerScriptData handler;
        if (!(entity.method_37908() instanceof class_3218)) {
            return true;
        }
        class_1297 sourceEnt = NoppesUtilServer.GetDamageSourcee(damageSource);
        if (entity instanceof class_1657) {
            handler = PlayerData.get((class_1657)((class_1657)entity)).scriptData;
            EventHooks.onPlayerDeath(handler, damageSource, sourceEnt);
        }
        if (sourceEnt instanceof class_1657) {
            handler = PlayerData.get((class_1657)((class_1657)sourceEnt)).scriptData;
            EventHooks.onPlayerKills(handler, entity);
        }
        return true;
    }

    public boolean allowDamage(class_1309 entity, class_1282 source, float amount) {
        PlayerEvent pevent;
        PlayerScriptData handler;
        if (!(entity.method_37908() instanceof class_3218)) {
            return true;
        }
        class_1297 sourceEnt = NoppesUtilServer.GetDamageSourcee(source);
        boolean isCanceled = false;
        if (entity instanceof class_1657) {
            handler = PlayerData.get((class_1657)((class_1657)entity)).scriptData;
            pevent = new PlayerEvent.DamagedEvent(handler.getPlayer(), sourceEnt, amount, source);
            isCanceled = EventHooks.onPlayerDamaged(handler, pevent);
        }
        if (sourceEnt instanceof class_1657) {
            handler = PlayerData.get((class_1657)((class_1657)sourceEnt)).scriptData;
            pevent = new PlayerEvent.DamagedEntityEvent(handler.getPlayer(), (class_1297)entity, amount, source);
            isCanceled = EventHooks.onPlayerDamagedEntity(handler, (PlayerEvent.DamagedEntityEvent)pevent);
        }
        return !isCanceled;
    }

    public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
        if (!(handler.field_14140.method_37908() instanceof class_3218)) {
            return;
        }
        PlayerScriptData scriptData = PlayerData.get((class_1657)handler.field_14140).scriptData;
        EventHooks.onPlayerLogin(scriptData);
    }

    public void onPlayDisconnect(class_3244 handler, MinecraftServer server) {
        if (!(handler.field_14140.method_37908() instanceof class_3218)) {
            return;
        }
        PlayerScriptData scriptData = PlayerData.get((class_1657)handler.field_14140).scriptData;
        EventHooks.onPlayerLogout(scriptData);
    }

    public boolean allowChatMessage(class_7471 message, class_3222 sender, class_2556.class_7602 params) {
        if (!(sender.method_37908() instanceof class_3218) || sender == EntityNPCInterface.ChatEventPlayer) {
            return true;
        }
        PlayerScriptData handler = PlayerData.get((class_1657)sender).scriptData;
        String messageStr = message.method_46291().getString();
        PlayerEvent.ChatEvent ev = new PlayerEvent.ChatEvent(handler.getPlayer(), message.method_46291().getString());
        EventHooks.onPlayerChat(handler, ev);
        boolean isCanceled = ev.isCanceled();
        return !isCanceled;
    }
}

