/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.List;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import noppes.npcs.ICompatibilty;
import noppes.npcs.NBTTags;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.Lines;
import noppes.npcs.entity.EntityNPCInterface;

public class VersionCompatibility {
    public static int ModRev = 18;

    public static void CheckNpcCompatibility(EntityNPCInterface npc, class_2487 compound) {
        class_2499 list;
        if (npc.npcVersion == ModRev) {
            return;
        }
        if (npc.npcVersion < 12) {
            VersionCompatibility.CompatabilityFix(compound, npc.advanced.save(new class_2487()));
            VersionCompatibility.CompatabilityFix(compound, npc.ais.save(new class_2487()));
            VersionCompatibility.CompatabilityFix(compound, npc.stats.save(new class_2487()));
            VersionCompatibility.CompatabilityFix(compound, npc.display.save(new class_2487()));
            VersionCompatibility.CompatabilityFix(compound, npc.inventory.save(new class_2487()));
        }
        if (npc.npcVersion < 5) {
            String texture = compound.method_10558("Texture");
            texture = texture.replace("/mob/customnpcs/", "customnpcs:textures/entity/");
            texture = texture.replace("/mob/", "customnpcs:textures/entity/");
            compound.method_10582("Texture", texture);
        }
        if (npc.npcVersion < 6 && compound.method_10580("NpcInteractLines") instanceof class_2499) {
            List<String> interactLines = NBTTags.getStringList(compound.method_10554("NpcInteractLines", 10));
            Lines lines = new Lines();
            for (int i = 0; i < interactLines.size(); ++i) {
                Line line = new Line();
                line.setText((String)interactLines.toArray()[i]);
                lines.lines.put(i, line);
            }
            compound.method_10566("NpcInteractLines", (class_2520)lines.save());
            List<String> worldLines = NBTTags.getStringList(compound.method_10554("NpcLines", 10));
            lines = new Lines();
            for (int i = 0; i < worldLines.size(); ++i) {
                Line line = new Line();
                line.setText((String)worldLines.toArray()[i]);
                lines.lines.put(i, line);
            }
            compound.method_10566("NpcLines", (class_2520)lines.save());
            List<String> attackLines = NBTTags.getStringList(compound.method_10554("NpcAttackLines", 10));
            lines = new Lines();
            for (int i = 0; i < attackLines.size(); ++i) {
                Line line = new Line();
                line.setText((String)attackLines.toArray()[i]);
                lines.lines.put(i, line);
            }
            compound.method_10566("NpcAttackLines", (class_2520)lines.save());
            List<String> killedLines = NBTTags.getStringList(compound.method_10554("NpcKilledLines", 10));
            lines = new Lines();
            for (int i = 0; i < killedLines.size(); ++i) {
                Line line = new Line();
                line.setText((String)killedLines.toArray()[i]);
                lines.lines.put(i, line);
            }
            compound.method_10566("NpcKilledLines", (class_2520)lines.save());
        }
        if (npc.npcVersion == 12 && (list = compound.method_10554("StartPos", 3)).size() == 3) {
            int z = ((class_2497)list.method_10536(2)).method_10701();
            int y = ((class_2497)list.method_10536(1)).method_10701();
            int x = ((class_2497)list.method_10536(0)).method_10701();
            compound.method_10539("StartPosNew", new int[]{x, y, z});
        }
        if (npc.npcVersion == 13) {
            boolean bo = compound.method_10577("HealthRegen");
            compound.method_10569("HealthRegen", bo ? 1 : 0);
            class_2487 comp = compound.method_10562("TransformStats");
            bo = comp.method_10577("HealthRegen");
            comp.method_10569("HealthRegen", bo ? 1 : 0);
            compound.method_10566("TransformStats", (class_2520)comp);
        }
        if (npc.npcVersion == 15) {
            class_2499 list2 = compound.method_10554("ScriptsContainers", 10);
            if (list2.size() > 0) {
                ScriptContainer script = new ScriptContainer(npc.script);
                for (int i = 0; i < list2.size(); ++i) {
                    class_2487 scriptOld = list2.method_10602(i);
                    EnumScriptType type = EnumScriptType.values()[scriptOld.method_10550("Type")];
                    script.script = script.script + "\nfunction " + type.function + "(event) {\n" + scriptOld.method_10558("Script") + "\n}";
                    for (String s : NBTTags.getStringList(compound.method_10554("ScriptList", 10))) {
                        if (script.scripts.contains(s)) continue;
                        script.scripts.add(s);
                    }
                }
            }
            if (compound.method_10577("CanDespawn")) {
                compound.method_10569("SpawnCycle", 4);
            }
            if (compound.method_10550("RangeAndMelee") <= 0) {
                compound.method_10569("DistanceToMelee", 0);
            }
        }
        if (npc.npcVersion == 16) {
            compound.method_10582("HitSound", "random.bowhit");
            compound.method_10582("GroundSound", "random.break");
        }
        if (npc.npcVersion == 17) {
            if (compound.method_10558("NpcHurtSound").equals("minecraft:game.player.hurt")) {
                compound.method_10582("NpcHurtSound", "minecraft:entity.player.hurt");
            }
            if (compound.method_10558("NpcDeathSound").equals("minecraft:game.player.hurt")) {
                compound.method_10582("NpcDeathSound", "minecraft:entity.player.hurt");
            }
            if (compound.method_10558("FiringSound").equals("random.bow")) {
                compound.method_10582("FiringSound", "minecraft:entity.arrow.shoot");
            }
            if (compound.method_10558("HitSound").equals("random.bowhit")) {
                compound.method_10582("HitSound", "minecraft:entity.arrow.hit");
            }
            if (compound.method_10558("GroundSound").equals("random.break")) {
                compound.method_10582("GroundSound", "minecraft:block.stone.break");
            }
        }
        npc.npcVersion = ModRev;
    }

    public static void CheckAvailabilityCompatibility(ICompatibilty compatibilty, class_2487 compound) {
        if (compatibilty.getVersion() == ModRev) {
            return;
        }
        VersionCompatibility.CompatabilityFix(compound, compatibilty.save(new class_2487()));
        compatibilty.setVersion(ModRev);
    }

    private static void CompatabilityFix(class_2487 compound, class_2487 check) {
        Set tags = check.method_10541();
        for (String name : tags) {
            class_2520 nbt = check.method_10580(name);
            if (!compound.method_10545(name)) {
                compound.method_10566(name, nbt);
                continue;
            }
            if (!(nbt instanceof class_2487) || !(compound.method_10580(name) instanceof class_2487)) continue;
            VersionCompatibility.CompatabilityFix(compound.method_10562(name), (class_2487)nbt);
        }
    }
}

