/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5532;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIReturn
extends class_1352 {
    public static final int MaxTotalTicks = 600;
    private final EntityNPCInterface npc;
    private int stuckTicks = 0;
    private int totalTicks = 0;
    private double endPosX;
    private double endPosY;
    private double endPosZ;
    private boolean wasAttacked = false;
    private double[] preAttackPos;
    private int stuckCount = 0;

    public EntityAIReturn(EntityNPCInterface npc) {
        this.npc = npc;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.npc.hasOwner() || this.npc.method_5765() || !this.npc.ais.shouldReturnHome() || this.npc.isKilled() || !this.npc.method_5942().method_6357() || this.npc.isInteracting()) {
            return false;
        }
        if (!(this.npc.ais.findShelter != 0 || this.npc.method_37908().method_8530() && !this.npc.method_37908().method_8419() || this.npc.method_37908().method_8597().comp_642())) {
            class_2338 pos = new class_2338((int)this.npc.getStartXPos(), (int)this.npc.getStartYPos(), (int)this.npc.getStartZPos());
            if (this.npc.method_37908().method_8311(pos) || this.npc.method_37908().method_8317(pos) <= 8) {
                return false;
            }
        } else if (this.npc.ais.findShelter == 1 && this.npc.method_37908().method_8530()) {
            class_2338 pos = new class_2338((int)this.npc.getStartXPos(), (int)this.npc.getStartYPos(), (int)this.npc.getStartZPos());
            if (this.npc.method_37908().method_8311(pos)) {
                return false;
            }
        }
        if (this.npc.isAttacking()) {
            if (!this.wasAttacked) {
                this.wasAttacked = true;
                this.preAttackPos = new double[]{this.npc.method_23317(), this.npc.method_23318(), this.npc.method_23321()};
            }
            return false;
        }
        if (!this.npc.isAttacking() && this.wasAttacked) {
            return true;
        }
        if (this.npc.ais.getMovingType() == 2 && this.npc.ais.distanceToSqrToPathPoint() < (double)(CustomNpcs.NpcNavRange * CustomNpcs.NpcNavRange)) {
            return false;
        }
        if (this.npc.ais.getMovingType() == 1) {
            double x = this.npc.method_23317() - (double)this.npc.getStartXPos();
            double z = this.npc.method_23321() - (double)this.npc.getStartZPos();
            return !this.npc.isInRange(this.npc.getStartXPos(), -6666.0, this.npc.getStartZPos(), this.npc.ais.walkingRange);
        }
        if (this.npc.ais.getMovingType() == 0) {
            return !this.npc.isVeryNearAssignedPlace();
        }
        return false;
    }

    public boolean method_6266() {
        if (this.npc.isFollower() || this.npc.isKilled() || this.npc.isAttacking() || this.npc.isVeryNearAssignedPlace() || this.npc.isInteracting() || this.npc.method_5765()) {
            return false;
        }
        if (this.npc.method_5942().method_6357() && this.wasAttacked && !this.isTooFar()) {
            return false;
        }
        return this.totalTicks <= 600;
    }

    public void method_6268() {
        ++this.totalTicks;
        if (this.totalTicks > 600) {
            this.npc.method_5814(this.endPosX, this.endPosY, this.endPosZ);
            this.npc.method_5942().method_6340();
            return;
        }
        if (this.stuckTicks > 0) {
            --this.stuckTicks;
        } else if (this.npc.method_5942().method_6357()) {
            ++this.stuckCount;
            this.stuckTicks = 10;
            if (this.totalTicks > 30 && this.wasAttacked && this.isTooFar() || this.stuckCount > 5) {
                this.npc.method_5814(this.endPosX, this.endPosY, this.endPosZ);
                this.npc.method_5942().method_6340();
            } else {
                this.navigate(this.stuckCount % 2 == 1);
            }
        } else {
            this.stuckCount = 0;
        }
    }

    private boolean isTooFar() {
        double z;
        double x;
        int allowedDistance = this.npc.stats.aggroRange * 2;
        if (this.npc.ais.getMovingType() == 1) {
            allowedDistance += this.npc.ais.walkingRange;
        }
        return (x = this.npc.method_23317() - this.endPosX) * x + (z = this.npc.method_23321() - this.endPosZ) * z > (double)(allowedDistance * allowedDistance);
    }

    public void method_6269() {
        this.stuckTicks = 0;
        this.totalTicks = 0;
        this.stuckCount = 0;
        this.navigate(false);
    }

    private void navigate(boolean towards) {
        if (!this.wasAttacked) {
            this.endPosX = this.npc.getStartXPos();
            this.endPosY = this.npc.getStartYPos();
            this.endPosZ = this.npc.getStartZPos();
        } else {
            this.endPosX = this.preAttackPos[0];
            this.endPosY = this.preAttackPos[1];
            this.endPosZ = this.preAttackPos[2];
        }
        double posX = this.endPosX;
        double posY = this.endPosY;
        double posZ = this.endPosZ;
        double range = Math.sqrt(this.npc.method_5649(posX, posY, posZ));
        if (range > (double)CustomNpcs.NpcNavRange || towards) {
            class_243 start;
            class_243 pos;
            int distance = (int)range;
            distance = distance > CustomNpcs.NpcNavRange ? CustomNpcs.NpcNavRange / 2 : (distance /= 2);
            if (distance > 2 && (pos = class_5532.method_31512((class_1314)this.npc, (int)(distance / 2), (int)(distance / 2 > 7 ? 7 : distance / 2), (class_243)(start = new class_243(posX, posY, posZ)), (double)1.5707963267948966)) != null) {
                posX = pos.field_1352;
                posY = pos.field_1351;
                posZ = pos.field_1350;
            }
        }
        this.npc.method_5942().method_6340();
        this.npc.method_5942().method_6337(posX, posY, posZ, 1.0);
    }

    public void method_6270() {
        this.wasAttacked = false;
        this.npc.method_5942().method_6340();
    }
}

