/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.selector;

import com.google.common.base.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import noppes.npcs.constants.EnumCompanionJobs;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobGuard;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.companion.CompanionGuard;

public class NPCAttackSelector
implements Predicate<class_1309> {
    private EntityNPCInterface npc;

    public NPCAttackSelector(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public boolean isEntityApplicable(class_1309 entity) {
        if (!entity.method_5805() || entity == this.npc || !this.npc.isInRange((class_1297)entity, this.npc.stats.aggroRange) || entity.method_6032() < 1.0f) {
            return false;
        }
        if (this.npc.ais.directLOS && !this.npc.method_5985().method_6369((class_1297)entity)) {
            return false;
        }
        if (!this.npc.isFollower() && this.npc.ais.shouldReturnHome()) {
            int allowedDistance = this.npc.stats.aggroRange * 2;
            if (this.npc.ais.getMovingType() == 1) {
                allowedDistance += this.npc.ais.walkingRange;
            }
            double distance = entity.method_5649((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos());
            if (this.npc.ais.getMovingType() == 2) {
                int[] arr = this.npc.ais.getCurrentMovingPath();
                distance = entity.method_5649((double)arr[0], (double)arr[1], (double)arr[2]);
            }
            if (distance > (double)(allowedDistance * allowedDistance)) {
                return false;
            }
        }
        if (this.npc.job.getType() == 3 && ((JobGuard)this.npc.job).isEntityApplicable((class_1297)entity)) {
            return true;
        }
        if (this.npc.role.getType() == 6) {
            RoleCompanion role = (RoleCompanion)this.npc.role;
            if (role.companionJobInterface.getType() == EnumCompanionJobs.GUARD && ((CompanionGuard)role.companionJobInterface).isEntityApplicable((class_1297)entity)) {
                return true;
            }
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return this.npc.faction.isAggressiveToPlayer((class_1657)player) && !player.method_31549().field_7480;
        }
        if (entity instanceof EntityNPCInterface) {
            if (((EntityNPCInterface)entity).isKilled()) {
                return false;
            }
            if (this.npc.advanced.attackOtherFactions) {
                return this.npc.faction.isAggressiveToNpc((EntityNPCInterface)entity);
            }
        }
        return false;
    }

    public boolean apply(class_1309 ob) {
        return this.isEntityApplicable(ob);
    }
}

