/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_7923;
import noppes.npcs.ItemStackEmptyWrapper;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IMob;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemArmorWrapper;
import noppes.npcs.api.wrapper.ItemBlockWrapper;
import noppes.npcs.api.wrapper.ItemBookWrapper;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.items.ItemScripted;

public class ItemStackWrapper
implements IItemStack {
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private static Map<Integer, ItemStackWrapper> dataMap = new HashMap<Integer, ItemStackWrapper>();
    private static final class_1304[] VALID_EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    public class_1799 item;
    private class_2487 storedData = new class_2487();
    public static ItemStackWrapper AIR = new ItemStackEmptyWrapper();
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            ItemStackWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return ItemStackWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.tempData.keySet().toArray(new String[ItemStackWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            if (value instanceof Number) {
                ItemStackWrapper.this.storedData.method_10549(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                ItemStackWrapper.this.storedData.method_10582(key, (String)value);
            }
        }

        @Override
        public Object get(String key) {
            if (!ItemStackWrapper.this.storedData.method_10545(key)) {
                return null;
            }
            class_2520 base = ItemStackWrapper.this.storedData.method_10580(key);
            if (base instanceof class_2514) {
                return ((class_2514)base).method_10697();
            }
            return base.method_10714();
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.storedData.method_10551(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.storedData.method_10545(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.storedData = new class_2487();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.storedData.method_10541().toArray(new String[ItemStackWrapper.this.storedData.method_10541().size()]);
        }
    };
    private static final class_2960 key = new class_2960("customnpcs", "itemscripteddata");

    public ItemStackWrapper(class_1799 item) {
        this.item = item;
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public int getStackSize() {
        return this.item.method_7947();
    }

    @Override
    public void setStackSize(int size) {
        if (size > this.getMaxStackSize()) {
            throw new CustomNPCsException("Can't set the stacksize bigger than MaxStacksize", new Object[0]);
        }
        this.item.method_7939(size);
    }

    @Override
    public void setAttribute(String name, double value) {
        this.setAttribute(name, value, -1);
    }

    @Override
    public void setAttribute(String name, double value, int slot) {
        if (slot < -1 || slot > 5) {
            throw new CustomNPCsException("Slot has to be between -1 and 5, given was: " + slot, new Object[0]);
        }
        class_2487 compound = this.item.method_7969();
        if (compound == null) {
            compound = new class_2487();
            this.item.method_7980(compound);
        }
        class_2499 nbttaglist = compound.method_10554("AttributeModifiers", 10);
        class_2499 newList = new class_2499();
        UUID uuid = null;
        for (int i = 0; i < nbttaglist.size(); ++i) {
            class_2487 c = nbttaglist.method_10602(i);
            if (!c.method_10558("AttributeName").equals(name)) {
                newList.add((Object)c);
                continue;
            }
            uuid = c.method_25926("UUID");
        }
        if (value != 0.0) {
            class_2487 nbttagcompound = new class_1322(name, value, class_1322.class_1323.field_6328).method_26860();
            nbttagcompound.method_10582("AttributeName", name);
            if (slot >= 0) {
                nbttagcompound.method_10582("Slot", class_1304.values()[slot].method_5923());
            }
            if (uuid != null) {
                nbttagcompound.method_25927("UUID", uuid);
            }
            newList.add((Object)nbttagcompound);
        }
        compound.method_10566("AttributeModifiers", (class_2520)newList);
    }

    @Override
    public double getAttribute(String name) {
        class_2487 compound = this.item.method_7969();
        if (compound == null) {
            return 0.0;
        }
        Multimap map = this.item.method_7926(class_1304.field_6173);
        for (Map.Entry entry : map.entries()) {
            if (!((class_1320)entry.getKey()).method_26830().equals(name)) continue;
            class_1322 mod = (class_1322)entry.getValue();
            return mod.method_6186();
        }
        return 0.0;
    }

    @Override
    public boolean hasAttribute(String name) {
        class_2487 compound = this.item.method_7969();
        if (compound == null) {
            return false;
        }
        class_2499 nbttaglist = compound.method_10554("AttributeModifiers", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            class_2487 c = nbttaglist.method_10602(i);
            if (!c.method_10558("AttributeName").equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEnchantment(String id, int strenght) {
        class_1887 ench = (class_1887)class_7923.field_41176.method_10223(new class_2960(id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        this.item.method_7978(ench, strenght);
    }

    @Override
    public boolean isEnchanted() {
        return this.item.method_7942();
    }

    @Override
    public boolean hasEnchant(String id) {
        class_1887 ench = (class_1887)class_7923.field_41176.method_10223(new class_2960(id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        class_2499 list = this.item.method_7921();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            if (!compound.method_10558("id").equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEnchant(String id) {
        class_1887 ench = (class_1887)class_7923.field_41176.method_10223(new class_2960(id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        class_2499 list = this.item.method_7921();
        class_2499 newList = new class_2499();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compound = list.method_10602(i);
            if (compound.method_10558("id").equalsIgnoreCase(id)) continue;
            newList.add((Object)compound);
        }
        if (list.size() == newList.size()) {
            return false;
        }
        this.item.method_7969().method_10566("ench", (class_2520)newList);
        return true;
    }

    @Override
    public boolean isBlock() {
        class_2248 block = class_2248.method_9503((class_1792)this.item.method_7909());
        return block != null && block != class_2246.field_10124;
    }

    @Override
    public boolean hasCustomName() {
        return this.item.method_7938();
    }

    @Override
    public void setCustomName(String name) {
        this.item.method_7977((class_2561)class_2561.method_43471((String)name));
    }

    @Override
    public String getDisplayName() {
        return this.item.method_7964().getString();
    }

    @Override
    public String getItemName() {
        return this.item.method_7909().method_7864(this.item).getString();
    }

    @Override
    public String getName() {
        return class_7923.field_41178.method_10221((Object)this.item.method_7909()).toString();
    }

    @Override
    public INbt getNbt() {
        class_2487 compound = this.item.method_7969();
        if (compound == null) {
            compound = new class_2487();
            this.item.method_7980(compound);
        }
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public boolean hasNbt() {
        class_2487 compound = this.item.method_7969();
        return compound != null && !compound.method_33133();
    }

    @Override
    public class_1799 getMCItemStack() {
        return this.item;
    }

    public static class_1799 MCItem(IItemStack item) {
        if (item == null) {
            return class_1799.field_8037;
        }
        return item.getMCItemStack();
    }

    @Override
    public void damageItem(int damage, IMob living) {
        if (living != null) {
            this.item.method_7956(damage, living == null ? null : (class_1309)living.getMCEntity(), e -> e.method_20235(class_1304.field_6173));
        } else if (this.item.method_7963()) {
            if (this.item.method_7919() <= damage) {
                this.item.method_7934(1);
                this.item.method_7974(0);
            } else {
                this.item.method_7974(this.item.method_7919() - damage);
            }
        }
    }

    @Override
    public boolean isBook() {
        return false;
    }

    @Override
    public int getFoodLevel() {
        if (this.item.method_7909().method_19264() != null) {
            return this.item.method_7909().method_19264().method_19230();
        }
        return 0;
    }

    @Override
    public IItemStack copy() {
        return ItemStackWrapper.createNew(this.item.method_7972());
    }

    @Override
    public int getMaxStackSize() {
        return this.item.method_7914();
    }

    @Override
    public boolean isDamageable() {
        return this.item.method_7963();
    }

    @Override
    public int getDamage() {
        return this.item.method_7919();
    }

    @Override
    public void setDamage(int value) {
        this.item.method_7974(value);
    }

    @Deprecated
    public int getItemDamage() {
        return this.item.method_7919();
    }

    @Deprecated
    public void setItemDamage(int value) {
        this.item.method_7974(value);
    }

    @Override
    public int getMaxDamage() {
        return this.item.method_7936();
    }

    @Override
    public INbt getItemNbt() {
        class_2487 compound = new class_2487();
        this.item.method_7953(compound);
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public double getAttackDamage() {
        Multimap map = this.item.method_7926(class_1304.field_6173);
        double damage = 0.0;
        for (Map.Entry entry : map.entries()) {
            if (entry.getKey() != class_5134.field_23721) continue;
            class_1322 mod = (class_1322)entry.getValue();
            damage = mod.method_6186();
        }
        return damage + (double)class_1890.method_8218((class_1799)this.item, (class_1310)class_1310.field_6290);
    }

    @Override
    public boolean isEmpty() {
        return this.item.method_7960();
    }

    @Override
    public int getType() {
        if (this.item.method_7909() instanceof class_1829) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean isWearable() {
        return this.item.method_7909() instanceof class_5151;
    }

    private static ItemStackWrapper createNew(class_1799 item) {
        if (item == null || item.method_7960()) {
            return AIR;
        }
        if (item.method_7909() instanceof ItemScripted) {
            return new ItemScriptedWrapper(item);
        }
        if (item.method_7909() == class_1802.field_8360 || item.method_7909() == class_1802.field_8674 || item.method_7909() instanceof class_1840 || item.method_7909() instanceof class_1843) {
            return new ItemBookWrapper(item);
        }
        if (item.method_7909() instanceof class_1738) {
            return new ItemArmorWrapper(item);
        }
        class_2248 block = class_2248.method_9503((class_1792)item.method_7909());
        if (block != class_2246.field_10124) {
            return new ItemBlockWrapper(item);
        }
        return new ItemStackWrapper(item);
    }

    @Override
    public String[] getLore() {
        class_2487 compound = this.item.method_7941("display");
        if (compound == null || compound.method_10540("Lore") != 9) {
            return new String[0];
        }
        class_2499 nbttaglist = compound.method_10554("Lore", 8);
        if (nbttaglist.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            lore.add(nbttaglist.method_10608(i));
        }
        return lore.toArray(new String[lore.size()]);
    }

    @Override
    public void setLore(String[] lore) {
        class_2487 compound = this.item.method_7911("display");
        if (lore == null || lore.length == 0) {
            compound.method_10551("Lore");
            return;
        }
        class_2499 nbtlist = new class_2499();
        for (String s : lore) {
            try {
                class_2561.class_2562.method_10877((String)s);
            }
            catch (JsonParseException jsonparseexception) {
                s = class_2561.class_2562.method_10867((class_2561)class_2561.method_43471((String)s));
            }
            nbtlist.add((Object)class_2519.method_23256((String)s));
        }
        compound.method_10566("Lore", (class_2520)nbtlist);
    }

    public class_2487 serializeNBT() {
        return this.getMCNbt();
    }

    public void deserializeNBT(class_2487 nbt) {
        this.setMCNbt(nbt);
    }

    public class_2487 getMCNbt() {
        class_2487 compound = new class_2487();
        if (!this.storedData.method_33133()) {
            compound.method_10566("StoredData", (class_2520)this.storedData);
        }
        return compound;
    }

    public void setMCNbt(class_2487 compound) {
        this.storedData = compound == null ? new class_2487() : compound.method_10562("StoredData");
    }

    @Override
    public void removeNbt() {
        this.item.method_7980(null);
    }

    @Override
    public boolean compare(IItemStack item, boolean ignoreNBT) {
        if (item == null) {
            item = AIR;
        }
        return NoppesUtilPlayer.compareItems(this.getMCItemStack(), item.getMCItemStack(), false, ignoreNBT);
    }
}

