/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IPlayerSkin;
import noppes.npcs.api.IPos;
import noppes.npcs.api.ITimers;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.entity.data.IPixelmonPlayerData;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.overlay.IOverlay;
import noppes.npcs.api.wrapper.ContainerWrapper;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;
import noppes.npcs.packets.client.PacketGuiClose;
import noppes.npcs.packets.client.PacketHideAllOverlays;
import noppes.npcs.packets.client.PacketOverlayHide;
import noppes.npcs.packets.client.PacketOverlayShow;
import noppes.npcs.packets.client.PacketPlayMusic;
import noppes.npcs.packets.client.PacketPlaySound;
import noppes.npcs.packets.client.PacketSoundGUIOpen;
import noppes.npcs.packets.server.SPacketDimensionTeleport;
import noppes.npcs.shared.client.util.NoppesStringUtils;
import noppes.npcs.util.ValueUtil;

public class PlayerWrapper<T extends class_3222>
extends EntityLivingBaseWrapper<T>
implements IPlayer {
    private IContainer inventory;
    private Object pixelmonPartyStorage;
    private Object pixelmonPCStorage;
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            class_2487 compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.method_10549(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.method_10582(key, (String)value);
            }
        }

        @Override
        public Object get(String key) {
            class_2487 compound = this.getStoredCompound();
            if (!compound.method_10545(key)) {
                return null;
            }
            class_2520 base = compound.method_10580(key);
            if (base instanceof class_2514) {
                return ((class_2514)base).method_10697();
            }
            return base.method_10714();
        }

        @Override
        public void remove(String key) {
            class_2487 compound = this.getStoredCompound();
            compound.method_10551(key);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().method_10545(key);
        }

        @Override
        public void clear() {
            PlayerData data = PlayerData.get((class_1657)PlayerWrapper.this.entity);
            data.scriptStoreddata = new class_2487();
        }

        private class_2487 getStoredCompound() {
            PlayerData data = PlayerData.get((class_1657)PlayerWrapper.this.entity);
            return data.scriptStoreddata;
        }

        @Override
        public String[] getKeys() {
            class_2487 compound = this.getStoredCompound();
            return compound.method_10541().toArray(new String[compound.method_10541().size()]);
        }
    };
    private PlayerData data;

    public PlayerWrapper(T player) {
        super(player);
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public String getName() {
        return ((class_3222)this.entity).method_5477().getString();
    }

    @Override
    public String getDisplayName() {
        return ((class_3222)this.entity).method_5476().getString();
    }

    @Override
    public int getHunger() {
        return ((class_3222)this.entity).method_7344().method_7586();
    }

    @Override
    public void setHunger(int level) {
        ((class_3222)this.entity).method_7344().method_7580(level);
    }

    @Override
    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.finishedQuests.containsKey(id);
    }

    @Override
    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.activeQuests.containsKey(id);
    }

    @Override
    public IQuest[] getActiveQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.activeQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }

    @Override
    public IQuest[] getFinishedQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.finishedQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }

    @Override
    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        QuestData questdata = new QuestData(quest);
        PlayerData data = this.getData();
        data.questData.activeQuests.put(id, questdata);
        Packets.send((class_3222)this.entity, new PacketAchievement((class_2561)class_2561.method_43471((String)"quest.newquest"), (class_2561)class_2561.method_43471((String)quest.title), 2));
        class_5250 text = class_2561.method_43471((String)"quest.newquest").method_27693(":").method_10852((class_2561)class_2561.method_43471((String)quest.title));
        Packets.send((class_3222)this.entity, new PacketChat((class_2561)text));
        data.updateClient = true;
    }

    @Override
    public void sendNotification(String title, String msg, int type) {
        if (type < 0 || type > 3) {
            throw new CustomNPCsException("Wrong type value given " + type, new Object[0]);
        }
        Packets.send((class_3222)this.entity, new PacketAchievement((class_2561)class_2561.method_43471((String)title), (class_2561)class_2561.method_43471((String)msg), type));
    }

    @Override
    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.finishedQuests.put(id, System.currentTimeMillis());
        data.updateClient = true;
    }

    @Override
    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.activeQuests.remove(id);
        data.updateClient = true;
    }

    @Override
    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.activeQuests.remove(id);
        data.questData.finishedQuests.remove(id);
        data.updateClient = true;
    }

    @Override
    public boolean hasReadDialog(int id) {
        PlayerDialogData data = this.getData().dialogData;
        return data.dialogsRead.contains(id);
    }

    @Override
    public void showDialog(int id, String name) {
        Dialog dialog = DialogController.instance.dialogs.get(id);
        if (dialog == null) {
            throw new CustomNPCsException("Unknown Dialog id: " + id, new Object[0]);
        }
        if (!dialog.availability.isAvailable((class_1657)this.entity)) {
            return;
        }
        EntityDialogNpc npc = new EntityDialogNpc((class_1937)this.getWorld().getMCLevel());
        npc.display.setName(name);
        EntityUtil.Copy((class_1309)this.entity, (class_1309)npc);
        DialogOption option = new DialogOption();
        option.dialogId = id;
        option.title = dialog.title;
        npc.dialogs.put(0, option);
        NoppesUtilServer.openDialog((class_1657)this.entity, npc, dialog);
    }

    @Override
    public void addFactionPoints(int faction, int points) {
        PlayerData data = this.getData();
        data.factionData.increasePoints((class_1657)this.entity, faction, points);
        data.updateClient = true;
    }

    @Override
    public int getFactionPoints(int faction) {
        return this.getData().factionData.getFactionPoints((class_1657)this.entity, faction);
    }

    @Override
    public float getRotation() {
        return ((class_3222)this.entity).method_36454();
    }

    @Override
    public void setRotation(float rotation) {
        ((class_3222)this.entity).method_36456(rotation);
    }

    @Override
    public void message(String message) {
        ((class_3222)this.entity).method_43496((class_2561)class_2561.method_43471((String)NoppesStringUtils.formatText(message, this.entity)));
    }

    @Override
    public int getGamemode() {
        return ((class_3222)this.entity).field_13974.method_14257().method_8379();
    }

    @Override
    public void setGamemode(int type) {
        ((class_3222)this.entity).method_7336(class_1934.method_8384((int)type));
    }

    @Override
    public int inventoryItemCount(IItemStack item) {
        int count = 0;
        for (int i = 0; i < ((class_3222)this.entity).method_31548().method_5439(); ++i) {
            class_1799 is = ((class_3222)this.entity).method_31548().method_5438(i);
            if (is == null || !this.isItemEqual(item.getMCItemStack(), is)) continue;
            count += is.method_7947();
        }
        return count;
    }

    private boolean isItemEqual(class_1799 stack, class_1799 other) {
        if (other.method_7960()) {
            return false;
        }
        return stack.method_7909() == other.method_7909();
    }

    @Override
    public int inventoryItemCount(String id) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.inventoryItemCount(NpcAPI.Instance().getIItemStack(new class_1799((class_1935)item, 1)));
    }

    @Override
    public IContainer getInventory() {
        if (this.inventory == null) {
            this.inventory = new ContainerWrapper((class_1263)((class_3222)this.entity).method_31548());
        }
        return this.inventory;
    }

    @Override
    public IItemStack getInventoryHeldItem() {
        return NpcAPI.Instance().getIItemStack(((class_3222)this.entity).field_7512.method_34255());
    }

    @Override
    public boolean removeItem(IItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (amount > count) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < ((class_3222)this.entity).method_31548().method_5439(); ++i) {
                class_1799 is = ((class_3222)this.entity).method_31548().method_5438(i);
                if (is == null || !this.isItemEqual(item.getMCItemStack(), is)) continue;
                if (amount >= is.method_7947()) {
                    ((class_3222)this.entity).method_31548().method_5447(i, class_1799.field_8037);
                    amount -= is.method_7947();
                    continue;
                }
                is.method_7971(amount);
                break;
            }
        }
        this.updatePlayerInventory();
        return true;
    }

    @Override
    public boolean removeItem(String id, int amount) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.removeItem(NpcAPI.Instance().getIItemStack(new class_1799((class_1935)item, 1)), amount);
    }

    @Override
    public boolean giveItem(IItemStack item) {
        class_1799 mcItem = item.getMCItemStack();
        if (mcItem.method_7960()) {
            return false;
        }
        boolean bo = ((class_3222)this.entity).method_31548().method_7394(mcItem.method_7972());
        if (bo) {
            NoppesUtilServer.playSound((class_1309)this.entity, class_3417.field_15197, 0.2f, ((((class_3222)this.entity).method_6051().method_43057() - ((class_3222)this.entity).method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            this.updatePlayerInventory();
        }
        return bo;
    }

    @Override
    public boolean giveItem(String id, int amount) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(id));
        if (item == null) {
            return false;
        }
        class_1799 mcStack = new class_1799((class_1935)item);
        IItemStack itemStack = NpcAPI.Instance().getIItemStack(mcStack);
        itemStack.setStackSize(amount);
        return this.giveItem(itemStack);
    }

    @Override
    public void updatePlayerInventory() {
        ((class_3222)this.entity).field_7498.method_7623();
        ((class_3222)this.entity).field_13987.method_14364((class_2596)new class_2653(-2, 0, ((class_3222)this.entity).method_31548().field_7545, ((class_3222)this.entity).method_31548().method_5438(((class_3222)this.entity).method_31548().field_7545)));
        PlayerQuestData playerdata = this.getData().questData;
        playerdata.checkQuestCompletion((class_1657)this.entity, 0);
    }

    @Override
    public IBlock getSpawnPoint() {
        class_2338 pos = ((class_3222)this.entity).method_18398().orElse(null);
        if (pos == null) {
            return this.getWorld().getSpawnPoint();
        }
        return NpcAPI.Instance().getIBlock(((class_3222)this.entity).method_37908(), pos);
    }

    @Override
    public void setSpawnPoint(IBlock block) {
        this.setSpawnpoint(block.getX(), block.getY(), block.getZ());
    }

    @Override
    public void setSpawnpoint(int x, int y, int z) {
        x = ValueUtil.CorrectInt(x, -30000000, 30000000);
        z = ValueUtil.CorrectInt(z, -30000000, 30000000);
        y = ValueUtil.CorrectInt(y, 0, 256);
        ((class_3222)this.entity).method_26284(this.getWorld().getMCLevel().method_27983(), new class_2338(x, y, z), 0.0f, true, false);
    }

    @Override
    public void resetSpawnpoint() {
        ((class_3222)this.entity).method_26284(this.getWorld().getMCLevel().method_27983(), null, 0.0f, true, false);
    }

    @Override
    public void removeAllItems(IItemStack item) {
        for (int i = 0; i < ((class_3222)this.entity).method_31548().method_5439(); ++i) {
            class_1799 is = ((class_3222)this.entity).method_31548().method_5438(i);
            if (is == null || !class_1799.method_7984((class_1799)is, (class_1799)item.getMCItemStack())) continue;
            ((class_3222)this.entity).method_31548().method_5447(i, class_1799.field_8037);
        }
    }

    @Override
    public boolean hasAdvancement(String achievement) {
        class_161 advancement = ((class_3222)this.entity).method_5682().method_3851().method_12896(new class_2960(achievement));
        if (advancement == null) {
            throw new CustomNPCsException("Advancement doesnt exist", new Object[0]);
        }
        class_167 progress = ((class_3222)this.entity).method_5682().method_3760().method_14578((class_3222)this.entity).method_12882(advancement);
        return progress.method_740();
    }

    @Override
    public int getExpLevel() {
        return ((class_3222)this.entity).field_7520;
    }

    @Override
    public void setExpLevel(int level) {
        ((class_3222)this.entity).method_7316(level - ((class_3222)this.entity).field_7520);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        SPacketDimensionTeleport.teleportPlayer((class_3222)this.entity, x, y, z, (class_5321<class_1937>)((class_3222)this.entity).method_37908().method_27983());
    }

    @Override
    public void setPos(IPos pos) {
        SPacketDimensionTeleport.teleportPlayer((class_3222)this.entity, pos.getX(), pos.getY(), pos.getZ(), (class_5321<class_1937>)((class_3222)this.entity).method_37908().method_27983());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 1 ? true : super.typeOf(type);
    }

    @Override
    public boolean hasPermission(String permission) {
        return false;
    }

    @Override
    public IPixelmonPlayerData getPixelmonData() {
        if (!PixelmonHelper.Enabled) {
            throw new CustomNPCsException("Pixelmon isnt installed", new Object[0]);
        }
        return new IPixelmonPlayerData(){

            @Override
            public Object getParty() {
                if (PlayerWrapper.this.pixelmonPartyStorage == null) {
                    PlayerWrapper.this.pixelmonPartyStorage = PixelmonHelper.getParty((class_1657)PlayerWrapper.this.entity);
                }
                return PlayerWrapper.this.pixelmonPartyStorage;
            }

            @Override
            public Object getPC() {
                if (PlayerWrapper.this.pixelmonPCStorage == null) {
                    PlayerWrapper.this.pixelmonPCStorage = PixelmonHelper.getPc((class_1657)PlayerWrapper.this.entity);
                }
                return PlayerWrapper.this.pixelmonPCStorage;
            }
        };
    }

    private PlayerData getData() {
        if (this.data == null) {
            this.data = PlayerData.get((class_1657)this.entity);
        }
        return this.data;
    }

    @Override
    public ITimers getTimers() {
        return this.getData().timers;
    }

    @Override
    public void removeDialog(int id) {
        PlayerData data = this.getData();
        data.dialogData.dialogsRead.remove(id);
        data.updateClient = true;
    }

    @Override
    public void addDialog(int id) {
        PlayerData data = this.getData();
        data.dialogData.dialogsRead.add(id);
        data.updateClient = true;
    }

    @Override
    public void closeGui() {
        ((class_3222)this.entity).method_7346();
        Packets.send((class_3222)this.entity, new PacketGuiClose(new class_2487()));
    }

    @Override
    public int factionStatus(int factionId) {
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null) {
            throw new CustomNPCsException("Unknown faction: " + factionId, new Object[0]);
        }
        return faction.playerStatus(this);
    }

    @Override
    public void kick(String message) {
        ((class_3222)this.entity).field_13987.method_14367((class_2561)class_2561.method_43471((String)message));
    }

    @Override
    public boolean canQuestBeAccepted(int questId) {
        return PlayerQuestController.canQuestBeAccepted((class_1657)this.entity, questId);
    }

    @Override
    public void showCustomGui(ICustomGui gui) {
        NoppesUtilServer.openContainerGui((class_3222)this.getMCEntity(), EnumGuiType.CustomGui, buf -> buf.method_10794(((CustomGuiWrapper)gui).toNBT()));
        ((ContainerCustomGui)((class_3222)this.getMCEntity()).field_7512).setGui((CustomGuiWrapper)gui, (class_1657)this.entity);
    }

    @Override
    public ICustomGui getCustomGui() {
        if (((class_3222)this.entity).field_7512 instanceof ContainerCustomGui) {
            return ((ContainerCustomGui)((class_3222)this.entity).field_7512).customGui;
        }
        return null;
    }

    @Override
    public void clearData() {
        PlayerData data = this.getData();
        data.setNBT(new class_2487());
        data.save(true);
    }

    @Override
    public IContainer getOpenContainer() {
        return NpcAPI.Instance().getIContainer(((class_3222)this.entity).field_7512);
    }

    @Override
    public void playSound(String sound, float volume, float pitch) {
        class_2338 pos = ((class_3222)this.entity).method_24515();
        Packets.send((class_3222)this.entity, new PacketPlaySound(sound, pos, volume, pitch));
    }

    @Override
    public void playMusic(String sound, boolean background, boolean loops) {
        Packets.send((class_3222)this.entity, new PacketPlayMusic(sound, !background, loops));
    }

    @Override
    public void sendMail(IPlayerMail mail) {
        PlayerData data = this.getData();
        data.mailData.playermail.add(((PlayerMail)mail).copy());
        data.save(false);
    }

    @Override
    public void trigger(int id, Object ... arguments) {
        EventHooks.onScriptTriggerEvent(PlayerData.get((class_1657)((class_1657)this.entity)).scriptData, id, this.getWorld(), this.getPos(), null, arguments);
    }

    @Override
    public void showOverlay(IOverlay overlay) {
        Packets.send((class_3222)this.entity, new PacketOverlayShow(overlay.toNbt()));
    }

    @Override
    public void showSoundSelectionGUI() {
        Packets.send((class_3222)this.entity, new PacketSoundGUIOpen());
    }

    @Override
    public void hideOverlay(int id) {
        Packets.send((class_3222)this.entity, new PacketOverlayHide(id));
    }

    @Override
    public void hideAllOverlays() {
        Packets.send((class_3222)this.entity, new PacketHideAllOverlays(true));
    }

    @Override
    public IPlayerSkin getSkin() {
        return PlayerData.get((class_1657)((class_1657)this.entity)).skinData;
    }
}

