/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IScoreboard;
import noppes.npcs.api.IScoreboardObjective;
import noppes.npcs.api.IScoreboardTeam;
import noppes.npcs.api.wrapper.ScoreboardObjectiveWrapper;
import noppes.npcs.api.wrapper.ScoreboardTeamWrapper;

public class ScoreboardWrapper
implements IScoreboard {
    private class_269 board;
    private MinecraftServer server;

    protected ScoreboardWrapper(MinecraftServer server) {
        this.server = server;
        this.board = server.method_3847(class_1937.field_25179).method_14170();
    }

    @Override
    public IScoreboardObjective[] getObjectives() {
        ArrayList collection = new ArrayList(this.board.method_1151());
        IScoreboardObjective[] objectives = new IScoreboardObjective[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            objectives[i] = new ScoreboardObjectiveWrapper(this.board, (class_266)collection.get(i));
        }
        return objectives;
    }

    @Override
    public String[] getPlayerList() {
        Collection collection = this.board.method_1163();
        return collection.toArray(new String[collection.size()]);
    }

    @Override
    public IScoreboardObjective getObjective(String name) {
        class_266 obj = this.board.method_1170(name);
        if (obj == null) {
            return null;
        }
        return new ScoreboardObjectiveWrapper(this.board, obj);
    }

    @Override
    public boolean hasObjective(String objective) {
        return this.board.method_1170(objective) != null;
    }

    @Override
    public void removeObjective(String objective) {
        class_266 obj = this.board.method_1170(objective);
        if (obj != null) {
            this.board.method_1194(obj);
        }
    }

    @Override
    public IScoreboardObjective addObjective(String objective, String criteria) {
        class_274 icriteria = class_274.method_1224((String)criteria).orElse(null);
        if (icriteria == null) {
            throw new CustomNPCsException("Unknown score criteria: %s", criteria);
        }
        if (objective.length() <= 0 || objective.length() > 16) {
            throw new CustomNPCsException("Score objective must be between 1-16 characters: %s", objective);
        }
        class_266 obj = this.board.method_1168(objective, icriteria, (class_2561)class_2561.method_43471((String)objective), class_274.class_275.field_1472);
        return new ScoreboardObjectiveWrapper(this.board, obj);
    }

    @Override
    public void setPlayerScore(String player, String objective, int score) {
        class_266 objec = this.getObjectiveWithException(objective);
        if (objec.method_1116().method_1226() || score < Integer.MIN_VALUE || score > Integer.MAX_VALUE) {
            return;
        }
        class_267 sco = this.board.method_1180(player, objec);
        sco.method_1128(score);
    }

    private class_266 getObjectiveWithException(String objective) {
        class_266 objec = this.board.method_1170(objective);
        if (objec == null) {
            throw new CustomNPCsException("Score objective does not exist: %s", objective);
        }
        return objec;
    }

    @Override
    public int getPlayerScore(String player, String objective) {
        class_266 objec = this.getObjectiveWithException(objective);
        if (objec.method_1116().method_1226()) {
            return 0;
        }
        return this.board.method_1180(player, objec).method_1126();
    }

    @Override
    public boolean hasPlayerObjective(String player, String objective) {
        class_266 objec = this.getObjectiveWithException(objective);
        return this.board.method_1166(player).get(objec) != null;
    }

    @Override
    public void deletePlayerScore(String player, String objective) {
        class_266 objec = this.getObjectiveWithException(objective);
        if (this.board.method_1166(player).remove(objec) != null) {
            this.board.method_1195(player);
        }
    }

    @Override
    public IScoreboardTeam[] getTeams() {
        ArrayList list = new ArrayList(this.board.method_1159());
        IScoreboardTeam[] teams = new IScoreboardTeam[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            teams[i] = new ScoreboardTeamWrapper((class_268)list.get(i), this.board);
        }
        return teams;
    }

    @Override
    public boolean hasTeam(String name) {
        return this.board.method_1153(name) != null;
    }

    @Override
    public IScoreboardTeam addTeam(String name) {
        if (this.hasTeam(name)) {
            throw new CustomNPCsException("Team %s already exists", name);
        }
        return new ScoreboardTeamWrapper(this.board.method_1171(name), this.board);
    }

    @Override
    public IScoreboardTeam getTeam(String name) {
        class_268 team = this.board.method_1153(name);
        if (team == null) {
            return null;
        }
        return new ScoreboardTeamWrapper(team, this.board);
    }

    @Override
    public void removeTeam(String name) {
        class_268 team = this.board.method_1153(name);
        if (team != null) {
            this.board.method_1191(team);
        }
    }

    @Override
    public IScoreboardTeam getPlayerTeam(String player) {
        class_268 team = this.board.method_1164(player);
        if (team == null) {
            return null;
        }
        return new ScoreboardTeamWrapper(team, this.board);
    }

    @Override
    public void removePlayerTeam(String player) {
        this.board.method_1195(player);
    }
}

