/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import nikedemos.markovnames.generators.MarkovGenerator;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.ICloneHandler;
import noppes.npcs.api.handler.IDialogHandler;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IQuestHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.overlay.IOverlay;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.api.wrapper.ContainerWrapper;
import noppes.npcs.api.wrapper.DamageSourceWrapper;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.api.wrapper.OverlayWrapper;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.containers.ContainerNpcInterface;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.EntityIMixin;
import noppes.npcs.shared.common.util.LRUHashMap;
import noppes.npcs.util.NBTJsonUtil;

public class WrapperNpcAPI
extends NpcAPI {
    private static final Map<class_2874, WorldWrapper> worldCache = new LRUHashMap<class_2874, WorldWrapper>(10);
    private static NpcAPI instance = null;

    public static void clearCache() {
        worldCache.clear();
        BlockWrapper.clearCache();
    }

    @Override
    public IEntity getIEntity(class_1297 entity) {
        if (entity == null || entity.method_37908().field_9236) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).wrappedNPC;
        }
        return WrapperEntityData.get(entity);
    }

    @Override
    public ICustomNpc createNPC(class_1937 level) {
        if (level.field_9236) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, level);
        return npc.wrappedNPC;
    }

    public void registerPermissionNode(String permission, int defaultType) {
        throw new CustomNPCsException("registerPermissionNode is nolonger supported", new Object[0]);
    }

    @Override
    public boolean hasPermissionNode(String permission) {
        return false;
    }

    @Override
    public ICustomNpc spawnNPC(class_1937 level, int x, int y, int z) {
        if (level.field_9236) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, level);
        npc.method_5641((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        npc.ais.setStartPos(x, y, z);
        npc.method_6033(npc.method_6063());
        level.method_8649((class_1297)npc);
        return npc.wrappedNPC;
    }

    public static NpcAPI Instance() {
        if (instance == null) {
            instance = new WrapperNpcAPI();
        }
        return instance;
    }

    @Override
    public IBlock getIBlock(class_1937 level, class_2338 pos) {
        return BlockWrapper.createNew(level, pos, level.method_8320(pos));
    }

    @Override
    public IItemStack getIItemStack(class_1799 itemstack) {
        if (itemstack == null || itemstack.method_7960()) {
            return ItemStackWrapper.AIR;
        }
        if (itemstack.method_7909() == CustomItems.scripted_item) {
            return new ItemScriptedWrapper(itemstack);
        }
        return new ItemStackWrapper(itemstack);
    }

    @Override
    public IWorld getIWorld(class_3218 level) {
        WorldWrapper w = worldCache.get(level.method_8597());
        if (w != null) {
            w.level = level;
            return w;
        }
        w = WorldWrapper.createNew(level);
        worldCache.put(level.method_8597(), w);
        return w;
    }

    @Override
    public IWorld getIWorld(class_2874 dimension) {
        for (class_3218 level : CustomNpcs.Server.method_3738()) {
            if (level.method_8597() != dimension) continue;
            return this.getIWorld(level);
        }
        throw new CustomNPCsException("Unknown dimension: " + String.valueOf(dimension), new Object[0]);
    }

    @Override
    public IWorld getIWorld(String dimension) {
        class_2960 loc = new class_2960(dimension);
        for (class_3218 level : CustomNpcs.Server.method_3738()) {
            if (!level.method_27983().method_29177().equals((Object)loc)) continue;
            return this.getIWorld(level);
        }
        throw new CustomNPCsException("Unknown dimension: " + String.valueOf(loc), new Object[0]);
    }

    @Override
    public IContainer getIContainer(class_1703 inventory) {
        return new ContainerWrapper(inventory);
    }

    @Override
    public IContainer getIContainer(class_1263 container) {
        if (container instanceof ContainerNpcInterface) {
            return ContainerNpcInterface.getOrCreateIContainer((ContainerNpcInterface)container);
        }
        return new ContainerWrapper(container);
    }

    @Override
    public IFactionHandler getFactions() {
        this.checkLevel();
        return FactionController.instance;
    }

    private void checkLevel() {
        if (CustomNpcs.Server == null || CustomNpcs.Server.method_3750()) {
            throw new CustomNPCsException("No world is loaded right now", new Object[0]);
        }
    }

    @Override
    public IRecipeHandler getRecipes() {
        this.checkLevel();
        return RecipeController.instance;
    }

    @Override
    public IQuestHandler getQuests() {
        this.checkLevel();
        return QuestController.instance;
    }

    @Override
    public IWorld[] getIWorlds() {
        this.checkLevel();
        ArrayList<IWorld> list = new ArrayList<IWorld>();
        for (class_3218 level : CustomNpcs.Server.method_3738()) {
            list.add(this.getIWorld(level));
        }
        return list.toArray(new IWorld[list.size()]);
    }

    @Override
    public IPos getIPos(double x, double y, double z) {
        return new BlockPosWrapper(new class_2338((int)x, (int)y, (int)z));
    }

    @Override
    public File getGlobalDir() {
        return CustomNpcs.Dir;
    }

    @Override
    public File getLevelDir() {
        return CustomNpcs.getLevelSaveDirectory();
    }

    @Override
    public INbt getINbt(class_2487 compound) {
        if (compound == null) {
            return new NBTWrapper(new class_2487());
        }
        return new NBTWrapper(compound);
    }

    @Override
    public INbt stringToNbt(String str) {
        if (str == null || str.isEmpty()) {
            throw new CustomNPCsException("Cant cast empty string to nbt", new Object[0]);
        }
        try {
            return this.getINbt(NBTJsonUtil.Convert(str));
        }
        catch (NBTJsonUtil.JsonException e) {
            throw new CustomNPCsException(e, "Failed converting " + str, new Object[0]);
        }
    }

    @Override
    public IDamageSource getIDamageSource(class_1282 damagesource) {
        return new DamageSourceWrapper(damagesource);
    }

    @Override
    public IDialogHandler getDialogs() {
        return DialogController.instance;
    }

    @Override
    public ICloneHandler getClones() {
        return ServerCloneController.Instance;
    }

    @Override
    public String executeCommand(IWorld level, String command) {
        FakePlayer player = EntityNPCInterface.CommandPlayer;
        ((EntityIMixin)player).setLevel((class_1937)level.getMCLevel());
        player.method_5814(0.0, 0.0, 0.0);
        return NoppesUtilServer.runCommand((class_1937)level.getMCLevel(), class_2338.field_10980, "API", command, null, (class_1297)player);
    }

    @Override
    public INbt getRawPlayerData(String uuid) {
        return this.getINbt(PlayerData.loadPlayerData(uuid));
    }

    @Override
    public IPlayerMail createMail(String sender, String subject) {
        PlayerMail mail = new PlayerMail();
        mail.sender = sender;
        mail.subject = subject;
        return mail;
    }

    @Override
    public ICustomGui createCustomGui(int id, int width, int height, boolean pauseGame, IPlayer player) {
        return new CustomGuiWrapper(player, id, width, height, pauseGame);
    }

    @Override
    public IOverlay createOverlay(int id) {
        return new OverlayWrapper(id);
    }

    @Override
    public String getRandomName(int dictionary, int gender) {
        return MarkovGenerator.fetch(dictionary, gender);
    }
}

