/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.server.SPacketGuiOpen;
import org.jetbrains.annotations.Nullable;

public class BlockScripted
extends BlockInterface {
    public static final class_265 AABB = class_259.method_1078((class_238)new class_238((double)0.001f, (double)0.001f, (double)0.001f, (double)0.998f, (double)0.998f, (double)0.998f));

    public BlockScripted() {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10340).method_9626(class_2498.field_11544).method_9629(5.0f, 10.0f));
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileScripted(pos, state);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return AABB;
    }

    public class_265 method_9549(class_2680 blockState, class_1922 level, class_2338 pos, class_3726 context) {
        TileScripted tile = (TileScripted)level.method_8321(pos);
        if (tile != null && tile.isPassible) {
            return class_259.method_1073();
        }
        return AABB;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_1799 currentItem = player.method_31548().method_7391();
        if (currentItem != null && (currentItem.method_7909() == CustomItems.wand || currentItem.method_7909() == CustomItems.scripter)) {
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos);
            return class_1269.field_5812;
        }
        class_243 vec = ray.method_17784();
        float x = (float)(vec.field_1352 - (double)pos.method_10263());
        float y = (float)(vec.field_1351 - (double)pos.method_10264());
        float z = (float)(vec.field_1350 - (double)pos.method_10260());
        TileScripted tile = (TileScripted)level.method_8321(pos);
        return EventHooks.onScriptBlockInteract(tile, player, ray.method_17780().method_10146(), x, y, z) ? class_1269.field_5814 : class_1269.field_5812;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 entity, class_1799 item) {
        if (!level.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos);
        }
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entityIn) {
        if (level.field_9236) {
            return;
        }
        TileScripted tile = (TileScripted)level.method_8321(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void method_9504(class_2680 state, class_1937 level, class_2338 pos, class_1959.class_1963 type) {
        if (level.field_9236 || type != class_1959.class_1963.field_9382) {
            return;
        }
        TileScripted tile = (TileScripted)level.method_8321(pos);
        EventHooks.onScriptBlockRainFill(tile);
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (level.field_9236) {
            return;
        }
        TileScripted tile = (TileScripted)level.method_8321(pos);
        fallDistance = EventHooks.onScriptBlockFallenUpon(tile, entity, fallDistance);
        super.method_9554(level, state, pos, entity, fallDistance);
    }

    public void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        TileScripted tile = (TileScripted)level.method_8321(pos);
        EventHooks.onScriptBlockClicked(tile, player);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!level.field_9236) {
            TileScripted tile = (TileScripted)level.method_8321(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(level, pos, state, player);
    }

    public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        TileScripted tile;
        if (!level.field_9236 && !EventHooks.onScriptBlockHarvest(tile = (TileScripted)level.method_8321(pos), player)) {
            super.method_9556(level, player, pos, state, blockEntity, tool);
        }
    }

    public List<class_1799> method_9560(class_2680 p_287732_, class_8567.class_8568 p_287596_) {
        return Collections.emptyList();
    }

    public void method_9586(class_1937 level, class_2338 pos, class_1927 explosion) {
        TileScripted tile;
        if (!level.field_9236 && EventHooks.onScriptBlockExploded(tile = (TileScripted)level.method_8321(pos))) {
            return;
        }
        super.method_9586(level, pos, explosion);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 pos2, boolean isMoving) {
        if (level.field_9236) {
            return;
        }
        TileScripted tile = (TileScripted)level.method_8321(pos);
        EventHooks.onScriptBlockNeighborChanged(tile, pos2);
        int power = 0;
        for (class_2350 enumfacing : class_2350.values()) {
            int p = level.method_49808(pos.method_10093(enumfacing), enumfacing);
            if (p <= power) continue;
            power = p;
        }
        if (tile.prevPower != power && tile.powering <= 0) {
            tile.newPower = power;
        }
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 worldIn, class_2338 pos, class_2350 side) {
        return this.method_9603(state, worldIn, pos, side);
    }

    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 side) {
        TileScripted tile = (TileScripted)level.method_8321(pos);
        if (tile != null) {
            return tile.activePowering;
        }
        return 0;
    }

    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return super.method_9579(state, level, pos);
    }

    public int method_9505(class_2680 state, class_1922 level, class_2338 pos) {
        TileScripted tile = (TileScripted)level.method_8321(pos);
        if (tile == null) {
            return 0;
        }
        return tile.lightValue;
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        TileScripted tile = (TileScripted)level.method_8321(pos);
        if (tile != null) {
            return tile.isPassible;
        }
        return false;
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 level, class_2338 pos) {
        TileScripted tile = (TileScripted)level.method_8321(pos);
        float f = -1.0f;
        if (tile != null) {
            f = tile.blockHardness;
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = player.method_7305(state) ? 30 : 100;
        return player.method_7351(state) / f / (float)i;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return BlockScripted.method_31618(type, CustomBlocks.tile_scripted, TileScripted::tick);
    }
}

