/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomNpcs;
import noppes.npcs.blocks.BlockNpcRedstone;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.Availability;

public class TileRedstoneBlock
extends TileNpcEntity {
    public int onRange = 12;
    public int offRange = 20;
    public int onRangeX = 12;
    public int onRangeY = 12;
    public int onRangeZ = 12;
    public int offRangeX = 20;
    public int offRangeY = 20;
    public int offRangeZ = 20;
    public boolean isDetailed = false;
    public Availability availability = new Availability();
    public boolean isActivated = false;
    private int ticks = 10;

    public TileRedstoneBlock(class_2338 pos, class_2680 state) {
        super(CustomBlocks.tile_redstoneblock, pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TileRedstoneBlock tile) {
        if (tile.field_11863.field_9236) {
            return;
        }
        --tile.ticks;
        if (tile.ticks > 0) {
            return;
        }
        tile.ticks = tile.onRange > 10 ? 20 : 10;
        class_2248 block = state.method_26204();
        if (block == null || !(block instanceof BlockNpcRedstone)) {
            return;
        }
        if (CustomNpcs.FreezeNPCs) {
            if (tile.isActivated) {
                tile.setActive(block, false);
            }
            return;
        }
        if (!tile.isActivated) {
            int z;
            int y;
            int x = tile.isDetailed ? tile.onRangeX : tile.onRange;
            List<class_1657> list = tile.getPlayerList(x, y = tile.isDetailed ? tile.onRangeY : tile.onRange, z = tile.isDetailed ? tile.onRangeZ : tile.onRange);
            if (list.isEmpty()) {
                return;
            }
            for (class_1657 player : list) {
                if (!tile.availability.isAvailable(player)) continue;
                tile.setActive(block, true);
                return;
            }
        } else {
            int x = tile.isDetailed ? tile.offRangeX : tile.offRange;
            int y = tile.isDetailed ? tile.offRangeY : tile.offRange;
            int z = tile.isDetailed ? tile.offRangeZ : tile.offRange;
            List<class_1657> list = tile.getPlayerList(x, y, z);
            for (class_1657 player : list) {
                if (!tile.availability.isAvailable(player)) continue;
                return;
            }
            tile.setActive(block, false);
        }
    }

    private void setActive(class_2248 block, boolean bo) {
        this.isActivated = bo;
        class_2680 state = (class_2680)block.method_9564().method_11657((class_2769)BlockNpcRedstone.ACTIVE, (Comparable)Boolean.valueOf(this.isActivated));
        this.field_11863.method_8652(this.field_11867, state, 2);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, state, state, 3);
        block.method_9615(state, this.field_11863, this.field_11867, state, false);
    }

    private List<class_1657> getPlayerList(int x, int y, int z) {
        return this.field_11863.method_18467(class_1657.class, new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 1)).method_1009((double)x, (double)y, (double)z));
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.onRange = compound.method_10550("BlockOnRange");
        this.offRange = compound.method_10550("BlockOffRange");
        this.isDetailed = compound.method_10577("BlockIsDetailed");
        if (compound.method_10545("BlockOnRangeX")) {
            this.isDetailed = true;
            this.onRangeX = compound.method_10550("BlockOnRangeX");
            this.onRangeY = compound.method_10550("BlockOnRangeY");
            this.onRangeZ = compound.method_10550("BlockOnRangeZ");
            this.offRangeX = compound.method_10550("BlockOffRangeX");
            this.offRangeY = compound.method_10550("BlockOffRangeY");
            this.offRangeZ = compound.method_10550("BlockOffRangeZ");
        }
        if (compound.method_10545("BlockActivated")) {
            this.isActivated = compound.method_10577("BlockActivated");
        }
        this.availability.load(compound);
    }

    @Override
    public void method_11007(class_2487 compound) {
        compound.method_10569("BlockOnRange", this.onRange);
        compound.method_10569("BlockOffRange", this.offRange);
        compound.method_10556("BlockActivated", this.isActivated);
        compound.method_10556("BlockIsDetailed", this.isDetailed);
        if (this.isDetailed) {
            compound.method_10569("BlockOnRangeX", this.onRangeX);
            compound.method_10569("BlockOnRangeY", this.onRangeY);
            compound.method_10569("BlockOnRangeZ", this.onRangeZ);
            compound.method_10569("BlockOffRangeX", this.offRangeX);
            compound.method_10569("BlockOffRangeY", this.offRangeY);
            compound.method_10569("BlockOffRangeZ", this.offRangeZ);
        }
        this.availability.save(compound);
        super.method_11007(compound);
    }
}

