/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5558;
import net.minecraft.class_7923;
import noppes.npcs.CustomBlocks;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.TextBlock;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.block.ITextPlane;
import noppes.npcs.api.event.Event;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptBlockHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.util.ValueUtil;

public class TileScripted
extends TileNpcEntity
implements IScriptBlockHandler {
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public String scriptLanguage = "ECMAScript";
    public boolean enabled = false;
    private IBlock blockDummy = null;
    public DataTimers timers = new DataTimers(this);
    public long lastInited = -1L;
    private short tickCount = 0;
    public class_1799 itemModel = new class_1799((class_1935)CustomBlocks.scripted);
    public class_2248 blockModel = null;
    public boolean needsClientUpdate = false;
    public int powering = 0;
    public int activePowering = 0;
    public int newPower = 0;
    public int prevPower = 0;
    public boolean isPassible = false;
    public boolean isLadder = false;
    public int lightValue = 0;
    public float blockHardness = 5.0f;
    public float blockResistance = 10.0f;
    public int rotationX = 0;
    public int rotationY = 0;
    public int rotationZ = 0;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public class_2586 renderTile;
    public class_2680 renderState;
    public boolean renderTileErrored = true;
    public class_5558 renderTileUpdate = null;
    public TextPlane text1 = new TextPlane();
    public TextPlane text2 = new TextPlane();
    public TextPlane text3 = new TextPlane();
    public TextPlane text4 = new TextPlane();
    public TextPlane text5 = new TextPlane();
    public TextPlane text6 = new TextPlane();

    public TileScripted(class_2338 pos, class_2680 state) {
        super(CustomBlocks.tile_scripted, pos, state);
    }

    @Override
    public IBlock getBlock() {
        if (this.blockDummy == null) {
            this.blockDummy = new BlockScriptedWrapper(this.method_10997(), CustomBlocks.scripted, this.method_11016());
        }
        return this.blockDummy;
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.setNBT(compound);
        this.setDisplayNBT(compound);
        this.timers.load(compound);
    }

    public void setNBT(class_2487 compound) {
        this.scripts = NBTTags.GetScript(compound.method_10554("Scripts", 10), this);
        this.scriptLanguage = compound.method_10558("ScriptLanguage");
        this.enabled = compound.method_10577("ScriptEnabled");
        this.activePowering = this.powering = compound.method_10550("BlockPowering");
        this.prevPower = compound.method_10550("BlockPrevPower");
        if (compound.method_10545("BlockHardness")) {
            this.blockHardness = compound.method_10583("BlockHardness");
            this.blockResistance = compound.method_10583("BlockResistance");
        }
    }

    public void setDisplayNBT(class_2487 compound) {
        this.itemModel = class_1799.method_7915((class_2487)compound.method_10562("ScriptBlockModel"));
        if (this.itemModel.method_7960()) {
            this.itemModel = new class_1799((class_1935)CustomBlocks.scripted);
        }
        if (compound.method_10545("ScriptBlockModelBlock")) {
            this.blockModel = (class_2248)class_7923.field_41175.method_10223(new class_2960(compound.method_10558("ScriptBlockModelBlock")));
        }
        this.renderTileUpdate = null;
        this.renderTile = null;
        this.renderTileErrored = false;
        this.lightValue = compound.method_10550("LightValue");
        this.isLadder = compound.method_10577("IsLadder");
        this.isPassible = compound.method_10577("IsPassible");
        this.rotationX = compound.method_10550("RotationX");
        this.rotationY = compound.method_10550("RotationY");
        this.rotationZ = compound.method_10550("RotationZ");
        this.scaleX = compound.method_10583("ScaleX");
        this.scaleY = compound.method_10583("ScaleY");
        this.scaleZ = compound.method_10583("ScaleZ");
        if (this.scaleX <= 0.0f) {
            this.scaleX = 1.0f;
        }
        if (this.scaleY <= 0.0f) {
            this.scaleY = 1.0f;
        }
        if (this.scaleZ <= 0.0f) {
            this.scaleZ = 1.0f;
        }
        if (compound.method_10545("Text3")) {
            this.text1.setNBT(compound.method_10562("Text1"));
            this.text2.setNBT(compound.method_10562("Text2"));
            this.text3.setNBT(compound.method_10562("Text3"));
            this.text4.setNBT(compound.method_10562("Text4"));
            this.text5.setNBT(compound.method_10562("Text5"));
            this.text6.setNBT(compound.method_10562("Text6"));
        }
    }

    @Override
    public void method_11007(class_2487 compound) {
        this.getNBT(compound);
        this.getDisplayNBT(compound);
        this.timers.save(compound);
        super.method_11007(compound);
    }

    public class_2487 getNBT(class_2487 compound) {
        compound.method_10566("Scripts", (class_2520)NBTTags.NBTScript(this.scripts));
        compound.method_10582("ScriptLanguage", this.scriptLanguage);
        compound.method_10556("ScriptEnabled", this.enabled);
        compound.method_10569("BlockPowering", this.powering);
        compound.method_10569("BlockPrevPower", this.prevPower);
        compound.method_10548("BlockHardness", this.blockHardness);
        compound.method_10548("BlockResistance", this.blockResistance);
        return compound;
    }

    public class_2487 getDisplayNBT(class_2487 compound) {
        class_2487 itemcompound = new class_2487();
        this.itemModel.method_7953(itemcompound);
        if (this.blockModel != null) {
            class_2960 resourcelocation = class_7923.field_41175.method_10221((Object)this.blockModel);
            compound.method_10582("ScriptBlockModelBlock", resourcelocation == null ? "" : resourcelocation.toString());
        }
        compound.method_10566("ScriptBlockModel", (class_2520)itemcompound);
        compound.method_10569("LightValue", this.lightValue);
        compound.method_10556("IsLadder", this.isLadder);
        compound.method_10556("IsPassible", this.isPassible);
        compound.method_10569("RotationX", this.rotationX);
        compound.method_10569("RotationY", this.rotationY);
        compound.method_10569("RotationZ", this.rotationZ);
        compound.method_10548("ScaleX", this.scaleX);
        compound.method_10548("ScaleY", this.scaleY);
        compound.method_10548("ScaleZ", this.scaleZ);
        compound.method_10566("Text1", (class_2520)this.text1.getNBT());
        compound.method_10566("Text2", (class_2520)this.text2.getNBT());
        compound.method_10566("Text3", (class_2520)this.text3.getNBT());
        compound.method_10566("Text4", (class_2520)this.text4.getNBT());
        compound.method_10566("Text5", (class_2520)this.text5.getNBT());
        compound.method_10566("Text6", (class_2520)this.text6.getNBT());
        return compound;
    }

    private boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.field_11863.field_9236;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TileScripted tile) {
        if (tile.renderTileUpdate != null) {
            try {
                tile.renderTileUpdate.tick(level, pos, tile.renderState, tile.renderTile);
            }
            catch (Exception e) {
                tile.renderTileUpdate = null;
            }
        }
        tile.tickCount = (short)(tile.tickCount + 1);
        if (tile.prevPower != tile.newPower && tile.powering <= 0) {
            EventHooks.onScriptBlockRedstonePower(tile, tile.prevPower, tile.newPower);
            tile.prevPower = tile.newPower;
        }
        tile.timers.update();
        if (tile.tickCount >= 10) {
            EventHooks.onScriptBlockUpdate(tile);
            tile.tickCount = 0;
            if (tile.needsClientUpdate) {
                tile.method_5431();
                level.method_8413(pos, state, state, 3);
                tile.needsClientUpdate = false;
            }
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 compound = new class_2487();
        compound.method_10569("x", this.field_11867.method_10263());
        compound.method_10569("y", this.field_11867.method_10264());
        compound.method_10569("z", this.field_11867.method_10260());
        this.getDisplayNBT(compound);
        return compound;
    }

    public void setItemModel(class_1799 item, class_2248 b) {
        if (item == null || item.method_7960()) {
            item = new class_1799((class_1935)CustomBlocks.scripted);
        }
        if (NoppesUtilPlayer.compareItems(item, this.itemModel, false, false) && b != this.blockModel) {
            return;
        }
        this.itemModel = item;
        this.blockModel = b;
        this.needsClientUpdate = true;
    }

    public void setLightValue(int value) {
        if (value == this.lightValue) {
            return;
        }
        this.lightValue = ValueUtil.CorrectInt(value, 0, 15);
        this.needsClientUpdate = true;
    }

    public void setRedstonePower(int strength) {
        if (this.powering == strength) {
            return;
        }
        this.prevPower = this.activePowering = ValueUtil.CorrectInt(strength, 0, 15);
        this.field_11863.method_8452(this.field_11867, CustomBlocks.scripted);
        this.powering = this.activePowering;
    }

    public void setScale(float x, float y, float z) {
        if (this.scaleX == x && this.scaleY == y && this.scaleZ == z) {
            return;
        }
        this.scaleX = ValueUtil.correctFloat(x, 0.0f, 10.0f);
        this.scaleY = ValueUtil.correctFloat(y, 0.0f, 10.0f);
        this.scaleZ = ValueUtil.correctFloat(z, 0.0f, 10.0f);
        this.needsClientUpdate = true;
    }

    public void setRotation(int x, int y, int z) {
        if (this.rotationX == x && this.rotationY == y && this.rotationZ == z) {
            return;
        }
        this.rotationX = ValueUtil.CorrectInt(x, 0, 359);
        this.rotationY = ValueUtil.CorrectInt(y, 0, 359);
        this.rotationZ = ValueUtil.CorrectInt(z, 0, 359);
        this.needsClientUpdate = true;
    }

    @Override
    public void runScript(EnumScriptType type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (type != EnumScriptType.INIT) {
                EventHooks.onScriptBlockInit(this);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    @Override
    public boolean isClient() {
        return this.method_10997().field_9236;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public String noticeString() {
        class_2338 pos = this.method_11016();
        return MoreObjects.toStringHelper((Object)this).add("x", pos.method_10263()).add("y", pos.method_10264()).add("z", pos.method_10260()).toString();
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                map.put(entry.getKey(), " tab " + tab + ":\n" + entry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    public class TextPlane
    implements ITextPlane {
        public boolean textHasChanged = true;
        public TextBlock textBlock;
        public String text = "";
        public int rotationX = 0;
        public int rotationY = 0;
        public int rotationZ = 0;
        public float offsetX = 0.0f;
        public float offsetY = 0.0f;
        public float offsetZ = 0.5f;
        public float scale = 1.0f;

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String text) {
            if (this.text.equals(text)) {
                return;
            }
            this.text = text;
            this.textHasChanged = true;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public int getRotationX() {
            return this.rotationX;
        }

        @Override
        public int getRotationY() {
            return this.rotationY;
        }

        @Override
        public int getRotationZ() {
            return this.rotationZ;
        }

        @Override
        public void setRotationX(int x) {
            if (this.rotationX == (x = ValueUtil.CorrectInt(x % 360, 0, 359))) {
                return;
            }
            this.rotationX = x;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setRotationY(int y) {
            if (this.rotationY == (y = ValueUtil.CorrectInt(y % 360, 0, 359))) {
                return;
            }
            this.rotationY = y;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setRotationZ(int z) {
            if (this.rotationZ == (z = ValueUtil.CorrectInt(z % 360, 0, 359))) {
                return;
            }
            this.rotationZ = z;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public float getOffsetX() {
            return this.offsetX;
        }

        @Override
        public float getOffsetY() {
            return this.offsetY;
        }

        @Override
        public float getOffsetZ() {
            return this.offsetZ;
        }

        @Override
        public void setOffsetX(float x) {
            if (this.offsetX == (x = ValueUtil.correctFloat(x, -1.0f, 1.0f))) {
                return;
            }
            this.offsetX = x;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setOffsetY(float y) {
            if (this.offsetY == (y = ValueUtil.correctFloat(y, -1.0f, 1.0f))) {
                return;
            }
            this.offsetY = y;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setOffsetZ(float z) {
            if (this.offsetZ == (z = ValueUtil.correctFloat(z, -1.0f, 1.0f))) {
                return;
            }
            System.out.println(this.rotationZ);
            this.offsetZ = z;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public float getScale() {
            return this.scale;
        }

        @Override
        public void setScale(float scale) {
            if (this.scale == scale) {
                return;
            }
            this.scale = scale;
            TileScripted.this.needsClientUpdate = true;
        }

        public class_2487 getNBT() {
            class_2487 compound = new class_2487();
            compound.method_10582("Text", this.text);
            compound.method_10569("RotationX", this.rotationX);
            compound.method_10569("RotationY", this.rotationY);
            compound.method_10569("RotationZ", this.rotationZ);
            compound.method_10548("OffsetX", this.offsetX);
            compound.method_10548("OffsetY", this.offsetY);
            compound.method_10548("OffsetZ", this.offsetZ);
            compound.method_10548("Scale", this.scale);
            return compound;
        }

        public void setNBT(class_2487 compound) {
            this.setText(compound.method_10558("Text"));
            this.rotationX = compound.method_10550("RotationX");
            this.rotationY = compound.method_10550("RotationY");
            this.rotationZ = compound.method_10550("RotationZ");
            this.offsetX = compound.method_10583("OffsetX");
            this.offsetY = compound.method_10583("OffsetY");
            this.offsetZ = compound.method_10583("OffsetZ");
            this.scale = compound.method_10583("Scale");
        }
    }
}

