/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import noppes.npcs.CustomBlocks;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.event.Event;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.blocks.tiles.TileDoor;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptBlockHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.data.DataTimers;

public class TileScriptedDoor
extends TileDoor
implements IScriptBlockHandler {
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public boolean shouldRefreshData = false;
    public String scriptLanguage = "ECMAScript";
    public boolean enabled = false;
    private IBlock blockDummy = null;
    public DataTimers timers = new DataTimers(this);
    public long lastInited = -1L;
    private short tickCount = 0;
    public int newPower = 0;
    public int prevPower = 0;
    public float blockHardness = 5.0f;
    public float blockResistance = 10.0f;

    public TileScriptedDoor(class_2338 pos, class_2680 state) {
        super(CustomBlocks.tile_scripteddoor, pos, state);
    }

    @Override
    public IBlock getBlock() {
        if (this.blockDummy == null) {
            this.blockDummy = new BlockScriptedDoorWrapper(this.method_10997(), CustomBlocks.scripted_door, this.method_11016());
        }
        return this.blockDummy;
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.setNBT(compound);
        this.timers.load(compound);
    }

    public void setNBT(class_2487 compound) {
        this.scripts = NBTTags.GetScript(compound.method_10554("Scripts", 10), this);
        this.scriptLanguage = compound.method_10558("ScriptLanguage");
        this.enabled = compound.method_10577("ScriptEnabled");
        this.prevPower = compound.method_10550("BlockPrevPower");
        if (compound.method_10545("BlockHardness")) {
            this.blockHardness = compound.method_10583("BlockHardness");
            this.blockResistance = compound.method_10583("BlockResistance");
        }
    }

    @Override
    public void method_11007(class_2487 compound) {
        this.getNBT(compound);
        this.timers.save(compound);
        super.method_11007(compound);
    }

    public class_2487 getNBT(class_2487 compound) {
        compound.method_10566("Scripts", (class_2520)NBTTags.NBTScript(this.scripts));
        compound.method_10582("ScriptLanguage", this.scriptLanguage);
        compound.method_10556("ScriptEnabled", this.enabled);
        compound.method_10569("BlockPrevPower", this.prevPower);
        compound.method_10548("BlockHardness", this.blockHardness);
        compound.method_10548("BlockResistance", this.blockResistance);
        return compound;
    }

    @Override
    public void runScript(EnumScriptType type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (type != EnumScriptType.INIT) {
                EventHooks.onScriptBlockInit(this);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    private boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.field_11863.field_9236;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TileScriptedDoor tile) {
        tile.tickCount = (short)(tile.tickCount + 1);
        if (tile.prevPower != tile.newPower) {
            EventHooks.onScriptBlockRedstonePower(tile, tile.prevPower, tile.newPower);
            tile.prevPower = tile.newPower;
        }
        tile.timers.update();
        if (tile.tickCount >= 10) {
            EventHooks.onScriptBlockUpdate(tile);
            tile.tickCount = 0;
        }
    }

    @Override
    public boolean isClient() {
        return this.method_10997().field_9236;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String noticeString() {
        class_2338 pos = this.method_11016();
        return MoreObjects.toStringHelper((Object)this).add("x", pos.method_10263()).add("y", pos.method_10264()).add("z", pos.method_10260()).toString();
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                map.put(entry.getKey(), " tab " + tab + ":\n" + entry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }
}

