/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import noppes.npcs.CustomNpcs;
import noppes.npcs.IChatMessages;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.entity.EntityNPCInterface;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class ChatMessages
implements IChatMessages {
    private static Map<String, ChatMessages> users = new Hashtable<String, ChatMessages>();
    protected static final class_4668.class_4685 TRANSLUCENT_TRANSPARENCY = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final class_4668.class_5942 sharder = new class_4668.class_5942(class_757::method_34547);
    protected static final class_1921 type = class_1921.method_24049((String)"chatbubble", (class_293)class_290.field_21468, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23603(new class_4668.class_4671(true)).method_23608(new class_4668.class_4676(true)).method_34578(sharder).method_23617(true));
    protected static final class_1921 typeDepth = class_1921.method_24049((String)"chatbubbledepth", (class_293)class_290.field_21468, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23603(new class_4668.class_4671(true)).method_23615(TRANSLUCENT_TRANSPARENCY).method_34578(sharder).method_23608(new class_4668.class_4676(true)).method_23604(new class_4668.class_4672("always", 519)).method_23617(false));
    private Map<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
    private int boxLength = 46;
    private float scale = 0.5f;
    private String lastMessage = "";
    private long lastMessageTime = 0L;

    @Override
    public void addMessage(String message, EntityNPCInterface npc) {
        if (!CustomNpcs.EnableChatBubbles) {
            return;
        }
        long time = System.currentTimeMillis();
        if (message.equals(this.lastMessage) && this.lastMessageTime + 1000L > time) {
            return;
        }
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>(this.messages);
        messages.put(time, new TextBlockClient(message, this.boxLength * 4, true, new Object[]{class_310.method_1551().field_1724, npc}));
        if (messages.size() > 3) {
            messages.remove(messages.keySet().iterator().next());
        }
        this.messages = messages;
        this.lastMessage = message;
        this.lastMessageTime = time;
    }

    @Override
    public void renderMessages(class_4587 PoseStack, class_4597 typeBuffer, float textscale, boolean inRange, int lightmapUV) {
        Map<Long, TextBlockClient> messages = this.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34547);
        if (inRange) {
            this.render(PoseStack, typeBuffer, typeBuffer.getBuffer(typeDepth), textscale, false, lightmapUV);
        }
        this.render(PoseStack, typeBuffer, typeBuffer.getBuffer(type), textscale, true, lightmapUV);
    }

    public void render(class_4587 poseStack, class_4597 typeBuffer, class_4588 ivertex, float textScale, boolean depth, int lightmapUV) {
        class_327 font = class_310.method_1551().field_1772;
        float var14 = 0.02666667f;
        int size = 0;
        for (TextBlockClient block : this.messages.values()) {
            size += block.lines.size();
        }
        class_310 mc = class_310.method_1551();
        Objects.requireNonNull(font);
        int textYSize = (int)((float)(size * 9) * this.scale);
        poseStack.method_22903();
        poseStack.method_46416(0.0f, (float)textYSize * var14, 0.0f);
        poseStack.method_22905(textScale, textScale, textScale);
        poseStack.method_22907(mc.method_1561().method_24197());
        poseStack.method_22905(-var14, -var14, var14);
        int black = depth ? -16777216 : -16777216;
        int white = depth ? -1140850689 : 0x44FFFFFF;
        class_4587.class_4665 entry = poseStack.method_23760();
        Matrix4f matrix = entry.method_23761();
        this.drawRect(ivertex, matrix, lightmapUV, -this.boxLength - 2, -2.0f, this.boxLength + 2, textYSize + 1, white, 0.11f);
        this.drawRect(ivertex, matrix, lightmapUV, -this.boxLength - 1, -3.0f, this.boxLength + 1, -2.0f, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, -this.boxLength - 1, textYSize + 2, -1.0f, textYSize + 1, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, 3.0f, textYSize + 2, this.boxLength + 1, textYSize + 1, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, -this.boxLength - 3, -1.0f, -this.boxLength - 2, textYSize, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, this.boxLength + 3, -1.0f, this.boxLength + 2, textYSize, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, -this.boxLength - 2, -2.0f, -this.boxLength - 1, -1.0f, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, this.boxLength + 2, -2.0f, this.boxLength + 1, -1.0f, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, -this.boxLength - 2, textYSize + 1, -this.boxLength - 1, textYSize, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, this.boxLength + 2, textYSize + 1, this.boxLength + 1, textYSize, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, 0.0f, textYSize + 1, 3.0f, textYSize + 4, white, 0.11f);
        this.drawRect(ivertex, matrix, lightmapUV, -1.0f, textYSize + 4, 1.0f, textYSize + 5, white, 0.11f);
        this.drawRect(ivertex, matrix, lightmapUV, -1.0f, textYSize + 1, 0.0f, textYSize + 4, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, 3.0f, textYSize + 1, 4.0f, textYSize + 3, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, 2.0f, textYSize + 3, 3.0f, textYSize + 4, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, 1.0f, textYSize + 4, 2.0f, textYSize + 5, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, -2.0f, textYSize + 4, -1.0f, textYSize + 5, black, 0.1f);
        this.drawRect(ivertex, matrix, lightmapUV, -2.0f, textYSize + 5, 1.0f, textYSize + 6, black, 0.1f);
        poseStack.method_22905(this.scale, this.scale, this.scale);
        int index = 0;
        for (TextBlockClient block : this.messages.values()) {
            for (class_2561 chat : block.lines) {
                float f = -font.method_27525((class_5348)chat) / 2;
                Objects.requireNonNull(font);
                font.method_30882(chat, f, (float)(index * 9), black, false, matrix, typeBuffer, !depth ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, lightmapUV);
                ++index;
            }
        }
        poseStack.method_22909();
    }

    public void drawRect(class_4588 ivertex, Matrix4f matrix, int lightmapUV, float x, float y, float x2, float y2, int color, float z) {
        float j1;
        if (x < x2) {
            j1 = x;
            x = x2;
            x2 = j1;
        }
        if (y < y2) {
            j1 = y;
            y = y2;
            y2 = j1;
        }
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        this.draw(ivertex, matrix, lightmapUV, x, y, z, f1, f2, f3);
        this.draw(ivertex, matrix, lightmapUV, x, y2, z, f1, f2, f3);
        this.draw(ivertex, matrix, lightmapUV, x2, y2, z, f1, f2, f3);
        this.draw(ivertex, matrix, lightmapUV, x2, y, z, f1, f2, f3);
    }

    private void draw(class_4588 ivertex, Matrix4f matrix, int lightmapUV, float x, float y, float z, float red, float green, float blue) {
        Vector4f v = new Vector4f(x, y, z, 1.0f);
        v.mul((Matrix4fc)matrix);
        ivertex.method_22912((double)v.x(), (double)v.y(), (double)v.z()).method_22915(red, green, blue, 1.0f).method_22916(lightmapUV).method_1344();
    }

    public static ChatMessages getChatMessages(String username) {
        if (users.containsKey(username)) {
            return users.get(username);
        }
        ChatMessages chat = new ChatMessages();
        users.put(username, chat);
        return chat;
    }

    private static boolean validPlayer(String username) {
        for (class_1657 player : class_310.method_1551().field_1687.method_18456()) {
            if (!username.equals(player.method_5477()) && !username.equals(player.method_5476().getString())) continue;
            return true;
        }
        return false;
    }

    private Map<Long, TextBlockClient> getMessages() {
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
        long time = System.currentTimeMillis();
        for (Map.Entry<Long, TextBlockClient> entry : this.messages.entrySet()) {
            if (time > entry.getKey() + 10000L) continue;
            messages.put(entry.getKey(), entry.getValue());
        }
        this.messages = messages;
        return this.messages;
    }

    public boolean hasMessage() {
        return !this.messages.isEmpty();
    }
}

