/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import org.joml.Matrix4f;

public class CustomGuiTexturedRect
extends class_339
implements IGuiComponent {
    private CustomGuiTexturedRectWrapper component = null;
    GuiCustom parent;
    class_2960 texture;
    public int id;
    public int x;
    public int y;
    public int width;
    public int height;
    public int textureX;
    public int textureY;
    float scale = 1.0f;
    List<class_2561> hoverText;
    public boolean hasRepeatingTexture = false;
    public int texRepWidth;
    public int texRepHeight;
    public int texRepBorderSize = 0;

    public CustomGuiTexturedRect(GuiCustom parent, CustomGuiTexturedRectWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (class_2561)class_2561.method_43473());
        this.component = component;
        this.parent = parent;
        this.method_25426();
    }

    @Override
    public void method_25426() {
        this.id = this.component.getID();
        this.texture = new class_2960(this.component.getTexture());
        this.x = this.component.getPosX();
        this.y = this.component.getPosY();
        this.width = this.component.getWidth();
        this.height = this.component.getHeight();
        this.textureX = this.component.getTextureX();
        this.textureY = this.component.getTextureY();
        this.scale = this.component.getScale();
        this.hasRepeatingTexture = this.component.hasRepeatingTexture;
        this.texRepWidth = this.component.texRepWidth;
        this.texRepHeight = this.component.texRepHeight;
        this.texRepBorderSize = this.component.texRepBorderSize;
        if (this.component.hasHoverText()) {
            this.hoverText = this.component.getHoverTextList();
        }
    }

    public CustomGuiTexturedRect setRep(int texRepWidth, int texRepHeight, int texRepBorderSize) {
        this.texRepWidth = texRepWidth;
        this.texRepHeight = texRepHeight;
        this.texRepBorderSize = texRepBorderSize;
        this.hasRepeatingTexture = true;
        return this;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.component.getTexture().isEmpty() || !this.component.getVisible()) {
            return;
        }
        boolean hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        graphics.method_51448().method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        Matrix4f m = graphics.method_51448().method_23760().method_23761();
        if (!this.hasRepeatingTexture) {
            this.draw(m, this.x, this.y, this.textureX, this.textureY, this.width, this.height);
        } else {
            if (this.texRepBorderSize > 0) {
                this.draw(m, this.x, this.y, this.textureX, this.textureY, this.texRepBorderSize, this.texRepBorderSize);
                this.draw(m, this.x + this.width - this.texRepBorderSize, this.y, this.textureX + this.texRepWidth - this.texRepBorderSize, this.textureY, this.texRepBorderSize, this.texRepBorderSize);
                this.draw(m, this.x, this.y + this.height - this.texRepBorderSize, this.textureX, this.textureY + this.texRepHeight - this.texRepBorderSize, this.texRepBorderSize, this.texRepBorderSize);
                this.draw(m, this.x + this.width - this.texRepBorderSize, this.y + this.height - this.texRepBorderSize, this.textureX + this.texRepWidth - this.texRepBorderSize, this.textureY + this.texRepHeight - this.texRepBorderSize, this.texRepBorderSize, this.texRepBorderSize);
            }
            float w = (float)this.width - (float)this.texRepBorderSize * 2.0f;
            float h = (float)this.height - (float)this.texRepBorderSize * 2.0f;
            float tw = (float)this.texRepWidth - (float)this.texRepBorderSize * 2.0f;
            float th = (float)this.texRepHeight - (float)this.texRepBorderSize * 2.0f;
            float mx = w / tw;
            float my = h / th;
            int i = 0;
            while ((float)i < my) {
                float dh = th * Math.min(1.0f, my - (float)i);
                this.draw(m, this.x, (float)(this.y + this.texRepBorderSize) + th * (float)i, this.textureX, this.textureY + this.texRepBorderSize, this.texRepBorderSize, dh);
                this.draw(m, this.x + this.width - this.texRepBorderSize, (float)(this.y + this.texRepBorderSize) + th * (float)i, this.textureX + this.texRepWidth - this.texRepBorderSize, this.textureY + this.texRepBorderSize, this.texRepBorderSize, dh);
                int j = 0;
                while ((float)j < mx) {
                    float dw = tw * Math.min(1.0f, mx - (float)j);
                    this.draw(m, (float)(this.x + this.texRepBorderSize) + tw * (float)j, this.y, this.textureX + this.texRepBorderSize, this.textureY, dw, this.texRepBorderSize);
                    this.draw(m, (float)(this.x + this.texRepBorderSize) + tw * (float)j, this.y + this.height - this.texRepBorderSize, this.textureX + this.texRepBorderSize, this.textureY + this.texRepHeight - this.texRepBorderSize, dw, this.texRepBorderSize);
                    this.draw(m, (float)(this.x + this.texRepBorderSize) + tw * (float)j, (float)(this.y + this.texRepBorderSize) + th * (float)i, this.textureX + this.texRepBorderSize, this.textureY + this.texRepBorderSize, dw, dh);
                    ++j;
                }
                ++i;
            }
        }
        if (hovered && this.hoverText != null && this.hoverText.size() > 0) {
            this.parent.hoverText = this.hoverText;
        }
        graphics.method_51448().method_22909();
    }

    private void draw(Matrix4f m, float x, float y, float texX, float texY, float width, float height) {
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        int blitLevel = Math.max(0, this.id);
        bufferbuilder.method_22918(m, x, y + height * this.scale, (float)blitLevel).method_22913(texX * 0.00390625f, (texY + height) * 0.00390625f).method_1344();
        bufferbuilder.method_22918(m, x + width * this.scale, y + height * this.scale, (float)blitLevel).method_22913((texX + width) * 0.00390625f, (texY + height) * 0.00390625f).method_1344();
        bufferbuilder.method_22918(m, x + width * this.scale, y, (float)blitLevel).method_22913((texX + width) * 0.00390625f, texY * 0.00390625f).method_1344();
        bufferbuilder.method_22918(m, x, y, (float)blitLevel).method_22913(texX * 0.00390625f, texY * 0.00390625f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }

    public void setTexture(class_2960 texture) {
        this.texture = texture;
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }

    public void method_25354(class_1144 p_93665_) {
    }

    protected void method_48579(class_332 p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    protected void method_47399(class_6382 p_259858_) {
    }
}

