/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.player.tabs.InventoryTabFactions;
import noppes.npcs.client.gui.player.tabs.InventoryTabQuests;
import noppes.npcs.client.gui.player.tabs.InventoryTabVanilla;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.shared.client.gui.components.GuiButtonNextPage;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiFaction
extends GuiNPCInterface {
    private ArrayList<Faction> playerFactions = new ArrayList();
    private PlayerFactionData data;
    private int page = 0;
    private int pages = 1;
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private class_2960 indicator;

    public GuiFaction() {
        this.imageWidth = 200;
        this.imageHeight = 195;
        this.drawDefaultBackground = false;
        this.title = "";
        this.indicator = this.getResource("standardbg.png");
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.data = PlayerData.get((class_1657)this.player).factionData;
        this.playerFactions = new ArrayList();
        for (int id : this.data.factionData.keySet()) {
            Faction faction = FactionController.instance.getFaction(id);
            if (faction == null || faction.hideFaction) continue;
            this.playerFactions.add(faction);
        }
        this.pages = (this.playerFactions.size() - 1) / 5;
        ++this.pages;
        this.page = 1;
        this.guiLeft = (this.field_22789 - this.imageWidth) / 2;
        this.guiTop += 12;
        this.method_37063((class_364)new InventoryTabVanilla().init(this));
        this.method_37063((class_364)new InventoryTabFactions().init(this));
        this.method_37063((class_364)new InventoryTabQuests().init(this));
        this.buttonNextPage = new GuiButtonNextPage((IGuiInterface)this, 1, this.guiLeft + this.imageWidth - 43, this.guiTop + 180, true, button -> {
            ++this.page;
            this.updateButtons();
        });
        this.addButton(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonNextPage((IGuiInterface)this, 2, this.guiLeft + 20, this.guiTop + 180, false, button -> {
            --this.page;
            this.updateButtons();
        });
        this.addButton(this.buttonPreviousPage);
        this.updateButtons();
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.indicator);
        graphics.method_25302(this.indicator, this.guiLeft, this.guiTop + 8, 0, 0, this.imageWidth, this.imageHeight);
        graphics.method_25302(this.indicator, this.guiLeft + 4, this.guiTop + 8, 56, 0, 200, this.imageHeight);
        if (this.playerFactions.isEmpty()) {
            class_5250 noFaction = class_2561.method_43471((String)"faction.nostanding");
            class_327 font = class_310.method_1551().field_1772;
            graphics.method_27535(font, (class_2561)noFaction, this.guiLeft + (this.imageWidth - font.method_27525((class_5348)noFaction)) / 2, this.guiTop + 80, CustomNpcResourceListener.DefaultTextColor);
        } else {
            this.renderScreen(graphics);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderScreen(class_332 graphics) {
        int size = 5;
        if (this.playerFactions.size() % 5 != 0 && this.page == this.pages) {
            size = this.playerFactions.size() % 5;
        }
        for (int id = 0; id < size; ++id) {
            graphics.method_25292(this.guiLeft + 2, this.guiLeft + this.imageWidth, this.guiTop + 14 + id * 30, -16777216 + CustomNpcResourceListener.DefaultTextColor);
            Faction faction = this.playerFactions.get((this.page - 1) * 5 + id);
            class_5250 name = class_2561.method_43471((String)faction.name);
            int current = this.data.factionData.get(faction.id);
            String points = " : " + current;
            class_5250 standing = class_2561.method_43471((String)"faction.friendly");
            int color = 65280;
            if (current < faction.neutralPoints) {
                standing = class_2561.method_43471((String)"faction.unfriendly");
                color = 0xFF0000;
                points = points + "/" + faction.neutralPoints;
            } else if (current < faction.friendlyPoints) {
                standing = class_2561.method_43471((String)"faction.neutral");
                color = 0xF2FF00;
                points = points + "/" + faction.friendlyPoints;
            } else {
                points = points + "/-";
            }
            graphics.method_27535(this.field_22793, (class_2561)name, this.guiLeft + (this.imageWidth - this.field_22793.method_27525((class_5348)name)) / 2, this.guiTop + 19 + id * 30, faction.color);
            graphics.method_27535(this.field_22793, (class_2561)standing, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)standing) - 1, this.guiTop + 33 + id * 30, color);
            graphics.method_25303(this.field_22793, points, this.field_22789 / 2, this.guiTop + 33 + id * 30, CustomNpcResourceListener.DefaultTextColor);
        }
        graphics.method_25292(this.guiLeft + 2, this.guiLeft + this.imageWidth, this.guiTop + 14 + size * 30, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        if (this.pages > 1) {
            String s = this.page + "/" + this.pages;
            graphics.method_25303(this.field_22793, s, this.guiLeft + (this.imageWidth - this.field_22793.method_1727(s)) / 2, this.guiTop + 203, CustomNpcResourceListener.DefaultTextColor);
        }
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        if (!(guibutton instanceof GuiButtonNextPage)) {
            return;
        }
        int id = guibutton.id;
        if (id == 1) {
            ++this.page;
        }
        if (id == 2) {
            --this.page;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_22764 = this.page < this.pages;
        this.buttonPreviousPage.field_22764 = this.page > 1;
    }

    @Override
    public void save() {
    }
}

