/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketBankUnlock;
import noppes.npcs.packets.server.SPacketBankUpgrade;
import noppes.npcs.packets.server.SPacketBanksSlotOpen;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.listeners.IGuiData;

public class GuiNPCBankChest
extends GuiContainerNPCInterface<ContainerNPCBankInterface>
implements IGuiData {
    private final class_2960 resource = new class_2960("customnpcs", "textures/gui/bankchest.png");
    private ContainerNPCBankInterface container;
    private int availableSlots = 0;
    private int maxSlots = 1;
    private int unlockedSlots = 1;
    private class_1799 currency;

    public GuiNPCBankChest(ContainerNPCBankInterface container, class_1661 inv, class_2561 titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.container = container;
        this.title = "";
        this.field_2779 = 235;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.availableSlots = 0;
        if (this.maxSlots > 1) {
            for (int i = 0; i < this.maxSlots; ++i) {
                GuiButtonNop button = new GuiButtonNop(this, i, this.guiLeft - 50, this.guiTop + 10 + i * 24, 50, 20, class_1074.method_4662((String)"gui.tab", (Object[])new Object[0]) + " " + (i + 1));
                if (i > this.unlockedSlots) {
                    button.setEnabled(false);
                }
                this.addButton(button);
                ++this.availableSlots;
            }
            if (this.availableSlots == 1) {
                this.field_33816.clear();
            }
        }
        if (!this.container.isAvailable()) {
            this.addButton(new GuiButtonNop(this, 8, this.guiLeft + 48, this.guiTop + 48, 80, 20, class_1074.method_4662((String)"bank.unlock", (Object[])new Object[0])));
        } else if (this.container.canBeUpgraded()) {
            this.addButton(new GuiButtonNop(this, 9, this.guiLeft + 48, this.guiTop + 48, 80, 20, class_1074.method_4662((String)"bank.upgrade", (Object[])new Object[0])));
        }
        if (this.maxSlots > 1) {
            this.getButton((int)this.container.slot).field_22764 = false;
            this.getButton(this.container.slot).setEnabled(false);
        }
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        int id = guibutton.id;
        if (id < 6) {
            Packets.sendServer(new SPacketBanksSlotOpen(id, this.container.bankid));
        }
        if (id == 8) {
            Packets.sendServer(new SPacketBankUnlock());
        }
        if (id == 9) {
            Packets.sendServer(new SPacketBankUpgrade());
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        super.method_2389(graphics, partialTicks, x, y);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resource);
        int l = (this.field_22789 - this.field_2792) / 2;
        int i1 = (this.field_22790 - this.field_2779) / 2;
        graphics.method_25302(this.resource, l, i1, 0, 0, this.field_2792, 6);
        if (!this.container.isAvailable()) {
            graphics.method_25302(this.resource, l, i1 + 6, 0, 6, this.field_2792, 64);
            graphics.method_25302(this.resource, l, i1 + 70, 0, 124, this.field_2792, 98);
            i = this.guiLeft + 30;
            j = this.guiTop + 8;
            graphics.method_25303(this.field_22793, class_1074.method_4662((String)"bank.unlockCosts", (Object[])new Object[0]) + ":", i, j + 4, CustomNpcResourceListener.DefaultTextColor);
            this.drawItem(graphics, i + 90, j, this.currency, x, y);
        } else if (this.container.isUpgraded()) {
            graphics.method_25302(this.resource, l, i1 + 60, 0, 60, this.field_2792, 162);
            graphics.method_25302(this.resource, l, i1 + 6, 0, 60, this.field_2792, 64);
        } else if (this.container.canBeUpgraded()) {
            graphics.method_25302(this.resource, l, i1 + 6, 0, 6, this.field_2792, 216);
            i = this.guiLeft + 30;
            j = this.guiTop + 8;
            graphics.method_25303(this.field_22793, class_1074.method_4662((String)"bank.upgradeCosts", (Object[])new Object[0]) + ":", i, j + 4, CustomNpcResourceListener.DefaultTextColor);
            this.drawItem(graphics, i + 90, j, this.currency, x, y);
        } else {
            graphics.method_25302(this.resource, l, i1 + 6, 0, 60, this.field_2792, 162);
        }
        if (this.maxSlots > 1) {
            for (int ii = 0; ii < this.maxSlots && this.availableSlots != ii; ++ii) {
                graphics.method_25303(this.field_22793, "Tab " + (ii + 1), this.guiLeft - 40, this.guiTop + 16 + ii * 24, 0xFFFFFF);
            }
        }
    }

    private void drawItem(class_332 graphics, int x, int y, class_1799 item, int mouseX, int mouseY) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return;
        }
        graphics.method_51427(item, x, y);
        graphics.method_51431(this.field_22793, item, x, y);
        if (this.method_2378(x - this.guiLeft, y - this.guiTop, 16, 16, mouseX, mouseY)) {
            graphics.method_51446(this.field_22793, item, mouseX, mouseY);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(class_2487 compound) {
        this.maxSlots = compound.method_10550("MaxSlots");
        this.unlockedSlots = compound.method_10550("UnlockedSlots");
        this.currency = compound.method_10545("Currency") ? class_1799.method_7915((class_2487)compound.method_10562("Currency")) : class_1799.field_8037;
        if (this.container.currency != null) {
            this.container.currency.item = this.currency;
        }
        this.method_25426();
    }
}

