/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.gui.player.tabs.InventoryTabFactions;
import noppes.npcs.client.gui.player.tabs.InventoryTabQuests;
import noppes.npcs.client.gui.player.tabs.InventoryTabVanilla;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.shared.client.gui.components.GuiButtonNextPage;
import noppes.npcs.shared.client.gui.components.GuiCustomScrollNop;
import noppes.npcs.shared.client.gui.components.GuiMenuSideButton;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;
import noppes.npcs.shared.client.gui.listeners.ITopButtonListener;
import noppes.npcs.shared.common.util.NaturalOrderComparator;

public class GuiQuestLog
extends GuiNPCInterface
implements ITopButtonListener,
ICustomScrollListener {
    private final class_2960 resource = new class_2960("customnpcs", "textures/gui/standardbg.png");
    public HashMap<String, List<Quest>> activeQuests = new HashMap();
    private HashMap<String, Quest> categoryQuests = new HashMap();
    public Quest selectedQuest = null;
    public class_2561 selectedCategory = class_2561.method_43473();
    private class_1657 player;
    private GuiCustomScrollNop scroll;
    private HashMap<Integer, GuiMenuSideButton> sideButtons = new HashMap();
    private boolean noQuests = false;
    private final int maxLines = 10;
    private int currentPage = 0;
    private int maxPages = 1;
    TextBlockClient textblock = null;
    private class_310 mc = class_310.method_1551();

    public GuiQuestLog(class_1657 player) {
        this.player = player;
        this.imageWidth = 280;
        this.imageHeight = 180;
        this.drawDefaultBackground = false;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        for (Quest quest : PlayerQuestController.getActiveQuests(this.player)) {
            String category = quest.category.title;
            if (!this.activeQuests.containsKey(category)) {
                this.activeQuests.put(category, new ArrayList());
            }
            List<Quest> list = this.activeQuests.get(category);
            list.add(quest);
        }
        this.sideButtons.clear();
        this.guiTop += 10;
        this.method_37063((class_364)new InventoryTabVanilla().init(this));
        this.method_37063((class_364)new InventoryTabFactions().init(this));
        this.method_37063((class_364)new InventoryTabQuests().init(this));
        this.noQuests = false;
        if (this.activeQuests.isEmpty()) {
            this.noQuests = true;
            return;
        }
        ArrayList<String> categories = new ArrayList<String>();
        categories.addAll(this.activeQuests.keySet());
        Collections.sort(categories, new NaturalOrderComparator());
        int i = 0;
        for (String category : categories) {
            if (Objects.equals(this.selectedCategory, class_2561.method_43473())) {
                this.selectedCategory = class_2561.method_43471((String)category);
            }
            this.sideButtons.put(i, new GuiMenuSideButton(this, i, this.guiLeft - 69, this.guiTop + 2 + i * 21, 70, 22, category));
            ++i;
        }
        this.sideButtons.get((Object)Integer.valueOf((int)categories.indexOf((Object)this.selectedCategory.getString()))).active = true;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScrollNop(this, 0);
        }
        HashMap<String, Quest> categoryQuests = new HashMap<String, Quest>();
        for (Quest q : this.activeQuests.get(this.selectedCategory.getString())) {
            categoryQuests.put(q.title, q);
        }
        this.categoryQuests = categoryQuests;
        this.scroll.setList(new ArrayList<String>(categoryQuests.keySet()));
        this.scroll.setSize(134, 174);
        this.scroll.guiLeft = this.guiLeft + 5;
        this.scroll.guiTop = this.guiTop + 15;
        this.addScroll(this.scroll);
        this.addButton(new GuiButtonNextPage((IGuiInterface)this, 1, this.guiLeft + 286, this.guiTop + 114, true, b -> {
            ++this.currentPage;
            this.method_25426();
        }));
        this.addButton(new GuiButtonNextPage((IGuiInterface)this, 2, this.guiLeft + 144, this.guiTop + 114, false, b -> {
            --this.currentPage;
            this.method_25426();
        }));
        this.getButton((int)1).field_22764 = this.selectedQuest != null && this.currentPage < this.maxPages - 1;
        this.getButton((int)2).field_22764 = this.selectedQuest != null && this.currentPage > 0;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.scroll != null) {
            this.scroll.visible = !this.noQuests;
        }
        class_4587 matrixStack = graphics.method_51448();
        this.method_25420(graphics);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.resource);
        graphics.method_25302(this.resource, this.guiLeft, this.guiTop, 0, 0, 252, 195);
        graphics.method_25302(this.resource, this.guiLeft + 252, this.guiTop, 188, 0, 67, 195);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.noQuests) {
            graphics.method_51439(this.mc.field_1772, (class_2561)class_2561.method_43471((String)"quest.noquests"), this.guiLeft + 84, this.guiTop + 80, CustomNpcResourceListener.DefaultTextColor, false);
            return;
        }
        for (GuiMenuSideButton button : this.sideButtons.values().toArray(new GuiMenuSideButton[this.sideButtons.size()])) {
            button.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.method_51439(this.mc.field_1772, this.selectedCategory, this.guiLeft + 5, this.guiTop + 5, CustomNpcResourceListener.DefaultTextColor, false);
        if (this.selectedQuest == null) {
            return;
        }
        this.drawProgress(graphics);
        this.drawQuestText(graphics);
        matrixStack.method_22903();
        matrixStack.method_46416((float)(this.guiLeft + 148), (float)this.guiTop, 0.0f);
        matrixStack.method_22905(1.24f, 1.24f, 1.24f);
        class_5250 title = class_2561.method_43471((String)this.selectedQuest.title);
        graphics.method_51439(this.mc.field_1772, (class_2561)title, (130 - this.field_22793.method_27525((class_5348)title)) / 2, 4, CustomNpcResourceListener.DefaultTextColor, false);
        matrixStack.method_22909();
        graphics.method_25292(this.guiLeft + 142, this.guiLeft + 312, this.guiTop + 17, -16777216 + CustomNpcResourceListener.DefaultTextColor);
    }

    private void drawQuestText(class_332 graphics) {
        if (this.textblock == null) {
            return;
        }
        int yoffset = this.guiTop + 5;
        for (int i = 0; i < 10; ++i) {
            int index = i + this.currentPage * 10;
            if (index >= this.textblock.lines.size()) continue;
            class_2561 text = (class_2561)this.textblock.lines.get(index);
            Objects.requireNonNull(this.field_22793);
            graphics.method_51439(this.field_22793, text, this.guiLeft + 142, this.guiTop + 20 + i * 9, CustomNpcResourceListener.DefaultTextColor, false);
        }
    }

    private void drawProgress(class_332 graphics) {
        class_5250 title = class_2561.method_43471((String)"quest.objectives").method_27693(":");
        graphics.method_51439(this.mc.field_1772, (class_2561)title, this.guiLeft + 142, this.guiTop + 130, CustomNpcResourceListener.DefaultTextColor, false);
        graphics.method_25292(this.guiLeft + 142, this.guiLeft + 312, this.guiTop + 140, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        int yoffset = this.guiTop + 144;
        for (IQuestObjective objective : this.selectedQuest.questInterface.getObjectives(this.player)) {
            graphics.method_51439(this.mc.field_1772, (class_2561)class_2561.method_43470((String)"- ").method_10852(objective.getMCText()), this.guiLeft + 142, yoffset, CustomNpcResourceListener.DefaultTextColor, false);
            yoffset += 10;
        }
        graphics.method_25292(this.guiLeft + 142, this.guiLeft + 312, this.guiTop + 178, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        String complete = this.selectedQuest.getNpcName();
        if (complete != null && !complete.isEmpty()) {
            graphics.method_51439(this.mc.field_1772, (class_2561)class_2561.method_43469((String)"quest.completewith", (Object[])new Object[]{complete}), this.guiLeft + 142, this.guiTop + 182, CustomNpcResourceListener.DefaultTextColor, false);
        }
    }

    @Override
    public boolean method_25402(double i, double j, int k) {
        super.method_25402(i, j, k);
        if (k == 0) {
            if (this.scroll != null) {
                this.scroll.method_25402(i, j, k);
            }
            for (GuiMenuSideButton button : new ArrayList<GuiMenuSideButton>(this.sideButtons.values())) {
                if (!button.method_25402(i, j, k)) continue;
                this.sideButtonPressed(button);
                return true;
            }
        }
        return false;
    }

    private void sideButtonPressed(GuiMenuSideButton button) {
        if (button.active) {
            return;
        }
        NoppesUtil.clickSound();
        this.selectedCategory = button.method_25369();
        this.selectedQuest = null;
        this.method_25426();
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScrollNop scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        this.selectedQuest = this.categoryQuests.get(scroll.getSelected());
        this.textblock = new TextBlockClient(this.selectedQuest.getLogText(), 172, true, this.player);
        if (this.textblock.lines.size() > 10) {
            this.maxPages = class_3532.method_15386((float)(1.0f * (float)this.textblock.lines.size() / 10.0f));
        }
        this.currentPage = 0;
        this.method_25426();
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScrollNop scroll) {
    }
}

