/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.companion;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionStats;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCompanionOpenInv;
import noppes.npcs.packets.server.SPacketCompanionTalentExp;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiLabel;
import noppes.npcs.shared.client.util.NoppesStringUtils;

public class GuiNpcCompanionTalents
extends GuiNPCInterface {
    private RoleCompanion role;
    private Map<Integer, GuiTalent> talents = new HashMap<Integer, GuiTalent>();
    private GuiButtonNop selected;
    private long lastPressedTime = 0L;
    private long startPressedTime = 0L;

    public GuiNpcCompanionTalents(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleCompanion)npc.role;
        this.setBackground("companion_empty.png");
        this.imageWidth = 171;
        this.imageHeight = 166;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.talents = new HashMap<Integer, GuiTalent>();
        int y = this.guiTop + 12;
        this.addLabel(new GuiLabel(0, NoppesStringUtils.translate("quest.exp", ": "), this.guiLeft + 4, this.guiTop + 10));
        GuiNpcCompanionStats.addTopMenu(this.role, this, 2);
        int i = 0;
        for (EnumCompanionTalent e : this.role.talents.keySet()) {
            this.addTalent(i++, e);
        }
    }

    private void addTalent(int i, EnumCompanionTalent talent) {
        int y = this.guiTop + 28 + i / 2 * 26;
        int x = this.guiLeft + 4 + i % 2 * 84;
        GuiTalent gui = new GuiTalent(this.role, talent, x, y);
        gui.method_25423(this.field_22787, this.field_22789, this.field_22790);
        this.talents.put(i, gui);
        if (this.role.getTalentLevel(talent) < 5) {
            this.addButton(new GuiButtonNop(this, i + 10, x + 26, y, 14, 14, "+"));
            y += 8;
        }
        this.addLabel(new GuiLabel(i, String.valueOf(this.role.talents.get((Object)talent)) + "/" + this.role.getNextLevel(talent), x + 26, y + 8));
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        int id = guibutton.id;
        if (id == 1) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.Companion);
        }
        if (id == 3) {
            Packets.sendServer(new SPacketCompanionOpenInv());
        }
        if (id >= 10) {
            this.selected = guibutton;
            this.lastPressedTime = this.startPressedTime = this.field_22787.field_1687.method_8532();
            this.addExperience(1);
        }
    }

    private void addExperience(int exp) {
        EnumCompanionTalent talent = this.talents.get((Object)Integer.valueOf((int)(this.selected.id - 10))).talent;
        if (!this.role.canAddExp(-exp) && this.role.currentExp <= 0) {
            return;
        }
        if (exp > this.role.currentExp) {
            exp = this.role.currentExp;
        }
        Packets.sendServer(new SPacketCompanionTalentExp(talent, exp));
        this.role.talents.put(talent, this.role.talents.get((Object)talent) + exp);
        this.role.addExp(-exp);
        this.getLabel(this.selected.id - 10).method_25355((class_2561)class_2561.method_43470((String)(String.valueOf(this.role.talents.get((Object)talent)) + "/" + this.role.getNextLevel(talent))));
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.selected != null && this.field_22787.field_1687.method_8532() - this.startPressedTime > 4L && this.lastPressedTime < this.field_22787.field_1687.method_8532() && this.field_22787.field_1687.method_8532() % 4L == 0L) {
            if (this.selected.method_25402(mouseX, mouseY, 0)) {
                this.lastPressedTime = this.field_22787.field_1687.method_8532();
                if (this.lastPressedTime - this.startPressedTime < 20L) {
                    this.addExperience(1);
                } else if (this.lastPressedTime - this.startPressedTime < 40L) {
                    this.addExperience(2);
                } else if (this.lastPressedTime - this.startPressedTime < 60L) {
                    this.addExperience(4);
                } else if (this.lastPressedTime - this.startPressedTime < 90L) {
                    this.addExperience(8);
                } else if (this.lastPressedTime - this.startPressedTime < 140L) {
                    this.addExperience(14);
                } else {
                    this.addExperience(28);
                }
            } else {
                this.lastPressedTime = 0L;
                this.selected = null;
            }
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GuiNpcCompanionStats.GUI_ICONS_LOCATION);
        graphics.method_25302(GuiNpcCompanionStats.GUI_ICONS_LOCATION, this.guiLeft + 4, this.guiTop + 20, 10, 64, 162, 5);
        if (this.role.currentExp > 0) {
            float v = 1.0f * (float)this.role.currentExp / (float)this.role.getMaxExp();
            if (v > 1.0f) {
                v = 1.0f;
            }
            graphics.method_25302(GuiNpcCompanionStats.GUI_ICONS_LOCATION, this.guiLeft + 4, this.guiTop + 20, 10, 69, (int)(v * 162.0f), 5);
        }
        String s = this.role.currentExp + "\\" + this.role.getMaxExp();
        graphics.method_25303(this.field_22787.field_1772, s, this.guiLeft + this.imageWidth / 2 - this.field_22787.field_1772.method_1727(s) / 2, this.guiTop + 10, CustomNpcResourceListener.DefaultTextColor);
        for (GuiTalent talent : this.talents.values()) {
            talent.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void save() {
    }

    public static class GuiTalent
    extends class_437 {
        private EnumCompanionTalent talent;
        private int x;
        private int y;
        private RoleCompanion role;
        private static final class_2960 resource = new class_2960("customnpcs:textures/gui/talent.png");

        public GuiTalent(RoleCompanion role, EnumCompanionTalent talent, int x, int y) {
            super((class_2561)class_2561.method_43473());
            this.talent = talent;
            this.x = x;
            this.y = y;
            this.role = role;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            class_310 mc = class_310.method_1551();
            class_4587 matrixStack = graphics.method_51448();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)resource);
            class_1799 item = this.talent.item;
            if (item.method_7909() == null) {
                item = new class_1799((class_1935)class_2246.field_10566);
            }
            matrixStack.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            boolean hover = this.x < mouseX && this.x + 24 > mouseX && this.y < mouseY && this.y + 24 > mouseY;
            graphics.method_25302(resource, this.x, this.y, 0, hover ? 24 : 0, 24, 24);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            graphics.method_51427(item, this.x + 4, this.y + 4);
            graphics.method_51431(mc.field_1772, item, this.x + 4, this.y + 4);
            matrixStack.method_46416(0.0f, 0.0f, 200.0f);
            graphics.method_25300(mc.field_1772, "" + this.role.getTalentLevel(this.talent), this.x + 20, this.y + 16, 0xFFFFFF);
            graphics.method_51448().method_22909();
            matrixStack.method_22909();
        }
    }
}

