/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.parts;

import java.io.File;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import noppes.npcs.client.parts.MpmPart;
import noppes.npcs.client.parts.MpmPartReader;
import noppes.npcs.shared.client.util.ImageDownloadAlt;
import noppes.npcs.shared.client.util.NoppesStringUtils;
import noppes.npcs.shared.client.util.ResourceDownloader;
import noppes.npcs.shared.common.util.NopVector3f;

public class MpmPartData {
    public static final NopVector3f WHITE = new NopVector3f(1.0f, 1.0f, 1.0f);
    public class_2960 partId;
    public boolean usePlayerSkin = false;
    public NopVector3f color = WHITE;
    public class_2960 texture = null;
    private class_2960 textureUrl = null;
    public String url = "";

    public MpmPart getPart() {
        return MpmPartReader.PARTS.get(this.partId);
    }

    public class_2960 getTexture() {
        if (this.getUrlTexture() != null) {
            return this.getUrlTexture();
        }
        if (this.texture != null) {
            return this.texture;
        }
        MpmPart part = this.getPart();
        if (part != null && part.texture != null) {
            return this.getPart().texture;
        }
        return class_1047.method_4539();
    }

    public class_2960 getUrlTexture() {
        if (this.textureUrl != null) {
            return this.textureUrl;
        }
        if (!this.url.isEmpty()) {
            class_2960 resource = ResourceDownloader.getUrlResourceLocation(this.url, false);
            File file = ResourceDownloader.getUrlFile(this.url, false);
            class_1060 texturemanager = class_310.method_1551().method_1531();
            class_1044 object = texturemanager.method_34590(resource, null);
            if (object == null) {
                this.textureUrl = this.getDefaultTexture();
                ResourceDownloader.load(new ImageDownloadAlt(file, this.url, resource, this.getDefaultTexture(), false, () -> {
                    this.textureUrl = resource;
                }));
            } else {
                this.textureUrl = resource;
            }
        }
        return this.textureUrl;
    }

    public void setTexture(String s) {
        this.texture = s == null || s.isEmpty() ? null : new class_2960(s);
    }

    public void setUrl(String url) {
        if (NoppesStringUtils.areEqual(this.url, url)) {
            return;
        }
        this.url = url;
        this.textureUrl = null;
    }

    public class_2960 getDefaultTexture() {
        if (this.texture != null) {
            return this.texture;
        }
        return this.getPart().texture;
    }

    public int getColor() {
        int r = (int)(this.color.x * 255.0f) << 16;
        int g = (int)(this.color.y * 255.0f) << 8;
        int b = (int)(this.color.z * 255.0f);
        return r + g + b;
    }

    public void setColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.color = new NopVector3f(r, g, b);
    }

    public class_2487 getNbt() {
        class_2487 item = new class_2487();
        item.method_10582("Id", this.partId.toString());
        item.method_10556("UsePlayerSkin", this.usePlayerSkin);
        item.method_10582("Url", this.url);
        item.method_10582("Texture", this.texture == null ? "" : this.texture.toString());
        item.method_10548("ColorR", this.color.x);
        item.method_10548("ColorG", this.color.y);
        item.method_10548("ColorB", this.color.z);
        return item;
    }

    public void setNbt(class_2487 compound) {
        this.partId = new class_2960(compound.method_10558("Id"));
        this.usePlayerSkin = compound.method_10577("UsePlayerSkin");
        this.setUrl(compound.method_10558("Url"));
        this.setTexture(compound.method_10558("Texture"));
        this.color = new NopVector3f(compound.method_10583("ColorR"), compound.method_10583("ColorG"), compound.method_10583("ColorB"));
    }
}

