/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_970;
import net.minecraft.class_976;
import net.minecraft.class_989;
import noppes.npcs.ModelData;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.layer.LayerGlow;
import noppes.npcs.client.layer.LayerHeadwear;
import noppes.npcs.client.layer.LayerNpcCloak;
import noppes.npcs.client.layer.LayerParts;
import noppes.npcs.client.layer.LayerPreRender;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.constants.BodyPart;
import noppes.npcs.controllers.CobblemonHelper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.ArmorLayerMixin;
import noppes.npcs.mixin.LivingRenderer2Mixin;
import noppes.npcs.mixin.LivingRenderer3Mixin;

public class RenderCustomNpc<T extends EntityCustomNpc, M extends class_572<T>>
extends RenderNPCInterface<T, M> {
    private float partialTicks;
    private class_1309 entity;
    private EntityNPCInterface npc;
    private class_922 renderEntity;
    public M npcmodel;
    public class_3879 otherModel;
    public ArmorLayerMixin armorLayer;
    public List<class_3887<T, M>> npclayers = Lists.newArrayList();
    private class_3887 renderLayer = new class_3887(null){

        public void method_4199(class_4587 mStack, class_4597 typeBuffer, int lightmapUV, class_1297 p_225628_4_, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
            for (class_3887 layer : ((LivingRenderer2Mixin)RenderCustomNpc.this.renderEntity).layers()) {
                layer.method_4199(mStack, typeBuffer, lightmapUV, (class_1297)RenderCustomNpc.this.entity, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch);
            }
        }
    };
    private final class_572 renderModel;

    public RenderCustomNpc(class_5617.class_5618 manager, M model) {
        super(manager, model, 0.5f);
        this.npcmodel = model;
        this.method_4046((class_3887)new class_976((class_3883)this, manager.method_32170(), manager.method_43338()));
        this.method_4046(new LayerHeadwear(this));
        this.method_4046(new LayerNpcCloak(this));
        this.method_4046(new LayerParts(this));
        this.method_4046((class_3887)new class_989((class_3883)this, manager.method_43338()));
        this.method_4046(new LayerGlow(this));
        class_970 armorLayer = new class_970((class_3883)this, new class_572(manager.method_32167(class_5602.field_27579)), new class_572(manager.method_32167(class_5602.field_27580)), manager.method_48481());
        this.method_4046((class_3887)armorLayer);
        this.armorLayer = (ArmorLayerMixin)armorLayer;
        this.renderModel = new class_572(manager.method_32167(class_5602.field_27577)){

            public void method_2828(class_4587 mStack, class_4588 iVertex, int lightmapUV, int packedOverlayIn, float red, float green, float blue, float alpha) {
                int color = RenderCustomNpc.this.npc.display.getTint();
                if (color < 0xFFFFFF) {
                    red = (float)(color >> 16 & 0xFF) / 255.0f;
                    green = (float)(color >> 8 & 0xFF) / 255.0f;
                    blue = (float)(color & 0xFF) / 255.0f;
                }
                RenderCustomNpc.this.otherModel.method_2828(mStack, iVertex, lightmapUV, packedOverlayIn, red, green, blue, alpha);
            }

            public void method_2819(class_1297 entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                if (RenderCustomNpc.this.otherModel instanceof class_583) {
                    class_583 em = (class_583)RenderCustomNpc.this.otherModel;
                    em.method_2819((class_1297)RenderCustomNpc.this.entity, limbSwing, limbSwingAmount, ((LivingRenderer3Mixin)RenderCustomNpc.this.renderEntity).callGetBob(RenderCustomNpc.this.entity, class_310.method_1551().method_1488()), netHeadYaw, headPitch);
                }
            }

            public void method_2816(class_1297 npc, float animationPos, float animationSpeed, float partialTicks) {
                class_3879 pixModel;
                if (PixelmonHelper.isPixelmon((class_1297)RenderCustomNpc.this.entity) && (pixModel = (class_3879)PixelmonHelper.getModel(RenderCustomNpc.this.entity)) != null) {
                    RenderCustomNpc.this.otherModel = pixModel;
                    PixelmonHelper.setupModel(RenderCustomNpc.this.entity, pixModel);
                }
                if (RenderCustomNpc.this.otherModel instanceof class_572) {
                    class_572 bm = (class_572)RenderCustomNpc.this.otherModel;
                    bm.field_3396 = ((EntityCustomNpc)npc).method_6024(partialTicks);
                    bm.field_3400 = ((class_572)RenderCustomNpc.this.npcmodel).field_3400;
                }
                if (RenderCustomNpc.this.otherModel instanceof class_583) {
                    class_583 em = (class_583)RenderCustomNpc.this.otherModel;
                    em.field_3449 = RenderCustomNpc.this.entity.method_5765() && RenderCustomNpc.this.entity.method_5854() != null;
                    em.field_3448 = RenderCustomNpc.this.entity.method_6109();
                    em.field_3447 = RenderCustomNpc.this.method_4044((class_1309)((EntityCustomNpc)npc), partialTicks);
                    em.method_2816((class_1297)RenderCustomNpc.this.entity, animationPos, animationSpeed, partialTicks);
                }
            }
        };
    }

    public class_243 getRenderOffset(T npc, float partialTicks) {
        float xOffset = 0.0f;
        float yOffset = ((EntityCustomNpc)((Object)npc)).currentAnimation == 0 ? ((EntityCustomNpc)((Object)npc)).ais.bodyOffsetY / 10.0f - 0.5f : 0.0f;
        float zOffset = 0.0f;
        if (((EntityNPCInterface)((Object)npc)).method_5805()) {
            if (((EntityNPCInterface)((Object)npc)).method_6113()) {
                xOffset = (float)(-Math.cos(Math.toRadians(180 - ((EntityCustomNpc)((Object)npc)).ais.orientation)));
                zOffset = (float)(-Math.sin(Math.toRadians(((EntityCustomNpc)((Object)npc)).ais.orientation)));
                yOffset += 0.14f;
            } else if (((EntityCustomNpc)((Object)npc)).currentAnimation == 1 || npc.method_5765()) {
                yOffset -= 0.5f - ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * 0.8f;
            } else if (((EntityNPCInterface)((Object)npc)).method_18276()) {
                yOffset = (float)((double)yOffset - 0.125);
            }
        }
        return new class_243((double)xOffset, (double)(yOffset * ((float)((EntityCustomNpc)((Object)npc)).display.getSize() / 5.0f)), (double)zOffset);
    }

    void hideParts() {
        if (this.npc instanceof EntityCustomNpc) {
            ModelData data = ModelData.get((EntityCustomNpc)this.npc);
            ((class_572)this.npcmodel).field_3397.field_3665 = !data.hiddenParts.contains((Object)BodyPart.LEFT_LEG);
            ((class_572)this.npcmodel).field_3392.field_3665 = !data.hiddenParts.contains((Object)BodyPart.RIGHT_LEG);
            ((class_572)this.npcmodel).field_27433.field_3665 = !data.hiddenParts.contains((Object)BodyPart.LEFT_ARM);
            ((class_572)this.npcmodel).field_3401.field_3665 = !data.hiddenParts.contains((Object)BodyPart.RIGHT_ARM);
            ((class_572)this.npcmodel).field_3391.field_3665 = !data.hiddenParts.contains((Object)BodyPart.BODY);
            ((class_572)this.npcmodel).field_3398.field_3665 = !data.hiddenParts.contains((Object)BodyPart.HEAD);
            boolean bl = ((class_572)this.npcmodel).field_3394.field_3665 = !data.hiddenParts.contains((Object)BodyPart.HEAD);
            if (this.npcmodel instanceof class_591) {
                class_591 playerModel = (class_591)this.npcmodel;
                playerModel.field_3483.field_3665 = !data.hiddenParts.contains((Object)BodyPart.BODY);
                playerModel.field_3484.field_3665 = !data.hiddenParts.contains((Object)BodyPart.LEFT_ARM);
                playerModel.field_3486.field_3665 = !data.hiddenParts.contains((Object)BodyPart.RIGHT_ARM);
                playerModel.field_3482.field_3665 = !data.hiddenParts.contains((Object)BodyPart.LEFT_LEG);
                playerModel.field_3479.field_3665 = !data.hiddenParts.contains((Object)BodyPart.RIGHT_LEG);
            }
        }
    }

    @Override
    public void render(T npc, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        this.npc = npc;
        this.partialTicks = partialTicks;
        class_1309 prevEntity = this.entity;
        this.entity = ((EntityCustomNpc)((Object)npc)).modelData.getEntity((EntityNPCInterface)((Object)npc));
        if (prevEntity != null && this.entity == null) {
            this.field_4737 = this.npcmodel;
            this.renderEntity = null;
            this.field_4738.clear();
            this.field_4738.addAll(this.npclayers);
        }
        if (this.entity != null) {
            class_897 render = this.field_4676.method_3953((class_1297)this.entity);
            if (((EntityCustomNpc)((Object)npc)).modelData.simpleRender) {
                this.renderEntity = null;
                matrixStack.method_22903();
                render.method_3936((class_1297)this.entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
                this.renderNameTag(npc, (class_2561)class_2561.method_43473(), matrixStack, buffer, packedLight);
                matrixStack.method_22909();
                return;
            }
            if (render instanceof class_922) {
                this.renderEntity = (class_922)render;
                this.otherModel = this.renderEntity.method_4038();
                if (CobblemonHelper.Enabled && CobblemonHelper.isPokemon((class_1297)this.entity)) {
                    this.otherModel = CobblemonHelper.getPokemonModel((class_1297)this.entity);
                }
                this.field_4737 = this.renderModel;
                this.field_4738.clear();
                this.field_4738.add(this.renderLayer);
                this.field_4738.add(new LayerGlow(this));
                if (render instanceof RenderCustomNpc) {
                    for (class_3887 layer : ((LivingRenderer2Mixin)this.renderEntity).layers()) {
                        if (!(layer instanceof LayerPreRender)) continue;
                        ((LayerPreRender)layer).preRender((EntityCustomNpc)this.entity);
                    }
                }
            } else {
                this.renderEntity = null;
                this.entity = null;
                this.field_4737 = this.npcmodel;
                this.field_4738.clear();
                this.field_4738.addAll(this.npclayers);
            }
        } else {
            this.hideParts();
            List list = this.field_4738;
            for (class_3887 layer : list) {
                if (!(layer instanceof LayerPreRender)) continue;
                ((LayerPreRender)layer).preRender((EntityCustomNpc)((Object)npc));
            }
        }
        ((class_572)this.npcmodel).field_3395 = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).method_6047());
        ((class_572)this.npcmodel).field_3399 = this.getPose(npc, ((EntityNPCInterface)((Object)npc)).method_6079());
        super.render(npc, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected class_1921 getRenderType(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        class_2960 resourcelocation = this.getTextureLocation(p_230496_1_);
        if (p_230496_2_ && this.field_4737 == this.renderModel) {
            return this.otherModel.method_23500(resourcelocation);
        }
        if (this.entity == null) {
            return ((class_572)this.field_4737).method_23500(resourcelocation);
        }
        return super.method_24302(p_230496_1_, p_230496_2_, p_230496_3_, p_230496_4_);
    }

    public class_572.class_573 getPose(T npc, class_1799 item) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return class_572.class_573.field_3409;
        }
        if (npc.method_6014() > 0) {
            class_1839 enumaction = item.method_7976();
            if (enumaction == class_1839.field_8949) {
                return class_572.class_573.field_3406;
            }
            if (enumaction == class_1839.field_8953) {
                return class_572.class_573.field_3403;
            }
        }
        return class_572.class_573.field_3410;
    }

    @Override
    protected void scale(T npc, class_4587 matrixScale, float f) {
        if (this.renderEntity != null) {
            this.renderColor((EntityNPCInterface)((Object)npc));
            int size = ((EntityCustomNpc)((Object)npc)).display.getSize();
            if (this.entity instanceof EntityNPCInterface) {
                ((EntityNPCInterface)this.entity).display.setSize(5);
            }
            class_897 render = this.field_4676.method_3953((class_1297)this.entity);
            if (!((EntityCustomNpc)((Object)npc)).modelData.simpleRender && render instanceof class_922) {
                ((LivingRenderer3Mixin)render).callScale(this.entity, matrixScale, this.partialTicks);
            }
            ((EntityCustomNpc)((Object)npc)).display.setSize(size);
            matrixScale.method_22905(0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize(), 0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize(), 0.2f * (float)((EntityCustomNpc)((Object)npc)).display.getSize());
        } else {
            super.scale(npc, matrixScale, f);
        }
    }
}

