/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.MatrixStackMixin;
import noppes.npcs.shared.client.util.ImageDownloadAlt;
import noppes.npcs.shared.client.util.ResourceDownloader;
import noppes.npcs.shared.common.util.LogWriter;
import org.joml.Matrix4f;

public class RenderNPCInterface<T extends EntityNPCInterface, M extends class_583<T>>
extends class_922<T, M> {
    public static int LastTextureTick;
    public static EntityNPCInterface currentNpc;

    public RenderNPCInterface(class_5617.class_5618 manager, M model, float f) {
        super(manager, model, f);
    }

    public void renderNameTag(T npc, class_2561 text, class_4587 matrixStack, class_4597 buffer, int light) {
        if (npc == null || !this.method_4055((class_1309)npc) || this.field_4676 == null) {
            return;
        }
        double d0 = this.field_4676.method_23168(npc);
        if (d0 > 512.0) {
            return;
        }
        matrixStack.method_22903();
        class_243 renderOffset = this.method_23169((class_1297)npc, 0.0f);
        matrixStack.method_22904(-renderOffset.method_10216(), -renderOffset.method_10214(), -renderOffset.method_10215());
        if (((EntityNPCInterface)((Object)npc)).messages != null) {
            float height = ((EntityNPCInterface)((Object)npc)).baseSize.field_18068 / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
            float offset = npc.method_17682() * (1.2f + (!((EntityNPCInterface)((Object)npc)).display.showName() ? 0.0f : (((EntityNPCInterface)((Object)npc)).display.getTitle().isEmpty() ? 0.15f : 0.25f)));
            matrixStack.method_46416(0.0f, offset, 0.0f);
            ((EntityNPCInterface)((Object)npc)).messages.renderMessages(matrixStack, buffer, 0.666667f * height, ((EntityNPCInterface)((Object)npc)).isInRange(this.field_4676.field_4686.method_19331(), 4.0), light);
            matrixStack.method_46416(0.0f, -offset, 0.0f);
        }
        if (((EntityNPCInterface)((Object)npc)).display.showName()) {
            this.renderLivingLabel(npc, matrixStack, buffer, light);
        }
        matrixStack.method_22909();
    }

    protected void renderLivingLabel(T npc, class_4587 matrixStack, class_4597 buffer, int light) {
        float scale = ((EntityNPCInterface)((Object)npc)).baseSize.field_18068 / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        float height = npc.method_17682() - 0.06f * scale;
        matrixStack.method_22903();
        class_327 fontrenderer = this.method_3932();
        float f2 = 0.01666667f * scale;
        matrixStack.method_46416(0.0f, height, 0.0f);
        matrixStack.method_22907(this.field_4676.method_24197());
        int color = ((EntityNPCInterface)((Object)npc)).getFaction().color;
        matrixStack.method_46416(0.0f, scale / 6.5f * 2.0f, 0.0f);
        float f1 = class_310.method_1551().field_1690.method_19343(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        matrixStack.method_22905(-f2, -f2, f2);
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        float y = 0.0f;
        boolean nearby = ((EntityNPCInterface)((Object)npc)).isInRange(this.field_4676.field_4686.method_19331(), 8.0);
        if (!((EntityNPCInterface)((Object)npc)).display.getTitle().isEmpty() && nearby) {
            class_5250 title = class_2561.method_43470((String)"<").method_10852((class_2561)class_2561.method_43471((String)((EntityNPCInterface)((Object)npc)).display.getTitle())).method_27693(">");
            float f3 = 0.6f;
            matrixStack.method_46416(0.0f, 4.0f, 0.0f);
            matrixStack.method_22905(f3, f3, f3);
            fontrenderer.method_30882((class_2561)title, (float)(-fontrenderer.method_27525((class_5348)title) / 2), 0.0f, color, false, matrix4f, buffer, class_327.class_6415.field_33993, j, light);
            matrixStack.method_22905(1.0f / f3, 1.0f / f3, 1.0f / f3);
            y = -10.0f;
        }
        class_2561 name = ((EntityNPCInterface)((Object)npc)).method_5477();
        fontrenderer.method_30882(name, (float)(-fontrenderer.method_27525((class_5348)name) / 2), y, color, false, matrix4f, buffer, nearby ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, j, light);
        if (nearby) {
            fontrenderer.method_30882(name, (float)(-fontrenderer.method_27525((class_5348)name) / 2), y, color, false, matrix4f, buffer, class_327.class_6415.field_33993, 0, light);
        }
        matrixStack.method_22909();
    }

    protected void renderColor(EntityNPCInterface npc) {
        if (npc.field_6235 <= 0 && npc.field_6213 <= 0) {
            float red = (float)(npc.display.getTint() >> 16 & 0xFF) / 255.0f;
            float green = (float)(npc.display.getTint() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(npc.display.getTint() & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        }
    }

    protected void setupRotations(T npc, class_4587 matrixScale, float f, float f1, float f2) {
        if (((EntityNPCInterface)((Object)npc)).method_5805() && ((EntityNPCInterface)((Object)npc)).method_6113()) {
            matrixScale.method_22907(class_7833.field_40716.rotationDegrees((float)((EntityNPCInterface)((Object)npc)).ais.orientation));
            matrixScale.method_22907(class_7833.field_40718.rotationDegrees(this.method_4039((class_1309)npc)));
            matrixScale.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
        } else if (((EntityNPCInterface)((Object)npc)).method_5805() && ((EntityNPCInterface)((Object)npc)).currentAnimation == 7) {
            matrixScale.method_22907(class_7833.field_40716.rotationDegrees(270.0f - f1));
            float scale = (float)((EntityCustomNpc)((Object)npc)).display.getSize() / 5.0f;
            matrixScale.method_46416(-scale + ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * scale, 0.14f, 0.0f);
            matrixScale.method_22907(class_7833.field_40718.rotationDegrees(270.0f));
            matrixScale.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
        } else {
            super.method_4058(npc, matrixScale, f, f1, f2);
        }
    }

    protected void scale(T npc, class_4587 matrixScale, float f) {
        this.renderColor((EntityNPCInterface)((Object)npc));
        int size = ((EntityNPCInterface)((Object)npc)).display.getSize();
        matrixScale.method_22905(((EntityNPCInterface)((Object)npc)).scaleX / 5.0f * (float)size, ((EntityNPCInterface)((Object)npc)).scaleY / 5.0f * (float)size, ((EntityNPCInterface)((Object)npc)).scaleZ / 5.0f * (float)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(T npc, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        if (((EntityNPCInterface)((Object)npc)).isKilled()) {
            this.field_4673 = 0.0f;
        }
        if (((EntityNPCInterface)((Object)npc)).isKilled() && ((EntityNPCInterface)((Object)npc)).stats.hideKilledBody && ((EntityNPCInterface)((Object)npc)).field_6213 > 20) {
            return;
        }
        float xOffset = 0.0f;
        float yOffset = ((EntityNPCInterface)((Object)npc)).currentAnimation == 0 ? ((EntityNPCInterface)((Object)npc)).ais.bodyOffsetY / 10.0f - 0.5f : 0.0f;
        float zOffset = 0.0f;
        if (((EntityNPCInterface)((Object)npc)).method_5805()) {
            if (((EntityNPCInterface)((Object)npc)).method_6113()) {
                xOffset = (float)(-Math.cos(Math.toRadians(180 - ((EntityNPCInterface)((Object)npc)).ais.orientation)));
                zOffset = (float)(-Math.sin(Math.toRadians(((EntityNPCInterface)((Object)npc)).ais.orientation)));
                yOffset += 0.14f;
            } else if (((EntityNPCInterface)((Object)npc)).currentAnimation == 1 || npc.method_5765()) {
                yOffset -= 0.5f - ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * 0.8f;
            }
        }
        xOffset = xOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        yOffset = yOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        zOffset = zOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        if (((EntityNPCInterface)((Object)npc)).display.getBossbar() != 1 && (((EntityNPCInterface)((Object)npc)).display.getBossbar() != 2 || !((EntityNPCInterface)((Object)npc)).isAttacking()) || ((EntityNPCInterface)((Object)npc)).isKilled() || ((EntityNPCInterface)((Object)npc)).field_6213 > 20 || ((EntityNPCInterface)((Object)npc)).canNpcSee((class_1297)class_310.method_1551().field_1724)) {
            // empty if block
        }
        if (((EntityNPCInterface)((Object)npc)).ais.getStandingType() == 3 && !((EntityNPCInterface)((Object)npc)).isWalking() && !((EntityNPCInterface)((Object)npc)).isInteracting()) {
            ((EntityNPCInterface)((Object)npc)).field_6220 = ((EntityNPCInterface)((Object)npc)).field_6283 = (float)((EntityNPCInterface)((Object)npc)).ais.orientation;
        }
        this.field_4673 = npc.method_17681() * 0.8f;
        int stackSize = ((MatrixStackMixin)matrixStack).getStack().size();
        try {
            currentNpc = npc;
            super.method_4054(npc, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }
        catch (Throwable e) {
            while (((MatrixStackMixin)matrixStack).getStack().size() > stackSize) {
                matrixStack.method_22909();
            }
            LogWriter.except(e);
        }
        finally {
            currentNpc = null;
        }
    }

    protected float getBob(T npc, float limbSwingAmount) {
        if (((EntityNPCInterface)((Object)npc)).isKilled() || !((EntityNPCInterface)((Object)npc)).display.getHasLivingAnimation()) {
            return 0.0f;
        }
        return super.method_4045(npc, limbSwingAmount);
    }

    public class_2960 getTextureLocation(T npc) {
        if (((EntityNPCInterface)((Object)npc)).textureLocation == null) {
            if (((EntityNPCInterface)((Object)npc)).display.skinType == 0) {
                ((EntityNPCInterface)((Object)npc)).textureLocation = new class_2960(((EntityNPCInterface)((Object)npc)).display.getSkinTexture());
            } else {
                if (LastTextureTick < 5) {
                    return class_1068.method_4649();
                }
                if (((EntityNPCInterface)((Object)npc)).display.skinType == 1 && ((EntityNPCInterface)((Object)npc)).display.playerProfile != null) {
                    class_310 minecraft = class_310.method_1551();
                    Map map = minecraft.method_1582().method_4654(((EntityNPCInterface)((Object)npc)).display.playerProfile);
                    ((EntityNPCInterface)((Object)npc)).textureLocation = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : class_1068.method_4648((UUID)class_4844.method_43343((GameProfile)((EntityNPCInterface)((Object)npc)).display.playerProfile));
                } else if (((EntityNPCInterface)((Object)npc)).display.skinType == 2 && !((EntityNPCInterface)((Object)npc)).display.getSkinUrl().isEmpty()) {
                    try {
                        boolean fixSkin = npc instanceof EntityCustomNpc && ((EntityCustomNpc)((Object)npc)).modelData.getEntity((EntityNPCInterface)((Object)npc)) == null;
                        File file = ResourceDownloader.getUrlFile(((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), fixSkin);
                        ((EntityNPCInterface)((Object)npc)).textureLocation = ResourceDownloader.getUrlResourceLocation(((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), fixSkin);
                        this.loadSkin(file, ((EntityNPCInterface)((Object)npc)).textureLocation, ((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), fixSkin);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (((EntityNPCInterface)((Object)npc)).textureLocation == null) {
            return class_1068.method_4649();
        }
        return ((EntityNPCInterface)((Object)npc)).textureLocation;
    }

    private void loadSkin(File file, class_2960 resource, String par1Str, boolean fix64) {
        class_1060 texturemanager = class_310.method_1551().method_1531();
        class_1044 object = texturemanager.method_34590(resource, null);
        if (object == null) {
            ResourceDownloader.load(new ImageDownloadAlt(file, par1Str, resource, class_1068.method_4649(), fix64, () -> {}));
        }
    }
}

