/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_8566;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.handler.data.IRecipe;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.controllers.data.RecipesDefault;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketSyncRecipeRemove;
import noppes.npcs.packets.client.PacketSyncRecipeUpdate;

public class RecipeController
implements IRecipeHandler {
    public HashMap<class_2960, RecipeCarpentry> globalRecipes = new HashMap();
    public HashMap<class_2960, RecipeCarpentry> anvilRecipes = new HashMap();
    public static RecipeController instance;
    public static final int version = 1;
    public int nextId = 1;
    public static HashMap<class_2960, RecipeCarpentry> syncRecipes;

    public RecipeController() {
        instance = this;
    }

    public void load() {
        this.loadCategories();
        this.reloadGlobalRecipes();
        EventHooks.onGlobalRecipesLoaded(this);
    }

    public void reloadGlobalRecipes() {
    }

    private void loadCategories() {
        File saveDir = CustomNpcs.getLevelSaveDirectory();
        try {
            File file = new File(saveDir, "recipes.dat");
            if (file.exists()) {
                this.loadCategories(file);
            } else {
                this.globalRecipes.clear();
                this.anvilRecipes.clear();
                this.loadDefaultRecipes(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                File file = new File(saveDir, "recipes.dat_old");
                if (file.exists()) {
                    this.loadCategories(file);
                }
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
        }
    }

    private void loadDefaultRecipes(int i) {
        if (i == 1) {
            return;
        }
        RecipesDefault.loadDefaultRecipes(i);
        this.saveCategories();
    }

    private void loadCategories(File file) throws Exception {
        class_2487 nbttagcompound1 = class_2507.method_10629((InputStream)new FileInputStream(file));
        this.nextId = nbttagcompound1.method_10550("LastId");
        class_2499 list = nbttagcompound1.method_10554("Data", 10);
        HashMap<class_2960, RecipeCarpentry> globalRecipes = new HashMap<class_2960, RecipeCarpentry>();
        HashMap<class_2960, RecipeCarpentry> anvilRecipes = new HashMap<class_2960, RecipeCarpentry>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                RecipeCarpentry recipe = RecipeCarpentry.load(list.method_10602(i));
                if (recipe.isGlobal) {
                    globalRecipes.put(recipe.method_8114(), recipe);
                    continue;
                }
                anvilRecipes.put(recipe.method_8114(), recipe);
            }
        }
        this.anvilRecipes = anvilRecipes;
        this.globalRecipes = globalRecipes;
        this.loadDefaultRecipes(nbttagcompound1.method_10550("Version"));
    }

    private void saveCategories() {
        try {
            File saveDir = CustomNpcs.getLevelSaveDirectory();
            class_2499 list = new class_2499();
            for (RecipeCarpentry recipe : this.globalRecipes.values()) {
                if (!recipe.savesRecipe) continue;
                list.add((Object)recipe.writeNBT());
            }
            for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
                if (!recipe.savesRecipe) continue;
                list.add((Object)recipe.writeNBT());
            }
            class_2487 nbttagcompound = new class_2487();
            nbttagcompound.method_10566("Data", (class_2520)list);
            nbttagcompound.method_10569("LastId", this.nextId);
            nbttagcompound.method_10569("Version", 1);
            File file = new File(saveDir, "recipes.dat_new");
            File file1 = new File(saveDir, "recipes.dat_old");
            File file2 = new File(saveDir, "recipes.dat");
            class_2507.method_10634((class_2487)nbttagcompound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RecipeCarpentry findMatchingRecipe(class_8566 inventoryCrafting) {
        for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
            if (!recipe.isValid() || !recipe.method_17728(inventoryCrafting, null)) continue;
            return recipe;
        }
        return null;
    }

    public RecipeCarpentry getRecipe(class_2960 id) {
        if (this.globalRecipes.containsKey(id)) {
            return this.globalRecipes.get(id);
        }
        if (this.anvilRecipes.containsKey(id)) {
            return this.anvilRecipes.get(id);
        }
        return null;
    }

    public RecipeCarpentry saveRecipe(RecipeCarpentry recipe) {
        RecipeCarpentry current = this.getRecipe(recipe.method_8114());
        if (current != null && !current.name.equals(recipe.name)) {
            while (this.containsRecipeName(recipe.name)) {
                recipe.name = recipe.name + "_";
            }
        }
        if (recipe.isGlobal) {
            this.globalRecipes.remove(recipe.method_8114());
            this.globalRecipes.put(recipe.method_8114(), recipe);
            Packets.sendAll(new PacketSyncRecipeUpdate(recipe.method_8114(), 6, recipe.writeNBT()));
        } else {
            this.anvilRecipes.remove(recipe.method_8114());
            this.anvilRecipes.put(recipe.method_8114(), recipe);
            Packets.sendAll(new PacketSyncRecipeUpdate(recipe.method_8114(), 7, recipe.writeNBT()));
        }
        this.saveCategories();
        this.reloadGlobalRecipes();
        return recipe;
    }

    private int getUniqueId() {
        ++this.nextId;
        return this.nextId;
    }

    private boolean containsRecipeName(String name) {
        name = name.toLowerCase();
        for (RecipeCarpentry recipe : this.globalRecipes.values()) {
            if (!recipe.name.toLowerCase().equals(name)) continue;
            return true;
        }
        for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
            if (!recipe.name.toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecipeCarpentry delete(class_2960 id) {
        RecipeCarpentry recipe = this.getRecipe(id);
        if (recipe == null) {
            return null;
        }
        this.globalRecipes.remove(recipe.method_8114());
        this.anvilRecipes.remove(recipe.method_8114());
        if (recipe.isGlobal) {
            Packets.sendAll(new PacketSyncRecipeRemove(id, 6));
        } else {
            Packets.sendAll(new PacketSyncRecipeRemove(id, 7));
        }
        this.saveCategories();
        this.reloadGlobalRecipes();
        return recipe;
    }

    @Override
    public List<IRecipe> getGlobalList() {
        return new ArrayList<IRecipe>(this.globalRecipes.values());
    }

    @Override
    public List<IRecipe> getCarpentryList() {
        return new ArrayList<IRecipe>(this.anvilRecipes.values());
    }

    @Override
    public IRecipe addRecipe(String name, boolean global, class_1799 result, Object ... objects) {
        RecipeCarpentry recipe = new RecipeCarpentry(new class_2960("customnpcs", name), name);
        recipe.isGlobal = global;
        recipe = RecipeCarpentry.createRecipe(new class_2960("customnpcs", name), recipe, result, objects);
        return this.saveRecipe(recipe);
    }

    @Override
    public IRecipe addRecipe(String name, boolean global, class_1799 result, int width, int height, class_1799 ... objects) {
        class_2371 list = class_2371.method_10211();
        for (class_1799 item : objects) {
            if (item.method_7960()) continue;
            list.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{item}));
        }
        RecipeCarpentry recipe = new RecipeCarpentry(new class_2960("customnpcs", name), width, height, (class_2371<class_1856>)list, result);
        recipe.isGlobal = global;
        recipe.name = name;
        return this.saveRecipe(recipe);
    }

    static {
        syncRecipes = new HashMap();
    }
}

