/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.shared.common.util.LogWriter;

public class SpawnController {
    public HashMap<class_2960, List<SpawnData>> biomes = new HashMap();
    public ArrayList<SpawnData> data = new ArrayList();
    public class_5819 random = class_5819.method_43047();
    public static SpawnController instance;
    private int lastUsedID = 0;

    public SpawnController() {
        instance = this;
        this.loadData();
    }

    private void loadData() {
        File saveDir = CustomNpcs.getLevelSaveDirectory();
        if (saveDir == null) {
            return;
        }
        try {
            File file = new File(saveDir, "spawns.dat");
            if (file.exists()) {
                this.loadDataFile(file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(saveDir, "spawns.dat_old");
                if (file.exists()) {
                    this.loadDataFile(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadDataFile(File file) throws IOException {
        DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        this.loadData(var1);
        var1.close();
    }

    public void loadData(DataInputStream stream) throws IOException {
        ArrayList<SpawnData> data = new ArrayList<SpawnData>();
        class_2487 nbttagcompound1 = class_2507.method_10627((DataInput)stream);
        this.lastUsedID = nbttagcompound1.method_10550("lastID");
        class_2499 nbtlist = nbttagcompound1.method_10554("NPCSpawnData", 10);
        if (nbtlist != null) {
            for (int i = 0; i < nbtlist.size(); ++i) {
                class_2487 nbttagcompound = nbtlist.method_10602(i);
                SpawnData spawn = new SpawnData();
                spawn.readNBT(nbttagcompound);
                data.add(spawn);
            }
        }
        this.data = data;
        this.fillBiomeData();
    }

    public class_2487 getNBT() {
        class_2499 list = new class_2499();
        for (SpawnData spawn : this.data) {
            class_2487 nbtfactions = new class_2487();
            spawn.writeNBT(nbtfactions);
            list.add((Object)nbtfactions);
        }
        class_2487 nbttagcompound = new class_2487();
        nbttagcompound.method_10569("lastID", this.lastUsedID);
        nbttagcompound.method_10566("NPCSpawnData", (class_2520)list);
        return nbttagcompound;
    }

    public void saveData() {
        try {
            File saveDir = CustomNpcs.getLevelSaveDirectory();
            File file = new File(saveDir, "spawns.dat_new");
            File file1 = new File(saveDir, "spawns.dat_old");
            File file2 = new File(saveDir, "spawns.dat");
            class_2507.method_10634((class_2487)this.getNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    public SpawnData getSpawnData(int id) {
        for (SpawnData spawn : this.data) {
            if (spawn.id != id) continue;
            return spawn;
        }
        return null;
    }

    public void saveSpawnData(SpawnData spawn) {
        SpawnData original;
        if (spawn.id < 0) {
            spawn.id = this.getUnusedId();
        }
        if ((original = this.getSpawnData(spawn.id)) == null) {
            this.data.add(spawn);
        } else {
            original.readNBT(spawn.writeNBT(new class_2487()));
        }
        this.fillBiomeData();
        this.saveData();
    }

    private void fillBiomeData() {
        HashMap<class_2960, ArrayList<SpawnData>> biomes = new HashMap<class_2960, ArrayList<SpawnData>>();
        for (SpawnData spawn : this.data) {
            for (class_2960 s : spawn.biomes) {
                ArrayList<SpawnData> list = (ArrayList<SpawnData>)biomes.get(s);
                if (list == null) {
                    list = new ArrayList<SpawnData>();
                    biomes.put(s, list);
                }
                list.add(spawn);
            }
        }
        this.biomes = biomes;
    }

    public int getUnusedId() {
        ++this.lastUsedID;
        return this.lastUsedID;
    }

    public void removeSpawnData(int id) {
        ArrayList<SpawnData> data = new ArrayList<SpawnData>();
        for (SpawnData spawn : this.data) {
            if (spawn.id == id) continue;
            data.add(spawn);
        }
        this.data = data;
        this.fillBiomeData();
        this.saveData();
    }

    public List<SpawnData> getSpawnList(class_2960 biome) {
        return this.biomes.get(biome);
    }

    public SpawnData getRandomSpawnData(class_2960 biome) {
        List<SpawnData> list = this.getSpawnList(biome);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return class_6011.method_34986((class_5819)this.random, list).orElse(null);
    }

    public boolean hasSpawnList(class_2960 biome) {
        return this.biomes.containsKey(biome) && !this.biomes.get(biome).isEmpty();
    }

    public Map<String, Integer> getScroll() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SpawnData spawn : this.data) {
            map.put(spawn.name, spawn.id);
        }
        return map;
    }
}

