/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiData;
import noppes.npcs.util.CustomNPCsScheduler;

public class BankData {
    public HashMap<Integer, NpcMiscInventory> itemSlots = new HashMap();
    public HashMap<Integer, Boolean> upgradedSlots = new HashMap();
    public int unlockedSlots = 0;
    public int bankId = -1;

    public BankData() {
        for (int i = 0; i < 6; ++i) {
            this.itemSlots.put(i, new NpcMiscInventory(54));
            this.upgradedSlots.put(i, false);
        }
    }

    public void readNBT(class_2487 nbttagcompound) {
        this.bankId = nbttagcompound.method_10550("DataBankId");
        this.unlockedSlots = nbttagcompound.method_10550("UnlockedSlots");
        this.itemSlots = this.getItemSlots(nbttagcompound.method_10554("BankInv", 10));
        this.upgradedSlots = NBTTags.getBooleanList(nbttagcompound.method_10554("UpdatedSlots", 10));
    }

    private HashMap<Integer, NpcMiscInventory> getItemSlots(class_2499 tagList) {
        HashMap<Integer, NpcMiscInventory> list = new HashMap<Integer, NpcMiscInventory>();
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 nbttagcompound = tagList.method_10602(i);
            int slot = nbttagcompound.method_10550("Slot");
            NpcMiscInventory inv = new NpcMiscInventory(54);
            inv.setFromNBT(nbttagcompound.method_10562("BankItems"));
            list.put(slot, inv);
        }
        return list;
    }

    public void writeNBT(class_2487 nbttagcompound) {
        nbttagcompound.method_10569("DataBankId", this.bankId);
        nbttagcompound.method_10569("UnlockedSlots", this.unlockedSlots);
        nbttagcompound.method_10566("UpdatedSlots", (class_2520)NBTTags.nbtBooleanList(this.upgradedSlots));
        nbttagcompound.method_10566("BankInv", (class_2520)this.nbtItemSlots(this.itemSlots));
    }

    private class_2499 nbtItemSlots(HashMap<Integer, NpcMiscInventory> items) {
        class_2499 list = new class_2499();
        for (int slot : items.keySet()) {
            class_2487 nbttagcompound = new class_2487();
            nbttagcompound.method_10569("Slot", slot);
            nbttagcompound.method_10566("BankItems", (class_2520)items.get(slot).getToNBT());
            list.add((Object)nbttagcompound);
        }
        return list;
    }

    public boolean isUpgraded(Bank bank, int slot) {
        if (bank.isUpgraded(slot)) {
            return true;
        }
        return bank.canBeUpgraded(slot) && this.upgradedSlots.get(slot) != false;
    }

    public void openBankGui(class_3222 player, EntityNPCInterface npc, int bankId, int slot) {
        Bank bank = BankController.getInstance().getBank(bankId);
        if (bank.getMaxSlots() <= slot) {
            return;
        }
        if (bank.startSlots > this.unlockedSlots) {
            this.unlockedSlots = bank.startSlots;
        }
        class_1799 currency = class_1799.field_8037;
        if (this.unlockedSlots <= slot) {
            currency = bank.currencyInventory.method_5438(slot);
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankUnlock, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else if (this.isUpgraded(bank, slot)) {
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankLarge, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else if (bank.canBeUpgraded(slot)) {
            currency = bank.upgradeInventory.method_5438(slot);
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankUprade, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else {
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankSmall, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        }
        class_1799 item = currency;
        CustomNPCsScheduler.runTack(() -> {
            class_2487 compound = new class_2487();
            compound.method_10569("MaxSlots", bank.getMaxSlots());
            compound.method_10569("UnlockedSlots", this.unlockedSlots);
            if (item != null && !item.method_7960()) {
                compound.method_10566("Currency", (class_2520)item.method_7953(new class_2487()));
                ContainerNPCBankInterface container = this.getContainer((class_1657)player);
                if (container != null) {
                    container.setCurrency(item);
                }
            }
            Packets.send(player, new PacketGuiData(compound));
        }, 300);
    }

    private ContainerNPCBankInterface getContainer(class_1657 player) {
        class_1703 con = player.field_7512;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return null;
        }
        return (ContainerNPCBankInterface)con;
    }
}

