/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import noppes.npcs.ICompatibilty;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.api.handler.data.IDialog;
import noppes.npcs.api.handler.data.IDialogCategory;
import noppes.npcs.api.handler.data.IDialogOption;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.db.DatabaseColumn;

public class Dialog
implements ICompatibilty,
IDialog {
    public int version = VersionCompatibility.ModRev;
    @DatabaseColumn(name="id", type=DatabaseColumn.Type.INT)
    public int id = -1;
    @DatabaseColumn(name="title", type=DatabaseColumn.Type.VARCHAR)
    public String title = "";
    @DatabaseColumn(name="text", type=DatabaseColumn.Type.TEXT)
    public String text = "";
    @DatabaseColumn(name="quest", type=DatabaseColumn.Type.INT)
    public int quest = -1;
    @DatabaseColumn(name="category", type=DatabaseColumn.Type.VARCHAR)
    public String categoryName;
    public final DialogCategory category;
    public HashMap<Integer, DialogOption> options = new HashMap();
    public Availability availability = new Availability();
    public FactionOptions factionOptions = new FactionOptions();
    public String sound;
    public String command = "";
    public PlayerMail mail = new PlayerMail();
    public boolean hideNPC = false;
    public boolean showWheel = false;
    public boolean disableEsc = false;

    public Dialog(DialogCategory category) {
        this.category = category;
    }

    public boolean hasDialogs(class_1657 player) {
        for (DialogOption option : this.options.values()) {
            if (option == null || option.optionType != 1 || !option.hasDialog() || !option.isAvailable(player)) continue;
            return true;
        }
        return false;
    }

    public void readNBT(class_2487 compound) {
        this.id = compound.method_10550("DialogId");
        this.readNBTPartial(compound);
    }

    public void readNBTPartial(class_2487 compound) {
        this.version = compound.method_10550("ModRev");
        VersionCompatibility.CheckAvailabilityCompatibility(this, compound);
        this.title = compound.method_10558("DialogTitle");
        this.text = compound.method_10558("DialogText");
        this.quest = compound.method_10550("DialogQuest");
        this.sound = compound.method_10558("DialogSound");
        this.command = compound.method_10558("DialogCommand");
        this.mail.readNBT(compound.method_10562("DialogMail"));
        this.hideNPC = compound.method_10577("DialogHideNPC");
        this.showWheel = compound.method_10577("DialogShowWheel");
        this.disableEsc = compound.method_10577("DialogDisableEsc");
        class_2499 options = compound.method_10554("Options", 10);
        HashMap<Integer, DialogOption> newoptions = new HashMap<Integer, DialogOption>();
        for (int iii = 0; iii < options.size(); ++iii) {
            class_2487 option = options.method_10602(iii);
            int opslot = option.method_10550("OptionSlot");
            DialogOption dia = new DialogOption();
            dia.readNBT(option.method_10562("Option"));
            if (dia.hasDialog()) {
                // empty if block
            }
            newoptions.put(opslot, dia);
            dia.slot = opslot;
        }
        this.options = newoptions;
        this.availability.load(compound);
        this.factionOptions.load(compound);
    }

    @Override
    public class_2487 save(class_2487 compound) {
        compound.method_10569("DialogId", this.id);
        return this.writeToNBTPartial(compound);
    }

    public class_2487 writeToNBTPartial(class_2487 compound) {
        compound.method_10582("DialogTitle", this.title);
        compound.method_10582("DialogText", this.text);
        compound.method_10569("DialogQuest", this.quest);
        compound.method_10582("DialogCommand", this.command);
        compound.method_10566("DialogMail", (class_2520)this.mail.writeNBT());
        compound.method_10556("DialogHideNPC", this.hideNPC);
        compound.method_10556("DialogShowWheel", this.showWheel);
        compound.method_10556("DialogDisableEsc", this.disableEsc);
        if (this.sound != null && !this.sound.isEmpty()) {
            compound.method_10582("DialogSound", this.sound);
        }
        class_2499 options = new class_2499();
        for (int opslot : this.options.keySet()) {
            class_2487 listcompound = new class_2487();
            listcompound.method_10569("OptionSlot", opslot);
            listcompound.method_10566("Option", (class_2520)this.options.get(opslot).writeNBT());
            options.add((Object)listcompound);
        }
        compound.method_10566("Options", (class_2520)options);
        this.availability.save(compound);
        this.factionOptions.save(compound);
        compound.method_10569("ModRev", this.version);
        return compound;
    }

    public boolean hasQuest() {
        return this.getQuest() != null;
    }

    @Override
    public Quest getQuest() {
        if (QuestController.instance == null) {
            return null;
        }
        return QuestController.instance.quests.get(this.quest);
    }

    public boolean hasOtherOptions() {
        for (DialogOption option : this.options.values()) {
            if (option == null || option.optionType == 2) continue;
            return true;
        }
        return false;
    }

    public Dialog copy(class_1657 player) {
        Dialog dialog = new Dialog(this.category);
        dialog.id = this.id;
        dialog.text = this.text;
        dialog.title = this.title;
        dialog.quest = this.quest;
        dialog.sound = this.sound;
        dialog.mail = this.mail;
        dialog.command = this.command;
        dialog.hideNPC = this.hideNPC;
        dialog.showWheel = this.showWheel;
        dialog.disableEsc = this.disableEsc;
        for (int slot : this.options.keySet()) {
            DialogOption option = this.options.get(slot);
            if (option.optionType == 1 && (!option.hasDialog() || !option.isAvailable(player))) continue;
            dialog.options.put(slot, option);
        }
        return dialog;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public List<IDialogOption> getOptions() {
        return new ArrayList<IDialogOption>(this.options.values());
    }

    @Override
    public IDialogOption getOption(int slot) {
        IDialogOption option = this.options.get(slot);
        if (option == null) {
            throw new CustomNPCsException("There is no DialogOption for slot: " + slot, new Object[0]);
        }
        return option;
    }

    @Override
    public IAvailability getAvailability() {
        return this.availability;
    }

    @Override
    public IDialogCategory getCategory() {
        return this.category;
    }

    @Override
    public void save() {
        DialogController.instance.saveDialog(this.category, this);
    }

    @Override
    public void setName(String name) {
        this.title = name;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setQuest(IQuest quest) {
        if (quest == null) {
            this.quest = -1;
        } else {
            if (quest.getId() < 0) {
                throw new CustomNPCsException("Quest id is lower than 0", new Object[0]);
            }
            this.quest = quest.getId();
        }
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(String command) {
        this.command = command;
    }
}

