/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import noppes.npcs.EventHooks;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;

public class PlayerFactionData {
    public HashMap<Integer, Integer> factionData = new HashMap();

    public void loadNBTData(class_2487 compound) {
        HashMap<Integer, Integer> factionData = new HashMap<Integer, Integer>();
        if (compound == null) {
            return;
        }
        class_2499 list = compound.method_10554("FactionData", 10);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbttagcompound = list.method_10602(i);
            factionData.put(nbttagcompound.method_10550("Faction"), nbttagcompound.method_10550("Points"));
        }
        this.factionData = factionData;
    }

    public void saveNBTData(class_2487 compound) {
        class_2499 list = new class_2499();
        for (int faction : this.factionData.keySet()) {
            class_2487 nbttagcompound = new class_2487();
            nbttagcompound.method_10569("Faction", faction);
            nbttagcompound.method_10569("Points", this.factionData.get(faction).intValue());
            list.add((Object)nbttagcompound);
        }
        compound.method_10566("FactionData", (class_2520)list);
    }

    public int getFactionPoints(class_1657 player, int factionId) {
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null) {
            return 0;
        }
        if (!this.factionData.containsKey(factionId)) {
            if (player.method_37908().field_9236) {
                this.factionData.put(factionId, faction.defaultPoints);
                return faction.defaultPoints;
            }
            PlayerScriptData handler = PlayerData.get((class_1657)player).scriptData;
            PlayerWrapper wrapper = (PlayerWrapper)NpcAPI.Instance().getIEntity((class_1297)player);
            PlayerEvent.FactionUpdateEvent event = new PlayerEvent.FactionUpdateEvent(wrapper, faction, faction.defaultPoints, true);
            EventHooks.OnPlayerFactionChange(handler, event);
            this.factionData.put(factionId, event.points);
            PlayerData data = PlayerData.get(player);
            data.updateClient = true;
        }
        return this.factionData.get(factionId);
    }

    public void increasePoints(class_1657 player, int factionId, int points) {
        PlayerEvent.FactionUpdateEvent event;
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null || player == null || player.method_37908().field_9236) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((class_1657)player).scriptData;
        PlayerWrapper wrapper = (PlayerWrapper)NpcAPI.Instance().getIEntity((class_1297)player);
        if (!this.factionData.containsKey(factionId)) {
            event = new PlayerEvent.FactionUpdateEvent(wrapper, faction, faction.defaultPoints, true);
            EventHooks.OnPlayerFactionChange(handler, event);
            this.factionData.put(factionId, event.points);
        }
        event = new PlayerEvent.FactionUpdateEvent(wrapper, faction, points, false);
        EventHooks.OnPlayerFactionChange(handler, event);
        this.factionData.put(factionId, this.factionData.get(factionId) + points);
    }

    public class_2487 getPlayerGuiData() {
        class_2487 compound = new class_2487();
        this.saveNBTData(compound);
        class_2499 list = new class_2499();
        for (int id : this.factionData.keySet()) {
            Faction faction = FactionController.instance.getFaction(id);
            if (faction == null || faction.hideFaction) continue;
            class_2487 com = new class_2487();
            faction.writeNBT(com);
            list.add((Object)com);
        }
        compound.method_10566("FactionList", (class_2520)list);
        return compound;
    }
}

