/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import noppes.npcs.api.IPlayerSkin;

public class PlayerSkinData
implements IPlayerSkin {
    private boolean isMale = true;
    private int body;
    private int bodyColor;
    private int hair;
    private int hairColor;
    private int face;
    private int eyesColor;
    private int leg;
    private int jacket;
    private int shoes;
    private List<Integer> peculiarities;
    private boolean isActive;
    private class_2960 cacheResLoc = null;
    private boolean hasChanged;
    private static boolean skinsNeedResync;

    @Override
    public boolean isMale() {
        return this.isMale;
    }

    @Override
    public PlayerSkinData setMale(boolean male) {
        this.isMale = male;
        this.markChanged();
        return this;
    }

    public String getGender() {
        return this.isMale ? "male" : "female";
    }

    @Override
    public int getBodyType() {
        return this.body;
    }

    @Override
    public PlayerSkinData setBodyType(int body) {
        this.body = body;
        this.markChanged();
        return this;
    }

    @Override
    public int getBodyColor() {
        return this.bodyColor;
    }

    @Override
    public PlayerSkinData setBodyColor(int bodyColor) {
        this.bodyColor = bodyColor;
        this.markChanged();
        return this;
    }

    @Override
    public int getHairType() {
        return this.hair;
    }

    @Override
    public PlayerSkinData setHairType(int hair) {
        this.hair = hair;
        this.markChanged();
        return this;
    }

    @Override
    public int getHairColor() {
        return this.hairColor;
    }

    @Override
    public PlayerSkinData setHairColor(int hairColor) {
        this.hairColor = hairColor;
        this.markChanged();
        return this;
    }

    @Override
    public int getFaceType() {
        return this.face;
    }

    @Override
    public PlayerSkinData setFaceType(int face) {
        this.face = face;
        this.markChanged();
        return this;
    }

    @Override
    public int getEyesColor() {
        return this.eyesColor;
    }

    @Override
    public PlayerSkinData setEyesColor(int eyesColor) {
        this.eyesColor = eyesColor;
        this.markChanged();
        return this;
    }

    @Override
    public int getPantsType() {
        return this.leg;
    }

    @Override
    public PlayerSkinData setPantsType(int leg) {
        this.leg = leg;
        this.markChanged();
        return this;
    }

    @Override
    public int getJacketType() {
        return this.jacket;
    }

    @Override
    public PlayerSkinData setJacketType(int jacket) {
        this.jacket = jacket;
        this.markChanged();
        return this;
    }

    @Override
    public int getShoesType() {
        return this.shoes;
    }

    @Override
    public PlayerSkinData setShoesType(int shoes) {
        this.shoes = shoes;
        this.markChanged();
        return this;
    }

    @Override
    public List<Integer> getPeculiarities() {
        return this.peculiarities;
    }

    @Override
    public PlayerSkinData setPeculiarities(List<Integer> peculiarities) {
        this.peculiarities = peculiarities;
        this.markChanged();
        return this;
    }

    public void markChanged() {
        this.calculateResLoc();
        skinsNeedResync = true;
        this.hasChanged = true;
        this.isActive = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void markSynced() {
        this.hasChanged = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void calculateResLoc() {
        StringBuilder path = new StringBuilder("textures/entity/custom/");
        path.append(this.getGender()).append("_");
        path.append(this.getBodyType()).append("_");
        path.append(this.getBodyColor()).append("_");
        path.append(this.getHairType()).append("_");
        path.append(this.getHairColor()).append("_");
        path.append(this.getFaceType()).append("_");
        path.append(this.getEyesColor()).append("_");
        path.append(this.getPantsType()).append("_");
        path.append(this.getJacketType()).append("_");
        path.append(this.getShoesType());
        for (int id : this.peculiarities) {
            path.append("_").append(id);
        }
        path.append(".png");
        this.cacheResLoc = new class_2960("customnpcs", path.toString());
    }

    public class_2960 getResLoc() {
        if (this.cacheResLoc == null) {
            this.calculateResLoc();
        }
        return this.cacheResLoc;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2960 getPartResLocByNumber(class_3300 textureManager, String name, int partNum) {
        class_2960 loc = new class_2960("customnpcs", "textures/entity/custom/" + this.getGender() + "/" + name + "/" + partNum + ".png");
        if (textureManager.method_14486(loc).isEmpty()) {
            loc = new class_2960("customnpcs", "textures/entity/custom/" + this.getGender() + "/" + name + "/0.png");
        }
        if (!textureManager.method_14486(loc).isEmpty()) {
            return loc;
        }
        return null;
    }

    public class_2487 saveNBTData(class_2487 tag) {
        tag.method_10556("isMale", this.isMale);
        tag.method_10569("body", this.body);
        tag.method_10569("bodyColor", this.bodyColor);
        tag.method_10569("hair", this.hair);
        tag.method_10569("hairColor", this.hairColor);
        tag.method_10569("face", this.face);
        tag.method_10569("eyesColor", this.eyesColor);
        tag.method_10569("leg", this.leg);
        tag.method_10569("jacket", this.jacket);
        tag.method_10569("shoes", this.shoes);
        tag.method_10572("peculiarities", this.peculiarities);
        tag.method_10556("isActive", this.isActive);
        return tag;
    }

    public void loadNBTData(class_2487 tag) {
        this.isMale = tag.method_10577("isMale");
        this.body = tag.method_10550("body");
        this.bodyColor = tag.method_10550("bodyColor");
        this.hair = tag.method_10550("hair");
        this.hairColor = tag.method_10550("hairColor");
        this.face = tag.method_10550("face");
        this.eyesColor = tag.method_10550("eyesColor");
        this.leg = tag.method_10550("leg");
        this.jacket = tag.method_10550("jacket");
        this.shoes = tag.method_10550("shoes");
        this.peculiarities = Arrays.stream(tag.method_10561("peculiarities")).boxed().collect(Collectors.toList());
        this.isActive = tag.method_10577("isActive");
    }

    public static boolean needsAnyResync() {
        return skinsNeedResync;
    }

    public static void resyncPerformed() {
        skinsNeedResync = false;
    }
}

