/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IPos;
import noppes.npcs.api.entity.data.INPCAi;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobBuilder;
import noppes.npcs.roles.JobFarmer;

public class DataAI
implements INPCAi {
    private EntityNPCInterface npc;
    public int onAttack = 0;
    public int doorInteract = 2;
    public int findShelter = 2;
    public boolean canSwim = true;
    public boolean reactsToFire = false;
    public boolean avoidsWater = false;
    public boolean avoidsSun = false;
    public boolean returnToStart = true;
    public boolean directLOS = true;
    public boolean canLeap = false;
    public boolean canSprint = false;
    public boolean stopAndInteract = true;
    public boolean attackInvisible = false;
    public int movementType = 0;
    public int animationType = 0;
    private int standingType = 0;
    private int movingType = 0;
    public boolean npcInteracting = true;
    public int orientation = 0;
    public float bodyOffsetX = 5.0f;
    public float bodyOffsetY = 5.0f;
    public float bodyOffsetZ = 5.0f;
    public int walkingRange = 10;
    public int activeRange = 32;
    private int moveSpeed = 5;
    private List<int[]> movingPath = new ArrayList<int[]>();
    private class_2338 startPos = class_2338.field_10980;
    public int movingPos = 0;
    public int movingPattern = 0;
    public boolean movingPause = true;
    public boolean mountControl = false;

    public DataAI(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public void readToNBT(class_2487 compound) {
        this.canSwim = compound.method_10577("CanSwim");
        this.reactsToFire = compound.method_10577("ReactsToFire");
        this.setAvoidsWater(compound.method_10577("AvoidsWater"));
        this.avoidsSun = compound.method_10577("AvoidsSun");
        this.returnToStart = compound.method_10577("ReturnToStart");
        this.onAttack = compound.method_10550("OnAttack");
        this.doorInteract = compound.method_10550("DoorInteract");
        this.findShelter = compound.method_10550("FindShelter");
        this.directLOS = compound.method_10577("DirectLOS");
        this.canLeap = compound.method_10577("CanLeap");
        this.canSprint = compound.method_10577("CanSprint");
        this.movingPause = compound.method_10577("MovingPause");
        this.npcInteracting = compound.method_10577("npcInteracting");
        this.stopAndInteract = compound.method_10577("stopAndInteract");
        this.movementType = compound.method_10550("MovementType");
        this.animationType = compound.method_10550("MoveState");
        this.standingType = compound.method_10550("StandingState");
        this.movingType = compound.method_10550("MovingState");
        this.orientation = compound.method_10550("Orientation");
        this.bodyOffsetY = compound.method_10583("PositionOffsetY");
        this.bodyOffsetZ = compound.method_10583("PositionOffsetZ");
        this.bodyOffsetX = compound.method_10583("PositionOffsetX");
        this.walkingRange = compound.method_10550("WalkingRange");
        this.setWalkingSpeed(compound.method_10550("MoveSpeed"));
        this.setMovingPath(NBTTags.getIntegerArraySet(compound.method_10554("MovingPathNew", 10)));
        this.movingPos = compound.method_10550("MovingPos");
        this.movingPattern = compound.method_10550("MovingPatern");
        this.attackInvisible = compound.method_10577("AttackInvisible");
        if (compound.method_10545("ActiveRange")) {
            this.activeRange = compound.method_10550("ActiveRange");
        }
        if (compound.method_10545("StartPosNew")) {
            int[] startPos = compound.method_10561("StartPosNew");
            this.setStartPos(new class_2338(startPos[0], startPos[1], startPos[2]));
        }
        this.mountControl = compound.method_10577("MountControl");
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10556("CanSwim", this.canSwim);
        compound.method_10556("ReactsToFire", this.reactsToFire);
        compound.method_10556("AvoidsWater", this.avoidsWater);
        compound.method_10556("AvoidsSun", this.avoidsSun);
        compound.method_10556("ReturnToStart", this.returnToStart);
        compound.method_10569("OnAttack", this.onAttack);
        compound.method_10569("DoorInteract", this.doorInteract);
        compound.method_10569("FindShelter", this.findShelter);
        compound.method_10556("DirectLOS", this.directLOS);
        compound.method_10556("CanLeap", this.canLeap);
        compound.method_10556("CanSprint", this.canSprint);
        compound.method_10556("MovingPause", this.movingPause);
        compound.method_10556("npcInteracting", this.npcInteracting);
        compound.method_10556("stopAndInteract", this.stopAndInteract);
        compound.method_10569("MoveState", this.animationType);
        compound.method_10569("StandingState", this.standingType);
        compound.method_10569("MovingState", this.movingType);
        compound.method_10569("MovementType", this.movementType);
        compound.method_10569("Orientation", this.orientation);
        compound.method_10548("PositionOffsetX", this.bodyOffsetX);
        compound.method_10548("PositionOffsetY", this.bodyOffsetY);
        compound.method_10548("PositionOffsetZ", this.bodyOffsetZ);
        compound.method_10569("WalkingRange", this.walkingRange);
        compound.method_10569("MoveSpeed", this.moveSpeed);
        compound.method_10566("MovingPathNew", (class_2520)NBTTags.nbtIntegerArraySet(this.movingPath));
        compound.method_10569("MovingPos", this.movingPos);
        compound.method_10569("MovingPatern", this.movingPattern);
        this.setAvoidsWater(this.avoidsWater);
        compound.method_10539("StartPosNew", this.getStartArray());
        compound.method_10556("AttackInvisible", this.attackInvisible);
        compound.method_10569("ActiveRange", this.activeRange);
        compound.method_10556("MountControl", this.mountControl);
        return compound;
    }

    public List<int[]> getMovingPath() {
        if (this.movingPath.isEmpty() && this.startPos != null) {
            this.movingPath.add(this.getStartArray());
        }
        return this.movingPath;
    }

    public void setMovingPath(List<int[]> list) {
        this.movingPath = list;
        if (!this.movingPath.isEmpty()) {
            int[] startPos = this.movingPath.get(0);
            this.setStartPos(new class_2338(startPos[0], startPos[1], startPos[2]));
        }
    }

    public class_2338 startPos() {
        if (this.startPos == null || this.startPos == class_2338.field_10980) {
            this.setStartPos(this.npc.method_24515());
        }
        return this.startPos;
    }

    public int[] getStartArray() {
        class_2338 pos = this.startPos();
        return new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
    }

    public int[] getCurrentMovingPath() {
        List<int[]> list = this.getMovingPath();
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        int pos = this.movingPos;
        if (this.movingPattern == 0 && pos >= size) {
            this.movingPos = 0;
            pos = 0;
        }
        if (this.movingPattern == 1) {
            int size2 = size * 2 - 1;
            if (pos >= size2) {
                this.movingPos = 0;
                pos = 0;
            } else if (pos >= size) {
                pos = size2 - pos;
            }
        }
        return list.get(pos);
    }

    public void clearMovingPath() {
        this.movingPath.clear();
        this.movingPos = 0;
    }

    public void setMovingPathPos(int m_pos, int[] pos) {
        if (m_pos < 0) {
            m_pos = 0;
        }
        this.movingPath.set(m_pos, pos);
    }

    public int[] getMovingPathPos(int m_pos) {
        return this.movingPath.get(m_pos);
    }

    public void appendMovingPath(int[] pos) {
        this.movingPath.add(pos);
    }

    public int getMovingPos() {
        return this.movingPos;
    }

    public void setMovingPos(int pos) {
        this.movingPos = pos;
    }

    public int getMovingPathSize() {
        return this.movingPath.size();
    }

    public void incrementMovingPath() {
        List<int[]> list = this.getMovingPath();
        if (list.size() == 1) {
            this.movingPos = 0;
            return;
        }
        ++this.movingPos;
        if (this.movingPattern == 0) {
            this.movingPos %= list.size();
        } else if (this.movingPattern == 1) {
            int size = list.size() * 2 - 1;
            this.movingPos %= size;
        }
    }

    public void decreaseMovingPath() {
        List<int[]> list = this.getMovingPath();
        if (list.size() == 1) {
            this.movingPos = 0;
            return;
        }
        --this.movingPos;
        if (this.movingPos < 0) {
            if (this.movingPattern == 0) {
                this.movingPos = list.size() - 1;
            } else if (this.movingPattern == 1) {
                this.movingPos = list.size() * 2 - 2;
            }
        }
    }

    public double distanceToSqrToPathPoint() {
        int[] pos = this.getCurrentMovingPath();
        return this.npc.method_5649((double)pos[0] + 0.5, pos[1], (double)pos[2] + 0.5);
    }

    public IPos getStartPos() {
        return new BlockPosWrapper(this.startPos());
    }

    public void setStartPos(class_2338 pos) {
        this.startPos = pos;
        this.npc.method_18408(this.startPos, Math.max(this.npc.stats.aggroRange * 2, 64));
    }

    public void setStartPos(IPos pos) {
        this.setStartPos(pos.getMCBlockPos());
    }

    public void setStartPos(double x, double y, double z) {
        this.setStartPos(new class_2338((int)x, (int)y, (int)z));
    }

    @Override
    public void setReturnsHome(boolean bo) {
        this.returnToStart = bo;
    }

    @Override
    public boolean getReturnsHome() {
        return this.returnToStart;
    }

    public boolean shouldReturnHome() {
        if (this.npc.job.getType() == 10 && ((JobBuilder)this.npc.job).isBuilding()) {
            return false;
        }
        if (this.npc.job.getType() == 11 && ((JobFarmer)this.npc.job).isPlucking()) {
            return false;
        }
        return this.returnToStart;
    }

    @Override
    public int getAnimation() {
        return this.animationType;
    }

    @Override
    public int getCurrentAnimation() {
        return this.npc.currentAnimation;
    }

    @Override
    public void setAnimation(int type) {
        this.animationType = type;
    }

    @Override
    public int getRetaliateType() {
        return this.onAttack;
    }

    @Override
    public void setRetaliateType(int type) {
        if (type < 0 || type > 3) {
            throw new CustomNPCsException("Unknown retaliation type: " + type, new Object[0]);
        }
        this.onAttack = type;
        this.npc.updateAI = true;
    }

    @Override
    public int getMovingType() {
        return this.movingType;
    }

    @Override
    public void setMovingType(int type) {
        if (type < 0 || type > 2) {
            throw new CustomNPCsException("Unknown moving type: " + type, new Object[0]);
        }
        this.movingType = type;
        this.npc.updateAI = true;
    }

    @Override
    public int getStandingType() {
        return this.standingType;
    }

    @Override
    public void setStandingType(int type) {
        if (type < 0 || type > 3) {
            throw new CustomNPCsException("Unknown standing type: " + type, new Object[0]);
        }
        this.standingType = type;
        this.npc.updateAI = true;
    }

    @Override
    public boolean getAttackInvisible() {
        return this.attackInvisible;
    }

    @Override
    public void setAttackInvisible(boolean attack) {
        this.attackInvisible = attack;
    }

    @Override
    public int getWanderingRange() {
        return this.walkingRange;
    }

    @Override
    public void setWanderingRange(int range) {
        if (range < 1 || range > 50) {
            throw new CustomNPCsException("Bad wandering range: " + range, new Object[0]);
        }
        this.walkingRange = range;
    }

    @Override
    public boolean getInteractWithNPCs() {
        return this.npcInteracting;
    }

    @Override
    public void setInteractWithNPCs(boolean interact) {
        this.npcInteracting = interact;
    }

    @Override
    public boolean getStopOnInteract() {
        return this.stopAndInteract;
    }

    @Override
    public void setStopOnInteract(boolean stopOnInteract) {
        this.stopAndInteract = stopOnInteract;
    }

    @Override
    public int getWalkingSpeed() {
        return this.moveSpeed;
    }

    @Override
    public void setWalkingSpeed(int speed) {
        if (speed < 0 || speed > 100) {
            throw new CustomNPCsException("Wrong speed: " + speed, new Object[0]);
        }
        this.moveSpeed = speed;
        this.npc.method_5996(class_5134.field_23719).method_6192((double)this.npc.method_6029());
        this.npc.method_5996(class_5134.field_23720).method_6192((double)(this.npc.method_6029() * 2.0f));
    }

    @Override
    public int getMovingPathType() {
        return this.movingPattern;
    }

    @Override
    public boolean getMovingPathPauses() {
        return this.movingPause;
    }

    @Override
    public void setMovingPathType(int type, boolean pauses) {
        if (type < 0 && type > 1) {
            throw new CustomNPCsException("Moving path type: " + type, new Object[0]);
        }
        this.movingPattern = type;
        this.movingPause = pauses;
    }

    @Override
    public int getDoorInteract() {
        return this.doorInteract;
    }

    @Override
    public void setDoorInteract(int type) {
        this.doorInteract = type;
        this.npc.updateAI = true;
    }

    @Override
    public boolean getCanSwim() {
        return this.canSwim;
    }

    @Override
    public void setCanSwim(boolean canSwim) {
        this.canSwim = canSwim;
    }

    @Override
    public int getSheltersFrom() {
        return this.findShelter;
    }

    @Override
    public void setSheltersFrom(int type) {
        this.findShelter = type;
        this.npc.updateAI = true;
    }

    @Override
    public boolean getAttackLOS() {
        return this.directLOS;
    }

    @Override
    public void setAttackLOS(boolean enabled) {
        this.directLOS = enabled;
        this.npc.updateAI = true;
    }

    @Override
    public boolean getAvoidsWater() {
        return this.avoidsWater;
    }

    @Override
    public void setAvoidsWater(boolean enabled) {
        this.npc.method_5941(class_7.field_18, this.movementType != 2 && enabled ? -1.0f : 0.0f);
        this.avoidsWater = enabled;
    }

    @Override
    public boolean getLeapAtTarget() {
        return this.canLeap;
    }

    @Override
    public void setLeapAtTarget(boolean leap) {
        this.canLeap = leap;
        this.npc.updateAI = true;
    }

    @Override
    public int getNavigationType() {
        return this.movementType;
    }

    @Override
    public void setNavigationType(int type) {
        this.movementType = type;
    }

    @Override
    public void setMountControl(boolean enabled) {
        this.mountControl = enabled;
    }
}

