/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Random;
import net.minecraft.class_1259;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3544;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import nikedemos.markovnames.generators.MarkovGenerator;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.INPCDisplay;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataPeople;
import noppes.npcs.shared.client.util.NoppesStringUtils;
import noppes.npcs.util.ValueUtil;

public class DataDisplay
implements INPCDisplay {
    EntityNPCInterface npc;
    private String name = "Noppes";
    private String title = "";
    private int markovGeneratorId = 8;
    private int markovGender = 0;
    public byte skinType = 0;
    private String url = "";
    public GameProfile playerProfile;
    private String texture = "customnpcs:textures/entity/humanmale/steve.png";
    private String cloakTexture = "";
    private String glowTexture = "";
    private boolean overlayGlowing = true;
    private int visible = 0;
    public Availability availability = new Availability();
    private int modelSize = 5;
    private int showName = 0;
    private int skinColor = 0xFFFFFF;
    private boolean disableLivingAnimation = false;
    private byte hitboxState = 0;
    private byte showBossBar = 0;
    private class_1259.class_1260 bossColor = class_1259.class_1260.field_5788;

    public DataDisplay(EntityNPCInterface npc) {
        this.npc = npc;
        if (!npc.isClientSide()) {
            this.markovGeneratorId = new Random().nextInt(10);
            this.name = this.getRandomName();
        }
        if (npc.method_6051().method_43048(10) == 0) {
            DataPeople.Person p = DataPeople.get();
            this.name = p.name;
            this.title = p.title;
            if (!p.skin.isEmpty()) {
                this.texture = p.skin;
            }
        }
    }

    public String getRandomName() {
        return MarkovGenerator.fetch(this.markovGeneratorId, this.markovGender);
    }

    public class_2487 save(class_2487 nbttagcompound) {
        nbttagcompound.method_10582("Name", this.name);
        nbttagcompound.method_10569("MarkovGeneratorId", this.markovGeneratorId);
        nbttagcompound.method_10569("MarkovGender", this.markovGender);
        nbttagcompound.method_10582("Title", this.title);
        nbttagcompound.method_10582("SkinUrl", this.url);
        nbttagcompound.method_10582("Texture", this.texture);
        nbttagcompound.method_10582("CloakTexture", this.cloakTexture);
        nbttagcompound.method_10582("GlowTexture", this.glowTexture);
        nbttagcompound.method_10556("OverlayGlowing", this.overlayGlowing);
        nbttagcompound.method_10567("UsingSkinUrl", this.skinType);
        if (this.playerProfile != null) {
            class_2487 nbttagcompound1 = new class_2487();
            class_2512.method_10684((class_2487)nbttagcompound1, (GameProfile)this.playerProfile);
            nbttagcompound.method_10566("SkinUsername", (class_2520)nbttagcompound1);
        }
        nbttagcompound.method_10569("Size", this.modelSize);
        nbttagcompound.method_10569("ShowName", this.showName);
        nbttagcompound.method_10569("SkinColor", this.skinColor);
        nbttagcompound.method_10569("NpcVisible", this.visible);
        nbttagcompound.method_10566("VisibleAvailability", (class_2520)this.availability.save(new class_2487()));
        nbttagcompound.method_10556("NoLivingAnimation", this.disableLivingAnimation);
        nbttagcompound.method_10567("IsStatue", this.hitboxState);
        nbttagcompound.method_10567("BossBar", this.showBossBar);
        nbttagcompound.method_10569("BossColor", this.bossColor.ordinal());
        return nbttagcompound;
    }

    public void readToNBT(class_2487 nbttagcompound) {
        this.setName(nbttagcompound.method_10558("Name"));
        this.setMarkovGeneratorId(nbttagcompound.method_10550("MarkovGeneratorId"));
        this.setMarkovGender(nbttagcompound.method_10550("MarkovGender"));
        this.title = nbttagcompound.method_10558("Title");
        byte prevSkinType = this.skinType;
        String prevTexture = this.texture;
        String prevUrl = this.url;
        String prevPlayer = this.getSkinPlayer();
        this.url = nbttagcompound.method_10558("SkinUrl");
        this.skinType = nbttagcompound.method_10571("UsingSkinUrl");
        this.texture = nbttagcompound.method_10558("Texture");
        this.cloakTexture = nbttagcompound.method_10558("CloakTexture");
        this.glowTexture = nbttagcompound.method_10558("GlowTexture");
        if (nbttagcompound.method_10545("OverlayGlowing")) {
            this.overlayGlowing = nbttagcompound.method_10577("OverlayGlowing");
        }
        this.playerProfile = null;
        if (this.skinType == 1) {
            if (nbttagcompound.method_10573("SkinUsername", 10)) {
                this.playerProfile = class_2512.method_10683((class_2487)nbttagcompound.method_10562("SkinUsername"));
            } else if (nbttagcompound.method_10573("SkinUsername", 8) && !class_3544.method_15438((String)nbttagcompound.method_10558("SkinUsername"))) {
                this.playerProfile = new GameProfile(null, nbttagcompound.method_10558("SkinUsername"));
            }
            this.loadProfile();
        }
        this.modelSize = ValueUtil.CorrectInt(nbttagcompound.method_10550("Size"), 1, 30);
        this.showName = nbttagcompound.method_10550("ShowName");
        if (nbttagcompound.method_10545("SkinColor")) {
            this.skinColor = nbttagcompound.method_10550("SkinColor");
        }
        this.visible = nbttagcompound.method_10550("NpcVisible");
        this.availability.load(nbttagcompound.method_10562("VisibleAvailability"));
        VisibilityController.instance.trackNpc(this.npc);
        this.disableLivingAnimation = nbttagcompound.method_10577("NoLivingAnimation");
        this.hitboxState = nbttagcompound.method_10571("IsStatue");
        this.setBossbar(nbttagcompound.method_10571("BossBar"));
        this.setBossColor(nbttagcompound.method_10550("BossColor"));
        if (!(prevSkinType == this.skinType && this.texture.equals(prevTexture) && this.url.equals(prevUrl) && this.getSkinPlayer().equals(prevPlayer))) {
            this.npc.textureLocation = null;
        }
        this.npc.textureGlowLocation = null;
        this.npc.textureCloakLocation = null;
        this.npc.method_18382();
    }

    public void loadProfile() {
        if (this.playerProfile != null && !class_3544.method_15438((String)this.playerProfile.getName())) {
            if (this.npc.method_5682() == null) {
                class_2631.method_11335((GameProfile)this.playerProfile, profile -> {
                    this.playerProfile = profile;
                });
            } else {
                this.playerProfile = DataDisplay.getGameprofile(this.npc.method_5682(), this.playerProfile);
            }
        }
    }

    private static GameProfile getGameprofile(MinecraftServer server, GameProfile profile) {
        try {
            if (profile == null || class_3544.method_15438((String)profile.getName()) || profile.isComplete() && profile.getProperties().containsKey((Object)"textures")) {
                return profile;
            }
            GameProfile gameprofile = server.method_3793().method_14515(profile.getName()).orElse(null);
            if (gameprofile == null) {
                return profile;
            }
            Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
            if (property == null) {
                gameprofile = server.method_3844().fillProfileProperties(gameprofile, true);
            }
            return gameprofile;
        }
        catch (Exception e) {
            return profile;
        }
    }

    public boolean showName() {
        if (this.npc.isKilled()) {
            return false;
        }
        return this.showName == 0 || this.showName == 2 && this.npc.isAttacking();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name.equals(name)) {
            return;
        }
        this.name = name;
        this.npc.bossInfo.method_5413(this.npc.method_5476());
        this.npc.updateClient = true;
    }

    @Override
    public int getShowName() {
        return this.showName;
    }

    @Override
    public void setShowName(int type) {
        if (type == this.showName) {
            return;
        }
        this.showName = ValueUtil.CorrectInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    public int getMarkovGender() {
        return this.markovGender;
    }

    public void setMarkovGender(int gender) {
        if (this.markovGender == gender) {
            return;
        }
        this.markovGender = ValueUtil.CorrectInt(gender, 0, 2);
    }

    public int getMarkovGeneratorId() {
        return this.markovGeneratorId;
    }

    public void setMarkovGeneratorId(int id) {
        if (this.markovGeneratorId == id) {
            return;
        }
        this.markovGeneratorId = ValueUtil.CorrectInt(id, 0, 9);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (this.title.equals(title)) {
            return;
        }
        this.title = title;
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinUrl() {
        return this.url;
    }

    @Override
    public void setSkinUrl(String url) {
        if (this.url.equals(url)) {
            return;
        }
        this.url = url;
        this.skinType = url.isEmpty() ? (byte)0 : (byte)2;
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinPlayer() {
        return this.playerProfile == null ? "" : this.playerProfile.getName();
    }

    @Override
    public void setSkinPlayer(String name) {
        if (name == null || name.isEmpty()) {
            this.playerProfile = null;
            this.skinType = 0;
        } else {
            this.playerProfile = new GameProfile(null, name);
            this.skinType = 1;
        }
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinTexture() {
        return NoppesStringUtils.cleanResource(this.texture);
    }

    @Override
    public void setSkinTexture(String texture) {
        if (texture == null || this.texture.equals(texture)) {
            return;
        }
        this.texture = NoppesStringUtils.cleanResource(texture);
        this.npc.textureLocation = null;
        this.skinType = 0;
        this.npc.updateClient = true;
    }

    @Override
    public String getOverlayTexture() {
        return NoppesStringUtils.cleanResource(this.glowTexture);
    }

    public boolean isOverlayGlowing() {
        return this.overlayGlowing;
    }

    public void setOverlayGlowing(boolean glowing) {
        this.overlayGlowing = glowing;
    }

    @Override
    public void setOverlayTexture(String texture) {
        if (this.glowTexture.equals(texture)) {
            return;
        }
        this.glowTexture = NoppesStringUtils.cleanResource(texture);
        this.npc.textureGlowLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public String getCapeTexture() {
        return NoppesStringUtils.cleanResource(this.cloakTexture);
    }

    @Override
    public void setCapeTexture(String texture) {
        if (this.cloakTexture.equals(texture)) {
            return;
        }
        this.cloakTexture = NoppesStringUtils.cleanResource(texture);
        this.npc.textureCloakLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public boolean getHasLivingAnimation() {
        return !this.disableLivingAnimation;
    }

    @Override
    public void setHasLivingAnimation(boolean enabled) {
        this.disableLivingAnimation = !enabled;
        this.npc.updateClient = true;
    }

    @Override
    public int getBossbar() {
        return this.showBossBar;
    }

    @Override
    public void setBossbar(int type) {
        if (type == this.showBossBar) {
            return;
        }
        this.showBossBar = (byte)ValueUtil.CorrectInt(type, 0, 2);
        this.npc.bossInfo.method_14091(this.showBossBar == 1);
        this.npc.updateClient = true;
    }

    @Override
    public int getBossColor() {
        return this.bossColor.ordinal();
    }

    @Override
    public void setBossColor(int color) {
        if (color < 0 || color >= class_1259.class_1260.values().length) {
            throw new CustomNPCsException("Invalid Boss Color: " + color, new Object[0]);
        }
        this.bossColor = class_1259.class_1260.values()[color];
        this.npc.bossInfo.method_5416(this.bossColor);
    }

    @Override
    public int getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(int type) {
        if (type == this.visible) {
            return;
        }
        this.visible = ValueUtil.CorrectInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    @Override
    public int getSize() {
        return this.modelSize;
    }

    @Override
    public void setSize(int size) {
        if (this.modelSize == size) {
            return;
        }
        this.modelSize = ValueUtil.CorrectInt(size, 1, 30);
        this.npc.updateClient = true;
    }

    @Override
    public void setModelScale(int part, float x, float y, float z) {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        ModelPartConfig model = null;
        if (part == 0) {
            model = modeldata.getPartConfig(EnumParts.HEAD);
        } else if (part == 1) {
            model = modeldata.getPartConfig(EnumParts.BODY);
        } else if (part == 2) {
            model = modeldata.getPartConfig(EnumParts.ARM_LEFT);
        } else if (part == 3) {
            model = modeldata.getPartConfig(EnumParts.ARM_RIGHT);
        } else if (part == 4) {
            model = modeldata.getPartConfig(EnumParts.LEG_LEFT);
        } else if (part == 5) {
            model = modeldata.getPartConfig(EnumParts.LEG_RIGHT);
        }
        if (model == null) {
            throw new CustomNPCsException("Unknown part: " + part, new Object[0]);
        }
        model.setScale(x, y, z);
        this.npc.updateClient = true;
    }

    @Override
    public float[] getModelScale(int part) {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        ModelPartConfig model = null;
        if (part == 0) {
            model = modeldata.getPartConfig(EnumParts.HEAD);
        } else if (part == 1) {
            model = modeldata.getPartConfig(EnumParts.BODY);
        } else if (part == 2) {
            model = modeldata.getPartConfig(EnumParts.ARM_LEFT);
        } else if (part == 3) {
            model = modeldata.getPartConfig(EnumParts.ARM_RIGHT);
        } else if (part == 4) {
            model = modeldata.getPartConfig(EnumParts.LEG_LEFT);
        } else if (part == 5) {
            model = modeldata.getPartConfig(EnumParts.LEG_RIGHT);
        }
        if (model == null) {
            throw new CustomNPCsException("Unknown part: " + part, new Object[0]);
        }
        return new float[]{model.scaleX, model.scaleY, model.scaleZ};
    }

    @Override
    public int getTint() {
        return this.skinColor;
    }

    @Override
    public void setTint(int color) {
        if (color == this.skinColor) {
            return;
        }
        this.skinColor = color;
        this.npc.updateClient = true;
    }

    @Override
    public void setModel(String id) {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        if (id == null) {
            if (modeldata.getEntityName() == null) {
                return;
            }
            modeldata.setEntity(null);
            this.npc.updateClient = true;
        } else {
            class_2960 resource = new class_2960(id);
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(resource);
            if (type == null) {
                throw new CustomNPCsException("Unknown entity id: " + id, new Object[0]);
            }
            modeldata.setEntity(resource);
            this.npc.updateClient = true;
        }
    }

    @Override
    public String getModel() {
        ModelData modeldata = ((EntityCustomNpc)this.npc).modelData;
        if (modeldata.getEntityName() == null) {
            return null;
        }
        return modeldata.getEntityName().toString();
    }

    @Override
    public byte getHitboxState() {
        return this.hitboxState;
    }

    @Override
    public void setHitboxState(byte state) {
        if (this.hitboxState == state) {
            return;
        }
        this.hitboxState = state;
        this.npc.updateClient = true;
    }

    @Override
    public boolean isVisibleTo(IPlayer player) {
        return this.isVisibleTo(player);
    }

    public boolean isVisibleTo(class_3222 player) {
        if (this.visible == 1) {
            return !this.availability.isAvailable((class_1657)player);
        }
        return this.availability.isAvailable((class_1657)player);
    }
}

