/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.INPCInventory;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class DataInventory
extends class_1277
implements INPCInventory {
    public Map<Integer, IItemStack> drops = new HashMap<Integer, IItemStack>();
    public Map<Integer, Float> dropchance = new HashMap<Integer, Float>();
    public Map<Integer, IItemStack> weapons = new HashMap<Integer, IItemStack>();
    public Map<Integer, IItemStack> armor = new HashMap<Integer, IItemStack>();
    private int minExp = 0;
    private int maxExp = 0;
    public int lootMode = 0;
    private EntityNPCInterface npc;

    public DataInventory(EntityNPCInterface npc) {
        super(new class_1799[0]);
        this.npc = npc;
    }

    public class_2487 save(class_2487 nbttagcompound) {
        nbttagcompound.method_10569("MinExp", this.minExp);
        nbttagcompound.method_10569("MaxExp", this.maxExp);
        nbttagcompound.method_10566("NpcInv", (class_2520)NBTTags.nbtIItemStackMap(this.drops));
        nbttagcompound.method_10566("Armor", (class_2520)NBTTags.nbtIItemStackMap(this.armor));
        nbttagcompound.method_10566("Weapons", (class_2520)NBTTags.nbtIItemStackMap(this.weapons));
        nbttagcompound.method_10566("DropChance", (class_2520)NBTTags.nbtFloatMap(this.dropchance));
        nbttagcompound.method_10569("LootMode", this.lootMode);
        return nbttagcompound;
    }

    public void load(class_2487 nbttagcompound) {
        this.minExp = nbttagcompound.method_10550("MinExp");
        this.maxExp = nbttagcompound.method_10550("MaxExp");
        this.drops = NBTTags.getIItemStackMap(nbttagcompound.method_10554("NpcInv", 10));
        this.armor = NBTTags.getIItemStackMap(nbttagcompound.method_10554("Armor", 10));
        this.weapons = NBTTags.getIItemStackMap(nbttagcompound.method_10554("Weapons", 10));
        this.dropchance = NBTTags.getFloatIntegerMap(nbttagcompound.method_10554("DropChance", 10));
        this.lootMode = nbttagcompound.method_10550("LootMode");
    }

    @Override
    public IItemStack getArmor(int slot) {
        return this.armor.get(slot);
    }

    @Override
    public void setArmor(int slot, IItemStack item) {
        this.armor.put(slot, item);
        this.npc.updateClient = true;
    }

    @Override
    public IItemStack getRightHand() {
        return this.weapons.get(0);
    }

    @Override
    public void setRightHand(IItemStack item) {
        this.weapons.put(0, item);
        this.npc.updateClient = true;
    }

    @Override
    public IItemStack getProjectile() {
        return this.weapons.get(1);
    }

    @Override
    public void setProjectile(IItemStack item) {
        this.weapons.put(1, item);
        this.npc.updateAI = true;
    }

    @Override
    public IItemStack getLeftHand() {
        return this.weapons.get(2);
    }

    @Override
    public void setLeftHand(IItemStack item) {
        this.weapons.put(2, item);
        this.npc.updateClient = true;
    }

    @Override
    public IItemStack getDropItem(int slot) {
        if (slot < 0 || slot > 20) {
            throw new CustomNPCsException("Bad slot number: " + slot, new Object[0]);
        }
        IItemStack item = this.npc.inventory.drops.get(slot);
        if (item == null) {
            return ItemStackWrapper.AIR;
        }
        return NpcAPI.Instance().getIItemStack(item.getMCItemStack());
    }

    @Override
    public void setDropItem(int slot, IItemStack item, float chance) {
        if (slot < 0 || slot > 20) {
            throw new CustomNPCsException("Bad slot number: " + slot, new Object[0]);
        }
        chance = ValueUtil.correctFloat(chance, 1.0f, 100.0f);
        if (item == null || item.isEmpty()) {
            this.dropchance.remove(slot);
            this.drops.remove(slot);
        } else {
            this.dropchance.put(slot, Float.valueOf(chance));
            this.drops.put(slot, item);
        }
    }

    @Override
    public IItemStack[] getItemsRNG() {
        ArrayList<IItemStack> list = new ArrayList<IItemStack>();
        for (int i : this.drops.keySet()) {
            float chance;
            IItemStack item = this.drops.get(i);
            if (item == null || item.isEmpty()) continue;
            float dchance = 100.0f;
            if (this.dropchance.containsKey(i)) {
                dchance = this.dropchance.get(i).floatValue();
            }
            if (!((chance = (float)this.npc.method_37908().field_9229.method_43048(100) + dchance) >= 100.0f)) continue;
            list.add(item);
        }
        return list.toArray(new IItemStack[list.size()]);
    }

    public void dropStuff(NpcEvent.DiedEvent event, class_1297 entity, class_1282 damagesource) {
        int var2;
        ArrayList<class_1542> list = new ArrayList<class_1542>();
        if (event.droppedItems != null) {
            for (IItemStack item : event.droppedItems) {
                class_1542 e = this.getItemEntity(item.getMCItemStack().method_7972());
                if (e == null) continue;
                list.add(e);
            }
        }
        int enchant = 0;
        if (damagesource.method_5529() instanceof class_1657) {
            enchant = class_1890.method_8226((class_1309)((class_1309)damagesource.method_5529()));
        }
        for (class_1542 item : list) {
            if (this.lootMode == 1 && entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                item.method_6982(2);
                this.npc.method_37908().method_8649((class_1297)item);
                class_1799 stack = item.method_6983();
                int i = stack.method_7947();
                if (!player.method_31548().method_7394(stack)) continue;
                entity.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_6051().method_43057() - player.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
                player.method_6103((class_1297)item, i);
                if (stack.method_7947() > 0) continue;
                item.method_5650(class_1297.class_5529.field_26999);
                continue;
            }
            this.npc.method_37908().method_8649((class_1297)item);
        }
        for (int exp = event.expDropped; exp > 0; exp -= var2) {
            var2 = class_1303.method_5918((int)exp);
            if (this.lootMode == 1 && entity instanceof class_1657) {
                this.npc.method_37908().method_8649((class_1297)new class_1303(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), var2));
                continue;
            }
            this.npc.method_37908().method_8649((class_1297)new class_1303(this.npc.method_37908(), this.npc.method_23317(), this.npc.method_23318(), this.npc.method_23321(), var2));
        }
    }

    public class_1542 getItemEntity(class_1799 itemstack) {
        if (itemstack == null || itemstack.method_7960()) {
            return null;
        }
        class_1542 entityitem = new class_1542(this.npc.method_37908(), this.npc.method_23317(), this.npc.method_23318() - (double)0.3f + (double)this.npc.method_5751(), this.npc.method_23321(), itemstack);
        entityitem.method_6982(40);
        float f2 = this.npc.method_6051().method_43057() * 0.5f;
        float f4 = this.npc.method_6051().method_43057() * 3.141593f * 2.0f;
        entityitem.method_18800((double)(-class_3532.method_15374((float)f4) * f2), (double)0.2f, (double)(class_3532.method_15362((float)f4) * f2));
        return entityitem;
    }

    public int method_5439() {
        return 15;
    }

    public class_1799 method_5438(int i) {
        if (i < 4) {
            return ItemStackWrapper.MCItem(this.getArmor(i));
        }
        if (i < 7) {
            return ItemStackWrapper.MCItem(this.weapons.get(i - 4));
        }
        return ItemStackWrapper.MCItem(this.drops.get(i - 7));
    }

    public class_1799 method_5434(int par1, int limbSwingAmount) {
        Map<Integer, IItemStack> var3;
        int i = 0;
        if (par1 >= 7) {
            var3 = this.drops;
            par1 -= 7;
        } else if (par1 >= 4) {
            var3 = this.weapons;
            par1 -= 4;
            i = 1;
        } else {
            var3 = this.armor;
            i = 2;
        }
        class_1799 var4 = null;
        if (var3.get(par1) != null) {
            if (var3.get(par1).getMCItemStack().method_7947() <= limbSwingAmount) {
                var4 = var3.get(par1).getMCItemStack();
                var3.put(par1, null);
            } else {
                var4 = var3.get(par1).getMCItemStack().method_7971(limbSwingAmount);
                if (var3.get(par1).getMCItemStack().method_7947() == 0) {
                    var3.put(par1, null);
                }
            }
        }
        if (i == 1) {
            this.weapons = var3;
        }
        if (i == 2) {
            this.armor = var3;
        }
        if (var4 == null) {
            return class_1799.field_8037;
        }
        return var4;
    }

    public class_1799 method_5441(int par1) {
        Map<Integer, IItemStack> var2;
        int i = 0;
        if (par1 >= 7) {
            var2 = this.drops;
            par1 -= 7;
        } else if (par1 >= 4) {
            var2 = this.weapons;
            par1 -= 4;
            i = 1;
        } else {
            var2 = this.armor;
            i = 2;
        }
        if (var2.get(par1) != null) {
            class_1799 var3 = var2.get(par1).getMCItemStack();
            var2.put(par1, null);
            if (i == 1) {
                this.weapons = var2;
            }
            if (i == 2) {
                this.armor = var2;
            }
            return var3;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int par1, class_1799 limbSwingAmountItemStack) {
        Map<Integer, IItemStack> var3;
        int i = 0;
        if (par1 >= 7) {
            var3 = this.drops;
            par1 -= 7;
        } else if (par1 >= 4) {
            var3 = this.weapons;
            par1 -= 4;
            i = 1;
        } else {
            var3 = this.armor;
            i = 2;
        }
        var3.put(par1, NpcAPI.Instance().getIItemStack(limbSwingAmountItemStack));
        if (i == 1) {
            this.weapons = var3;
        }
        if (i == 2) {
            this.armor = var3;
        }
    }

    public int method_5444() {
        return 64;
    }

    public boolean method_5443(class_1657 var1) {
        return true;
    }

    public boolean method_5437(int i, class_1799 itemstack) {
        return true;
    }

    public void method_5431() {
    }

    public void method_5435(class_1657 player) {
    }

    public void method_5432(class_1657 player) {
    }

    @Override
    public int getExpMin() {
        return this.npc.inventory.minExp;
    }

    @Override
    public int getExpMax() {
        return this.npc.inventory.maxExp;
    }

    @Override
    public int getExpRNG() {
        int exp = this.minExp;
        if (this.maxExp - this.minExp > 0) {
            exp += this.npc.method_37908().field_9229.method_43048(this.maxExp - this.minExp);
        }
        return exp;
    }

    @Override
    public void setExp(int min, int max) {
        this.npc.inventory.minExp = min = Math.min(min, max);
        this.npc.inventory.maxExp = max;
    }

    public boolean method_5442() {
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 item = this.method_5438(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void method_5448() {
    }
}

