/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.AnimationType;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.shared.common.CommonUtil;
import noppes.npcs.util.ValueUtil;

public class DataScenes {
    private EntityNPCInterface npc;
    public List<SceneContainer> scenes = new ArrayList<SceneContainer>();
    public static Map<String, SceneState> StartedScenes = new HashMap<String, SceneState>();
    public static List<SceneContainer> ScenesToRun = new ArrayList<SceneContainer>();
    private class_1309 owner = null;
    private String ownerScene = null;

    public DataScenes(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public class_2487 save(class_2487 compound) {
        class_2499 list = new class_2499();
        for (SceneContainer scene : this.scenes) {
            list.add((Object)scene.save(new class_2487()));
        }
        compound.method_10566("Scenes", (class_2520)list);
        return compound;
    }

    public void load(class_2487 compound) {
        class_2499 list = compound.method_10554("Scenes", 10);
        ArrayList<SceneContainer> scenes = new ArrayList<SceneContainer>();
        for (int i = 0; i < list.size(); ++i) {
            SceneContainer scene = new SceneContainer();
            scene.load(list.method_10602(i));
            scenes.add(scene);
        }
        this.scenes = scenes;
    }

    public class_1309 getOwner() {
        return this.owner;
    }

    public static void Toggle(MinecraftServer server, String id) {
        SceneState state = StartedScenes.get(id.toLowerCase());
        if (state == null || state.paused) {
            DataScenes.Start(server, id);
        } else {
            state.paused = true;
            CommonUtil.NotifyOPs(server, "Paused scene %s at %s", id, state.ticks);
        }
    }

    public static void Start(MinecraftServer server, String id) {
        SceneState state = StartedScenes.get(id.toLowerCase());
        if (state == null) {
            CommonUtil.NotifyOPs(server, "Started scene %s", id);
            StartedScenes.put(id.toLowerCase(), new SceneState());
        } else if (state.paused) {
            state.paused = false;
            CommonUtil.NotifyOPs(server, "Started scene %s from %s", id, state.ticks);
        }
    }

    public static void Pause(class_2168 sender, String id) {
        if (id == null) {
            for (SceneState state : StartedScenes.values()) {
                state.paused = true;
            }
            CommonUtil.NotifyOPs(sender.method_9211(), "Paused all scenes", new Object[0]);
        } else {
            SceneState state = StartedScenes.get(id.toLowerCase());
            if (state == null) {
                sender.method_9226(() -> class_2561.method_43469((String)"Unknown scene %s ", (Object[])new Object[]{id}), false);
            } else {
                state.paused = true;
                CommonUtil.NotifyOPs(sender.method_9211(), "Paused scene %s at %s", id, state.ticks);
            }
        }
    }

    public static void Reset(class_2168 sender, String id) {
        if (id == null) {
            if (StartedScenes.isEmpty()) {
                return;
            }
            StartedScenes = new HashMap<String, SceneState>();
            CommonUtil.NotifyOPs(sender.method_9211(), "Reset all scene", new Object[0]);
        } else if (StartedScenes.remove(id.toLowerCase()) == null) {
            sender.method_9226(() -> class_2561.method_43469((String)"Unknown scene %s ", (Object[])new Object[]{id}), false);
        } else {
            CommonUtil.NotifyOPs(sender.method_9211(), "Reset scene %s", id);
        }
    }

    public void update() {
        for (SceneContainer scene : this.scenes) {
            if (!scene.validState()) continue;
            ScenesToRun.add(scene);
        }
        if (this.owner != null && !StartedScenes.containsKey(this.ownerScene.toLowerCase())) {
            this.owner = null;
            this.ownerScene = null;
        }
    }

    public void addScene(String name) {
        if (name.isEmpty()) {
            return;
        }
        SceneContainer scene = new SceneContainer();
        scene.name = name;
        this.scenes.add(scene);
    }

    public class SceneContainer {
        public int btn = 0;
        public String name = "";
        public String lines = "";
        public boolean enabled = false;
        public int ticks = -1;
        private SceneState state = null;
        private List<SceneEvent> events = new ArrayList<SceneEvent>();

        public class_2487 save(class_2487 compound) {
            compound.method_10556("Enabled", this.enabled);
            compound.method_10582("Name", this.name);
            compound.method_10582("Lines", this.lines);
            compound.method_10569("Button", this.btn);
            compound.method_10569("Ticks", this.ticks);
            return compound;
        }

        public boolean validState() {
            if (!this.enabled) {
                return false;
            }
            if (this.state != null) {
                if (StartedScenes.containsValue(this.state)) {
                    return !this.state.paused;
                }
                this.state = null;
            }
            this.state = StartedScenes.get(this.name.toLowerCase());
            if (this.state == null) {
                this.state = StartedScenes.get(this.btn + "btn");
            }
            if (this.state != null) {
                return !this.state.paused;
            }
            return false;
        }

        public void load(class_2487 compound) {
            this.enabled = compound.method_10577("Enabled");
            this.name = compound.method_10558("Name");
            this.lines = compound.method_10558("Lines");
            this.btn = compound.method_10550("Button");
            this.ticks = compound.method_10550("Ticks");
            ArrayList<SceneEvent> events = new ArrayList<SceneEvent>();
            for (String line : this.lines.split("\r\n|\r|\n")) {
                SceneEvent event = SceneEvent.parse(line);
                if (event == null) continue;
                events.add(event);
            }
            Collections.sort(events);
            this.events = events;
        }

        public void update() {
            if (!this.enabled || this.events.isEmpty() || this.state == null) {
                return;
            }
            for (SceneEvent event : this.events) {
                if (event.ticks > this.state.ticks) break;
                if (event.ticks != this.state.ticks) continue;
                try {
                    this.handle(event);
                }
                catch (Exception exception) {}
            }
            this.ticks = this.state.ticks;
        }

        private class_1309 getEntity(String name) {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (class_1297 entity : DataScenes.this.npc.method_5770().method_31592().method_31803()) {
                if (!(entity instanceof class_1309)) continue;
                if (uuid != null && entity.method_5667() == uuid) {
                    return (class_1309)entity;
                }
                if (!name.equalsIgnoreCase(entity.method_5477().getString())) continue;
                return (class_1309)entity;
            }
            return null;
        }

        private class_2338 parseBlockPos(class_2338 blockpos, String[] args, int startIndex, boolean centerBlock) throws Exception {
            return new class_2338((int)this.parseDouble(blockpos.method_10263(), args[startIndex], -30000000, 30000000, centerBlock), (int)this.parseDouble(blockpos.method_10264(), args[startIndex + 1], -64, 319, false), (int)this.parseDouble(blockpos.method_10260(), args[startIndex + 2], -30000000, 30000000, centerBlock));
        }

        private double parseDouble(double base, String input, int min, int max, boolean centerBlock) throws Exception {
            double d0;
            boolean flag = input.startsWith("~");
            if (flag && Double.isNaN(base)) {
                throw new Exception("invalid number");
            }
            double d = d0 = flag ? base : 0.0;
            if (!flag || input.length() > 1) {
                boolean flag1 = input.contains(".");
                if (flag) {
                    input = input.substring(1);
                }
                d0 += Double.parseDouble(input);
                if (!flag1 && !flag && centerBlock) {
                    d0 += 0.5;
                }
            }
            if (min != 0 || max != 0) {
                if (d0 < (double)min) {
                    throw new Exception("number too small");
                }
                if (d0 > (double)max) {
                    throw new Exception("number too big");
                }
            }
            return d0;
        }

        private void handle(SceneEvent event) throws Exception {
            block64: {
                if (event.type == SceneType.MOVE) {
                    String[] param = event.param.split(" ");
                    while (param.length > 1) {
                        boolean move = false;
                        if (param[0].startsWith("to")) {
                            move = true;
                        } else if (!param[0].startsWith("tp")) break;
                        class_2338 pos = null;
                        if (param[0].startsWith("@")) {
                            class_1309 entitylivingbase = this.getEntity(param[0]);
                            if (entitylivingbase != null) {
                                pos = entitylivingbase.method_24515();
                            }
                            param = Arrays.copyOfRange(param, 2, param.length);
                        } else {
                            if (param.length < 4) {
                                return;
                            }
                            pos = this.parseBlockPos(DataScenes.this.npc.method_24515(), param, 1, false);
                            param = Arrays.copyOfRange(param, 4, param.length);
                        }
                        if (pos == null) continue;
                        DataScenes.this.npc.ais.setStartPos(pos);
                        DataScenes.this.npc.method_5942().method_6340();
                        if (move) {
                            class_11 pathentity = DataScenes.this.npc.method_5942().method_6348(pos, 0);
                            DataScenes.this.npc.method_5942().method_6334(pathentity, 1.0);
                            continue;
                        }
                        if (DataScenes.this.npc.isInRange((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, 2.0)) continue;
                        DataScenes.this.npc.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                    }
                } else if (event.type == SceneType.SAY) {
                    DataScenes.this.npc.saySurrounding(new Line(event.param));
                } else if (event.type == SceneType.ROTATE) {
                    if (event.param.startsWith("@")) {
                        class_1309 entitylivingbase = this.getEntity(event.param);
                        DataScenes.this.npc.lookAi.rotate((class_1297)DataScenes.this.npc.method_37908().method_18460((class_1297)entitylivingbase, 30.0));
                    } else if (event.param.equals("clear")) {
                        DataScenes.this.npc.lookAi.method_6270();
                    } else {
                        DataScenes.this.npc.lookAi.rotate(Integer.parseInt(event.param));
                    }
                } else if (event.type == SceneType.EQUIP) {
                    String[] args = event.param.split(" ");
                    if (args.length < 2) {
                        return;
                    }
                    IItemStack itemstack = null;
                    if (!args[1].equalsIgnoreCase("none")) {
                        class_2960 resourcelocation = new class_2960(args[1]);
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(resourcelocation);
                        int i = args.length >= 3 ? ValueUtil.CorrectInt(Integer.parseInt(args[2]), 1, 64) : 1;
                        itemstack = NpcAPI.Instance().getIItemStack(new class_1799((class_1935)item, i));
                    }
                    if (args[0].equalsIgnoreCase("main")) {
                        DataScenes.this.npc.inventory.weapons.put(0, itemstack);
                    } else if (args[0].equalsIgnoreCase("off")) {
                        DataScenes.this.npc.inventory.weapons.put(2, itemstack);
                    } else if (args[0].equalsIgnoreCase("proj")) {
                        DataScenes.this.npc.inventory.weapons.put(1, itemstack);
                    } else if (args[0].equalsIgnoreCase("head")) {
                        DataScenes.this.npc.inventory.armor.put(0, itemstack);
                    } else if (args[0].equalsIgnoreCase("body")) {
                        DataScenes.this.npc.inventory.armor.put(1, itemstack);
                    } else if (args[0].equalsIgnoreCase("legs")) {
                        DataScenes.this.npc.inventory.armor.put(2, itemstack);
                    } else if (args[0].equalsIgnoreCase("boots")) {
                        DataScenes.this.npc.inventory.armor.put(3, itemstack);
                    }
                } else if (event.type == SceneType.ATTACK) {
                    if (event.param.equals("none")) {
                        DataScenes.this.npc.method_5980(null);
                    } else {
                        class_1309 entity = this.getEntity(event.param);
                        if (entity != null) {
                            DataScenes.this.npc.method_5980(entity);
                        }
                    }
                } else if (event.type == SceneType.THROW) {
                    String[] args = event.param.split(" ");
                    class_1309 entity = this.getEntity(args[0]);
                    if (entity == null) {
                        return;
                    }
                    float damage = Float.parseFloat(args[1]);
                    if (damage <= 0.0f) {
                        damage = 0.01f;
                    }
                    class_1799 stack = ItemStackWrapper.MCItem(DataScenes.this.npc.inventory.getProjectile());
                    if (args.length > 2) {
                        class_2960 resourcelocation = new class_2960(args[2]);
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(resourcelocation);
                        stack = new class_1799((class_1935)item, 1);
                    }
                    EntityProjectile projectile = DataScenes.this.npc.shoot(entity, 100, stack, false);
                    projectile.damage = damage;
                } else if (event.type == SceneType.ANIMATE) {
                    DataScenes.this.npc.animateAi.temp = AnimationType.valueOf(event.param);
                } else if (event.type == SceneType.COMMAND) {
                    NoppesUtilServer.runCommand((class_1297)DataScenes.this.npc, DataScenes.this.npc.method_5477().getString(), event.param, null);
                } else if (event.type == SceneType.STATS) {
                    int i = event.param.indexOf(" ");
                    if (i <= 0) {
                        return;
                    }
                    String type = event.param.substring(0, i).toLowerCase();
                    String value = event.param.substring(i).trim();
                    try {
                        if (type.equals("walking_speed")) {
                            DataScenes.this.npc.ais.setWalkingSpeed(ValueUtil.CorrectInt(Integer.parseInt(value), 0, 10));
                            break block64;
                        }
                        if (type.equals("size")) {
                            DataScenes.this.npc.display.setSize(ValueUtil.CorrectInt(Integer.parseInt(value), 1, 30));
                            break block64;
                        }
                        CommonUtil.NotifyOPs(DataScenes.this.npc.method_37908().method_8503(), "Unknown scene stat: " + type, new Object[0]);
                    }
                    catch (NumberFormatException e) {
                        CommonUtil.NotifyOPs(DataScenes.this.npc.method_37908().method_8503(), "Unknown scene stat " + type + " value: " + value, new Object[0]);
                    }
                } else if (event.type == SceneType.FACTION) {
                    DataScenes.this.npc.setFaction(Integer.parseInt(event.param));
                } else if (event.type == SceneType.FOLLOW) {
                    if (event.param.equalsIgnoreCase("none")) {
                        DataScenes.this.owner = null;
                        DataScenes.this.ownerScene = null;
                    } else {
                        class_1309 entity = this.getEntity(event.param);
                        if (entity == null) {
                            return;
                        }
                        DataScenes.this.owner = entity;
                        DataScenes.this.ownerScene = this.name;
                    }
                }
            }
        }
    }

    public static class SceneState {
        public boolean paused = false;
        public int ticks = -1;
    }

    public static enum SceneType {
        ANIMATE,
        MOVE,
        FACTION,
        COMMAND,
        EQUIP,
        THROW,
        ATTACK,
        FOLLOW,
        SAY,
        ROTATE,
        STATS;

    }

    public static class SceneEvent
    implements Comparable<SceneEvent> {
        public int ticks = 0;
        public SceneType type;
        public String param = "";

        public String toString() {
            return this.ticks + " " + this.type.name() + " " + this.param;
        }

        public static SceneEvent parse(String str) {
            SceneEvent event = new SceneEvent();
            int i = str.indexOf(" ");
            if (i <= 0) {
                return null;
            }
            try {
                event.ticks = Integer.parseInt(str.substring(0, i));
                str = str.substring(i + 1);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            i = str.indexOf(" ");
            if (i <= 0) {
                return null;
            }
            String name = str.substring(0, i);
            for (SceneType type : SceneType.values()) {
                if (!name.equalsIgnoreCase(type.name())) continue;
                event.type = type;
            }
            if (event.type == null) {
                return null;
            }
            event.param = str.substring(i + 1);
            return event;
        }

        @Override
        public int compareTo(SceneEvent o) {
            return this.ticks - o.ticks;
        }
    }
}

