/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import net.minecraft.class_1310;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5134;
import noppes.npcs.Resistances;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.data.INPCMelee;
import noppes.npcs.api.entity.data.INPCRanged;
import noppes.npcs.api.entity.data.INPCStats;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataMelee;
import noppes.npcs.entity.data.DataRanged;
import noppes.npcs.util.ValueUtil;

public class DataStats
implements INPCStats {
    public int aggroRange = 16;
    public int maxHealth = 20;
    public int respawnTime = 20;
    public int spawnCycle = 0;
    public boolean hideKilledBody = false;
    public Resistances resistances = new Resistances();
    public boolean immuneToFire = false;
    public boolean potionImmune = false;
    public boolean canDrown = true;
    public boolean burnInSun = false;
    public boolean noFallDamage = false;
    public boolean ignoreCobweb = false;
    public int healthRegen = 1;
    public int combatRegen = 0;
    public class_1310 creatureType = class_1310.field_6290;
    public DataMelee melee;
    public DataRanged ranged;
    private EntityNPCInterface npc;

    public DataStats(EntityNPCInterface npc) {
        this.npc = npc;
        this.melee = new DataMelee(npc);
        this.ranged = new DataRanged(npc);
    }

    public void readToNBT(class_2487 compound) {
        this.resistances.readToNBT(compound.method_10562("Resistances"));
        this.setMaxHealth(compound.method_10550("MaxHealth"));
        this.hideKilledBody = compound.method_10577("HideBodyWhenKilled");
        this.aggroRange = compound.method_10550("AggroRange");
        this.respawnTime = compound.method_10550("RespawnTime");
        this.spawnCycle = compound.method_10550("SpawnCycle");
        this.setCreatureType(compound.method_10550("CreatureType"));
        this.healthRegen = compound.method_10550("HealthRegen");
        this.combatRegen = compound.method_10550("CombatRegen");
        this.immuneToFire = compound.method_10577("ImmuneToFire");
        this.potionImmune = compound.method_10577("PotionImmune");
        this.canDrown = compound.method_10577("CanDrown");
        this.burnInSun = compound.method_10577("BurnInSun");
        this.noFallDamage = compound.method_10577("NoFallDamage");
        this.npc.setImmuneToFire(this.immuneToFire);
        this.ignoreCobweb = compound.method_10577("IgnoreCobweb");
        this.melee.load(compound);
        this.ranged.load(compound);
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10566("Resistances", (class_2520)this.resistances.save());
        compound.method_10569("MaxHealth", this.maxHealth);
        compound.method_10569("AggroRange", this.aggroRange);
        compound.method_10556("HideBodyWhenKilled", this.hideKilledBody);
        compound.method_10569("RespawnTime", this.respawnTime);
        compound.method_10569("SpawnCycle", this.spawnCycle);
        compound.method_10569("CreatureType", this.getCreatureType());
        compound.method_10569("HealthRegen", this.healthRegen);
        compound.method_10569("CombatRegen", this.combatRegen);
        compound.method_10556("ImmuneToFire", this.immuneToFire);
        compound.method_10556("PotionImmune", this.potionImmune);
        compound.method_10556("CanDrown", this.canDrown);
        compound.method_10556("BurnInSun", this.burnInSun);
        compound.method_10556("NoFallDamage", this.noFallDamage);
        compound.method_10556("IgnoreCobweb", this.ignoreCobweb);
        this.melee.save(compound);
        this.ranged.save(compound);
        return compound;
    }

    @Override
    public void setMaxHealth(int maxHealth) {
        if (maxHealth == this.maxHealth) {
            return;
        }
        this.maxHealth = maxHealth;
        this.npc.method_5996(class_5134.field_23716).method_6192((double)maxHealth);
        this.npc.updateClient = true;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getResistance(int type) {
        if (type == 0) {
            return this.resistances.melee;
        }
        if (type == 1) {
            return this.resistances.arrow;
        }
        if (type == 2) {
            return this.resistances.explosion;
        }
        if (type == 3) {
            return this.resistances.knockback;
        }
        return 1.0f;
    }

    @Override
    public void setResistance(int type, float value) {
        value = ValueUtil.correctFloat(value, 0.0f, 2.0f);
        if (type == 0) {
            this.resistances.melee = value;
        } else if (type == 1) {
            this.resistances.arrow = value;
        } else if (type == 2) {
            this.resistances.explosion = value;
        } else if (type == 3) {
            this.resistances.knockback = value;
        }
    }

    @Override
    public int getCombatRegen() {
        return this.combatRegen;
    }

    @Override
    public void setCombatRegen(int regen) {
        this.combatRegen = regen;
    }

    @Override
    public int getHealthRegen() {
        return this.healthRegen;
    }

    @Override
    public void setHealthRegen(int regen) {
        this.healthRegen = regen;
    }

    @Override
    public INPCMelee getMelee() {
        return this.melee;
    }

    @Override
    public INPCRanged getRanged() {
        return this.ranged;
    }

    @Override
    public boolean getImmune(int type) {
        if (type == 0) {
            return this.potionImmune;
        }
        if (type == 1) {
            return !this.noFallDamage;
        }
        if (type == 2) {
            return this.burnInSun;
        }
        if (type == 3) {
            return this.immuneToFire;
        }
        if (type == 4) {
            return !this.canDrown;
        }
        if (type == 5) {
            return this.ignoreCobweb;
        }
        throw new CustomNPCsException("Unknown immune type: " + type, new Object[0]);
    }

    @Override
    public void setImmune(int type, boolean bo) {
        if (type == 0) {
            this.potionImmune = bo;
        } else if (type == 1) {
            this.noFallDamage = !bo;
        } else if (type == 2) {
            this.burnInSun = bo;
        } else if (type == 3) {
            this.npc.setImmuneToFire(bo);
        } else if (type == 4) {
            this.canDrown = !bo;
        } else if (type == 5) {
            this.ignoreCobweb = bo;
        } else {
            throw new CustomNPCsException("Unknown immune type: " + type, new Object[0]);
        }
    }

    @Override
    public int getCreatureType() {
        if (this.creatureType == class_1310.field_6289) {
            return 1;
        }
        if (this.creatureType == class_1310.field_6293) {
            return 2;
        }
        if (this.creatureType == class_1310.field_6291) {
            return 3;
        }
        if (this.creatureType == class_1310.field_6292) {
            return 4;
        }
        return 0;
    }

    @Override
    public void setCreatureType(int type) {
        this.creatureType = type == 1 ? class_1310.field_6289 : (type == 2 ? class_1310.field_6293 : (type == 3 ? class_1310.field_6291 : (type == 4 ? class_1310.field_6292 : class_1310.field_6290)));
    }

    @Override
    public int getRespawnType() {
        return this.spawnCycle;
    }

    @Override
    public void setRespawnType(int type) {
        this.spawnCycle = type;
    }

    @Override
    public int getRespawnTime() {
        return this.respawnTime;
    }

    @Override
    public void setRespawnTime(int seconds) {
        this.respawnTime = seconds;
    }

    @Override
    public boolean getHideDeadBody() {
        return this.hideKilledBody;
    }

    @Override
    public void setHideDeadBody(boolean hide) {
        this.hideKilledBody = hide;
        this.npc.updateClient = true;
    }

    @Override
    public int getAggroRange() {
        return this.aggroRange;
    }

    @Override
    public void setAggroRange(int range) {
        this.aggroRange = range;
        this.npc.method_18408(this.npc.ais.startPos(), this.aggroRange * 2);
    }
}

