/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.entity.EntityNPCInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PacketServerBasic {
    private static final Logger LOGGER = LogManager.getLogger();
    public class_3222 player;
    public EntityNPCInterface npc;

    public boolean requiresNpc() {
        return false;
    }

    public PermissionNode<Boolean> getPermission() {
        return null;
    }

    public boolean toolAllowed(class_1799 item) {
        return item.method_7909() == CustomItems.wand;
    }

    public static void handle(PacketServerBasic msg, MinecraftServer server, class_3222 player) {
        server.execute(() -> {
            msg.player = player;
            msg.npc = NoppesUtilServer.getEditingNpc((class_1657)msg.player);
            if (msg.requiresNpc() && msg.npc == null) {
                return;
            }
            if (msg.getPermission() != null && !CustomNpcsPermissions.hasPermission(msg.player, msg.getPermission())) {
                return;
            }
            if (!msg.toolAllowed(msg.player.method_31548().method_7391())) {
                msg.warn("tried to use custom npcs without a tool in hand, possibly a hacker");
                return;
            }
            msg.handle();
        });
    }

    private void warn(String warning) {
        LOGGER.warn(this.player.method_5477().getString() + ": " + warning + " - " + String.valueOf(this));
    }

    protected abstract void handle();
}

