/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.util.ArrayList;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.QuestEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.EntityIMixin;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketQuestCompletionCheck
extends PacketServerBasic {
    private final int questId;

    public SPacketQuestCompletionCheck(int questId) {
        this.questId = questId;
    }

    @Override
    public boolean toolAllowed(class_1799 item) {
        return true;
    }

    public static void encode(SPacketQuestCompletionCheck msg, class_2540 buf) {
        buf.writeInt(msg.questId);
    }

    public static SPacketQuestCompletionCheck decode(class_2540 buf) {
        return new SPacketQuestCompletionCheck(buf.readInt());
    }

    @Override
    protected void handle() {
        PlayerData data = PlayerData.get((class_1657)this.player);
        PlayerQuestData playerdata = data.questData;
        QuestData questdata = playerdata.activeQuests.get(this.questId);
        if (questdata == null) {
            return;
        }
        Quest quest = questdata.quest;
        if (!quest.questInterface.isCompleted((class_1657)this.player)) {
            return;
        }
        QuestEvent.QuestTurnedInEvent event = new QuestEvent.QuestTurnedInEvent(data.scriptData.getPlayer(), quest);
        event.expReward = quest.rewardExp;
        ArrayList<IItemStack> list = new ArrayList<IItemStack>();
        for (class_1799 item : quest.rewardItems.items) {
            if (item.method_7960()) continue;
            list.add(NpcAPI.Instance().getIItemStack(item));
        }
        if (!quest.randomReward) {
            event.itemRewards = list.toArray(new IItemStack[list.size()]);
        } else if (!list.isEmpty()) {
            event.itemRewards = new IItemStack[]{(IItemStack)list.get(this.player.method_6051().method_43048(list.size()))};
        }
        EventHooks.onQuestTurnedIn(data.scriptData, event);
        for (IItemStack item : event.itemRewards) {
            if (item == null) continue;
            NoppesUtilServer.GivePlayerItem((class_1297)this.player, (class_1657)this.player, item.getMCItemStack());
        }
        quest.questInterface.handleComplete((class_1657)this.player);
        if (event.expReward > 0) {
            NoppesUtilServer.playSound((class_1309)this.player, class_3417.field_14627, 0.1f, 0.5f * ((this.player.method_37908().field_9229.method_43057() - this.player.method_37908().field_9229.method_43057()) * 0.7f + 1.8f));
            this.player.method_7255(event.expReward);
        }
        quest.factionOptions.addPoints((class_1657)this.player);
        if (quest.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(this.player.method_5682(), this.player.method_5477().getString(), quest.mail);
        }
        if (!quest.command.isEmpty()) {
            FakePlayer cplayer = EntityNPCInterface.CommandPlayer;
            ((EntityIMixin)cplayer).setLevel((class_1937)((class_3218)this.player.method_37908()));
            cplayer.method_5814(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
            NoppesUtilServer.runCommand((class_1297)cplayer, "QuestCompletion", quest.command, (class_1657)this.player);
        }
        PlayerQuestController.setQuestFinished(quest, (class_1657)this.player);
        if (quest.hasNewQuest()) {
            PlayerQuestController.addActiveQuest(quest.getNextQuest(), (class_1657)this.player);
        }
    }
}

