/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2636;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.BaseSpawnerMixin;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketToolMobSpawner
extends PacketServerBasic {
    private boolean createSpawner;
    private boolean server;
    private class_2338 pos;
    private String name = "";
    private int tab = -1;
    private class_2487 clone = new class_2487();

    public SPacketToolMobSpawner(boolean createSpawner, class_2338 pos, String name, int tab) {
        this.server = true;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
    }

    public SPacketToolMobSpawner(boolean createSpawner, class_2338 pos, class_2487 clone) {
        this.server = false;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.clone = clone;
    }

    public SPacketToolMobSpawner(boolean createSpawner, boolean server, class_2338 pos, String name, int tab, class_2487 clone) {
        this.createSpawner = createSpawner;
        this.server = server;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
        this.clone = clone;
    }

    public SPacketToolMobSpawner(class_2540 buf) {
        this.createSpawner = buf.readBoolean();
        this.server = buf.readBoolean();
        this.pos = buf.method_10811();
        this.name = buf.method_10800(Short.MAX_VALUE);
        this.tab = buf.readInt();
        this.clone = buf.method_10798();
    }

    public static SPacketToolMobSpawner decode(class_2540 buf) {
        return new SPacketToolMobSpawner(buf);
    }

    @Override
    public boolean toolAllowed(class_1799 item) {
        return item.method_7909() == CustomItems.cloner;
    }

    @Override
    public PermissionNode<Boolean> getPermission() {
        if (this.createSpawner) {
            return CustomNpcsPermissions.SPAWNER_CREATE;
        }
        return CustomNpcsPermissions.SPAWNER_MOB;
    }

    @Override
    protected void handle() {
        if (this.server) {
            this.clone = ServerCloneController.Instance.getCloneData(this.player.method_5671(), this.name, this.tab);
        }
        if (this.clone == null || this.clone.method_33133()) {
            return;
        }
        if (this.createSpawner) {
            SPacketToolMobSpawner.createMobSpawner(this.pos, this.clone, (class_1657)this.player);
        } else {
            class_1297 entity = SPacketToolMobSpawner.spawnClone(this.clone, (double)this.pos.method_10263() + 0.5, this.pos.method_10264() + 1, (double)this.pos.method_10260() + 0.5, this.player.method_37908());
            if (entity == null) {
                this.player.method_43496((class_2561)class_2561.method_43470((String)"Failed to create an entity out of your clone"));
            }
        }
    }

    public static class_1297 spawnClone(class_2487 compound, double x, double y, double z, class_1937 world) {
        ServerCloneController.Instance.cleanTags(compound);
        compound.method_10566("Pos", (class_2520)NBTTags.nbtDoubleList(x, y, z));
        class_1297 entity = (class_1297)class_1299.method_5892((class_2487)compound, (class_1937)world).get();
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(npc.method_24515());
        }
        world.method_8649(entity);
        return entity;
    }

    public static void createMobSpawner(class_2338 pos, class_2487 comp, class_1657 player) {
        ServerCloneController.Instance.cleanTags(comp);
        if (comp.method_10558("id").equalsIgnoreCase("entityhorse")) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Currently you cant create horse spawner, its a minecraft bug"));
            return;
        }
        player.method_37908().method_8501(pos, class_2246.field_10260.method_9564());
        class_2636 tile = (class_2636)player.method_37908().method_8321(pos);
        class_1917 logic = tile.method_11390();
        if (!comp.method_10573("id", 8)) {
            comp.method_10582("id", "Pig");
        }
        comp.method_10539("StartPosNew", new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
        ((BaseSpawnerMixin)logic).callSetNextSpawnData(player.method_37908(), pos, new class_1952(comp, Optional.empty()));
    }

    public static void encode(SPacketToolMobSpawner msg, class_2540 buf) {
        buf.writeBoolean(msg.createSpawner);
        buf.writeBoolean(msg.server);
        buf.method_10807(msg.pos);
        buf.method_10814(msg.name);
        buf.writeInt(msg.tab);
        buf.method_10794(msg.clone);
    }
}

