/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.quests.QuestInterface;

public class QuestKill
extends QuestInterface {
    public TreeMap<String, Integer> targets = new TreeMap();

    @Override
    public void readAdditionalSaveData(class_2487 compound) {
        this.targets = new TreeMap<String, Integer>(NBTTags.getStringIntegerMap(compound.method_10554("QuestDialogs", 10)));
    }

    @Override
    public void addAdditionalSaveData(class_2487 compound) {
        compound.method_10566("QuestDialogs", (class_2520)NBTTags.nbtStringIntegerMap(this.targets));
    }

    @Override
    public boolean isCompleted(class_1657 player) {
        PlayerQuestData playerdata = PlayerData.get((class_1657)player).questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return false;
        }
        HashMap<String, Integer> killed = this.getKilled(data);
        if (killed.size() != this.targets.size()) {
            return false;
        }
        for (String entity : killed.keySet()) {
            if (this.targets.containsKey(entity) && this.targets.get(entity) <= killed.get(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handleComplete(class_1657 player) {
    }

    public HashMap<String, Integer> getKilled(QuestData data) {
        return NBTTags.getStringIntegerMap(data.extraData.method_10554("Killed", 10));
    }

    public void setKilled(QuestData data, HashMap<String, Integer> killed) {
        data.extraData.method_10566("Killed", (class_2520)NBTTags.nbtStringIntegerMap(killed));
    }

    @Override
    public IQuestObjective[] getObjectives(class_1657 player) {
        ArrayList<QuestKillObjective> list = new ArrayList<QuestKillObjective>();
        for (Map.Entry<String, Integer> entry : this.targets.entrySet()) {
            list.add(new QuestKillObjective(player, entry.getKey(), entry.getValue()));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    class QuestKillObjective
    implements IQuestObjective {
        private final class_1657 player;
        private final String entity;
        private final int amount;

        public QuestKillObjective(class_1657 player, String entity, int amount) {
            this.player = player;
            this.entity = entity;
            this.amount = amount;
        }

        @Override
        public int getProgress() {
            PlayerData data = PlayerData.get(this.player);
            PlayerQuestData playerdata = data.questData;
            QuestData questdata = playerdata.activeQuests.get(QuestKill.this.questId);
            HashMap<String, Integer> killed = QuestKill.this.getKilled(questdata);
            if (!killed.containsKey(this.entity)) {
                return 0;
            }
            return killed.get(this.entity);
        }

        @Override
        public void setProgress(int progress) {
            if (progress < 0 || progress > this.amount) {
                throw new CustomNPCsException("Progress has to be between 0 and " + this.amount, new Object[0]);
            }
            PlayerData data = PlayerData.get(this.player);
            PlayerQuestData playerdata = data.questData;
            QuestData questdata = playerdata.activeQuests.get(QuestKill.this.questId);
            HashMap<String, Integer> killed = QuestKill.this.getKilled(questdata);
            if (killed.containsKey(this.entity) && killed.get(this.entity) == progress) {
                return;
            }
            killed.put(this.entity, progress);
            QuestKill.this.setKilled(questdata, killed);
            data.questData.checkQuestCompletion(this.player, 2);
            data.questData.checkQuestCompletion(this.player, 4);
            data.updateClient = true;
        }

        @Override
        public int getMaxProgress() {
            return this.amount;
        }

        @Override
        public boolean isCompleted() {
            return this.getProgress() >= this.amount;
        }

        @Override
        public String getText() {
            return this.getMCText().getString();
        }

        @Override
        public class_2561 getMCText() {
            return class_2561.method_43471((String)this.entity).method_27693(": " + this.getProgress() + "/" + this.getMaxProgress());
        }
    }
}

