/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.quests.QuestInterface;

public class QuestLocation
extends QuestInterface {
    public String location = "";
    public String location2 = "";
    public String location3 = "";

    @Override
    public void readAdditionalSaveData(class_2487 compound) {
        this.location = compound.method_10558("QuestLocation");
        this.location2 = compound.method_10558("QuestLocation2");
        this.location3 = compound.method_10558("QuestLocation3");
    }

    @Override
    public void addAdditionalSaveData(class_2487 compound) {
        compound.method_10582("QuestLocation", this.location);
        compound.method_10582("QuestLocation2", this.location2);
        compound.method_10582("QuestLocation3", this.location3);
    }

    @Override
    public boolean isCompleted(class_1657 player) {
        PlayerQuestData playerdata = PlayerData.get((class_1657)player).questData;
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return false;
        }
        return this.getFound(data, 0);
    }

    @Override
    public void handleComplete(class_1657 player) {
    }

    public boolean getFound(QuestData data, int i) {
        if (i == 1) {
            return data.extraData.method_10577("LocationFound");
        }
        if (i == 2) {
            return data.extraData.method_10577("Location2Found");
        }
        if (i == 3) {
            return data.extraData.method_10577("Location3Found");
        }
        if (!this.location.isEmpty() && !data.extraData.method_10577("LocationFound")) {
            return false;
        }
        if (!this.location2.isEmpty() && !data.extraData.method_10577("Location2Found")) {
            return false;
        }
        return this.location3.isEmpty() || data.extraData.method_10577("Location3Found");
    }

    public boolean setFound(QuestData data, String location) {
        if (location.equalsIgnoreCase(this.location) && !data.extraData.method_10577("LocationFound")) {
            data.extraData.method_10556("LocationFound", true);
            return true;
        }
        if (location.equalsIgnoreCase(this.location2) && !data.extraData.method_10577("LocationFound2")) {
            data.extraData.method_10556("Location2Found", true);
            return true;
        }
        if (location.equalsIgnoreCase(this.location3) && !data.extraData.method_10577("LocationFound3")) {
            data.extraData.method_10556("Location3Found", true);
            return true;
        }
        return false;
    }

    @Override
    public IQuestObjective[] getObjectives(class_1657 player) {
        ArrayList<QuestLocationObjective> list = new ArrayList<QuestLocationObjective>();
        if (!this.location.isEmpty()) {
            list.add(new QuestLocationObjective(player, this.location, "LocationFound"));
        }
        if (!this.location2.isEmpty()) {
            list.add(new QuestLocationObjective(player, this.location2, "Location2Found"));
        }
        if (!this.location3.isEmpty()) {
            list.add(new QuestLocationObjective(player, this.location3, "Location3Found"));
        }
        return list.toArray(new IQuestObjective[list.size()]);
    }

    class QuestLocationObjective
    implements IQuestObjective {
        private final class_1657 player;
        private final String location;
        private final String nbtName;

        public QuestLocationObjective(class_1657 player, String location, String nbtName) {
            this.player = player;
            this.location = location;
            this.nbtName = nbtName;
        }

        @Override
        public int getProgress() {
            return this.isCompleted() ? 1 : 0;
        }

        @Override
        public void setProgress(int progress) {
            if (progress < 0 || progress > 1) {
                throw new CustomNPCsException("Progress has to be 0 or 1", new Object[0]);
            }
            PlayerData data = PlayerData.get(this.player);
            QuestData questData = data.questData.activeQuests.get(QuestLocation.this.questId);
            boolean completed = questData.extraData.method_10577(this.nbtName);
            if (completed && progress == 1 || !completed && progress == 0) {
                return;
            }
            questData.extraData.method_10556(this.nbtName, progress == 1);
            data.questData.checkQuestCompletion(this.player, 3);
            data.updateClient = true;
        }

        @Override
        public int getMaxProgress() {
            return 1;
        }

        @Override
        public boolean isCompleted() {
            PlayerData data = PlayerData.get(this.player);
            QuestData questData = data.questData.activeQuests.get(QuestLocation.this.questId);
            return questData.extraData.method_10577(this.nbtName);
        }

        @Override
        public String getText() {
            return this.getMCText().getString();
        }

        @Override
        public class_2561 getMCText() {
            return class_2561.method_43471((String)this.location).method_10852((class_2561)class_2561.method_43471((String)(this.isCompleted() ? "quest.found" : "quest.notfound")));
        }
    }
}

