/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.Stack;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_7923;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.role.IJobBuilder;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.controllers.data.BlockData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobBuilder
extends JobInterface
implements IJobBuilder {
    public TileBuilder build = null;
    private class_2338 possibleBuildPos = null;
    private Stack<BlockData> placingList = null;
    private BlockData placing = null;
    private int tryTicks = 0;
    private int ticks = 0;

    public JobBuilder(EntityNPCInterface npc) {
        super(npc);
        this.overrideMainHand = true;
    }

    @Override
    public class_2487 save(class_2487 compound) {
        if (this.build != null) {
            compound.method_10569("BuildX", this.build.method_11016().method_10263());
            compound.method_10569("BuildY", this.build.method_11016().method_10264());
            compound.method_10569("BuildZ", this.build.method_11016().method_10260());
            if (this.placingList != null && !this.placingList.isEmpty()) {
                class_2499 list = new class_2499();
                for (BlockData data : this.placingList) {
                    list.add((Object)data.getNBT());
                }
                if (this.placing != null) {
                    list.add((Object)this.placing.getNBT());
                }
                compound.method_10566("Placing", (class_2520)list);
            }
        }
        return compound;
    }

    @Override
    public void load(class_2487 compound) {
        if (compound.method_10545("BuildX")) {
            this.possibleBuildPos = new class_2338(compound.method_10550("BuildX"), compound.method_10550("BuildY"), compound.method_10550("BuildZ"));
        }
        if (this.possibleBuildPos != null && compound.method_10545("Placing")) {
            Stack<BlockData> placing = new Stack<BlockData>();
            class_2499 list = compound.method_10554("Placing", 10);
            for (int i = 0; i < list.size(); ++i) {
                BlockData data = BlockData.getData(list.method_10602(i));
                if (data == null) continue;
                placing.add(data);
            }
            this.placingList = placing;
        }
        this.npc.ais.doorInteract = 1;
    }

    @Override
    public IItemStack getMainhand() {
        String name = this.npc.getJobData();
        class_1799 item = this.stringToItem(name);
        if (item.method_7960()) {
            return this.npc.inventory.weapons.get(0);
        }
        return NpcAPI.Instance().getIItemStack(item);
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.possibleBuildPos != null) {
            class_2586 tile = this.npc.method_37908().method_8321(this.possibleBuildPos);
            if (tile instanceof TileBuilder) {
                this.build = (TileBuilder)tile;
            } else {
                this.placingList.clear();
            }
            this.possibleBuildPos = null;
        }
        return this.build != null;
    }

    @Override
    public void aiUpdateTask() {
        if (this.build.finished && this.placingList == null || !this.build.enabled || this.build.method_11015()) {
            this.build = null;
            this.npc.method_5942().method_6337((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos(), 1.0);
            return;
        }
        if (this.ticks++ < 10) {
            return;
        }
        this.ticks = 0;
        if ((this.placingList == null || this.placingList.isEmpty()) && this.placing == null) {
            this.placingList = this.build.getBlock();
            this.npc.setJobData("");
            return;
        }
        if (this.placing == null) {
            this.placing = this.placingList.pop();
            if (this.placing.state.method_26204() == class_2246.field_10369) {
                this.placing = null;
                return;
            }
            this.tryTicks = 0;
            this.npc.setJobData(this.blockToString(this.placing));
        }
        this.npc.method_5942().method_6337((double)this.placing.pos.method_10263(), (double)(this.placing.pos.method_10264() + 1), (double)this.placing.pos.method_10260(), 1.0);
        if (this.tryTicks++ > 40 || this.npc.nearPosition(this.placing.pos)) {
            class_2338 blockPos = this.placing.pos;
            this.placeBlock();
            if (this.tryTicks > 40) {
                blockPos = NoppesUtilServer.GetClosePos(blockPos, this.npc.method_37908());
                this.npc.method_5859((double)blockPos.method_10263() + 0.5, blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
            }
        }
    }

    private String blockToString(BlockData data) {
        if (data.state.method_26204() == class_2246.field_10124) {
            return class_7923.field_41178.method_10221((Object)class_1802.field_8403).toString();
        }
        return this.itemToString(data.getStack());
    }

    @Override
    public void stop() {
        this.reset();
    }

    @Override
    public void reset() {
        this.build = null;
        this.npc.setJobData("");
    }

    public void placeBlock() {
        class_2586 tile;
        if (this.placing == null) {
            return;
        }
        this.npc.method_5942().method_6340();
        this.npc.method_6104(class_1268.field_5808);
        this.npc.method_37908().method_8652(this.placing.pos, this.placing.state, 2);
        if (this.placing.state.method_26204() instanceof class_2343 && this.placing.tile != null && (tile = this.npc.method_37908().method_8321(this.placing.pos)) != null) {
            try {
                tile.method_11014(this.placing.tile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.placing = null;
    }

    @Override
    public boolean isBuilding() {
        return this.build != null && this.build.enabled && !this.build.finished && this.build.started;
    }

    @Override
    public int getType() {
        return 10;
    }
}

