/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import noppes.npcs.NBTTags;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.util.ValueUtil;

public class JobHealer
extends JobInterface {
    private int healTicks = 0;
    public int range = 8;
    public byte type = (byte)2;
    public int speed = 20;
    public HashMap<Integer, Integer> effects = new HashMap();
    private List<class_1309> affected = new ArrayList<class_1309>();

    public JobHealer(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public class_2487 save(class_2487 nbttagcompound) {
        nbttagcompound.method_10569("HealerRange", this.range);
        nbttagcompound.method_10567("HealerType", this.type);
        nbttagcompound.method_10566("BeaconEffects", (class_2520)NBTTags.nbtIntegerIntegerMap(this.effects));
        nbttagcompound.method_10569("HealerSpeed", this.speed);
        return nbttagcompound;
    }

    @Override
    public void load(class_2487 nbttagcompound) {
        this.range = nbttagcompound.method_10550("HealerRange");
        this.type = nbttagcompound.method_10571("HealerType");
        this.effects = NBTTags.getIntegerIntegerMap(nbttagcompound.method_10554("BeaconEffects", 10));
        this.speed = ValueUtil.CorrectInt(nbttagcompound.method_10550("HealerSpeed"), 10, Integer.MAX_VALUE);
    }

    @Override
    public boolean aiShouldExecute() {
        ++this.healTicks;
        if (this.healTicks < this.speed) {
            return false;
        }
        this.healTicks = 0;
        this.affected = this.npc.method_37908().method_18467(class_1309.class, this.npc.method_5829().method_1009((double)this.range, (double)this.range / 2.0, (double)this.range));
        return !this.affected.isEmpty();
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void aiStartExecuting() {
        for (class_1309 entity : this.affected) {
            boolean isEnemy = false;
            isEnemy = entity instanceof class_1657 ? this.npc.faction.isAggressiveToPlayer((class_1657)entity) : (entity instanceof EntityNPCInterface ? this.npc.faction.isAggressiveToNpc((EntityNPCInterface)entity) : entity instanceof class_1308);
            if (entity == this.npc || this.type == 0 && isEnemy || this.type == 1 && !isEnemy) continue;
            for (Integer potionEffect : this.effects.keySet()) {
                class_1291 p = class_1291.method_5569((int)potionEffect);
                if (p == null) continue;
                entity.method_6092(new class_1293(p, 100, this.effects.get(potionEffect).intValue()));
            }
        }
        this.affected.clear();
    }

    @Override
    public int getType() {
        return 2;
    }
}

