/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerItemGiverData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobItemGiver
extends JobInterface {
    public int cooldownType = 0;
    public int givingMethod = 0;
    public int cooldown = 10;
    public NpcMiscInventory inventory;
    public int itemGiverId = 0;
    public List<String> lines = new ArrayList<String>();
    private int ticks = 10;
    private List<class_1657> recentlyChecked = new ArrayList<class_1657>();
    private List<class_1657> toCheck;
    public Availability availability = new Availability();

    public JobItemGiver(EntityNPCInterface npc) {
        super(npc);
        this.inventory = new NpcMiscInventory(9);
        this.lines.add("Have these items {player}");
    }

    @Override
    public class_2487 save(class_2487 nbttagcompound) {
        nbttagcompound.method_10569("igCooldownType", this.cooldownType);
        nbttagcompound.method_10569("igGivingMethod", this.givingMethod);
        nbttagcompound.method_10569("igCooldown", this.cooldown);
        nbttagcompound.method_10569("ItemGiverId", this.itemGiverId);
        nbttagcompound.method_10566("igLines", (class_2520)NBTTags.nbtStringList(this.lines));
        nbttagcompound.method_10566("igJobInventory", (class_2520)this.inventory.getToNBT());
        nbttagcompound.method_10566("igAvailability", (class_2520)this.availability.save(new class_2487()));
        return nbttagcompound;
    }

    @Override
    public void load(class_2487 nbttagcompound) {
        this.itemGiverId = nbttagcompound.method_10550("ItemGiverId");
        this.cooldownType = nbttagcompound.method_10550("igCooldownType");
        this.givingMethod = nbttagcompound.method_10550("igGivingMethod");
        this.cooldown = nbttagcompound.method_10550("igCooldown");
        this.lines = NBTTags.getStringList(nbttagcompound.method_10554("igLines", 10));
        this.inventory.setFromNBT(nbttagcompound.method_10562("igJobInventory"));
        if (this.itemGiverId == 0 && GlobalDataController.instance != null) {
            this.itemGiverId = GlobalDataController.instance.incrementItemGiverId();
        }
        this.availability.load(nbttagcompound.method_10562("igAvailability"));
    }

    public class_2499 newHashMapNBTList(HashMap<String, Long> lines) {
        class_2499 nbttaglist = new class_2499();
        HashMap<String, Long> lines2 = lines;
        for (String s : lines2.keySet()) {
            class_2487 nbttagcompound = new class_2487();
            nbttagcompound.method_10582("Line", s);
            nbttagcompound.method_10544("Time", lines.get(s).longValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public HashMap<String, Long> getNBTLines(class_2499 tagList) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 nbttagcompound = tagList.method_10602(i);
            String line = nbttagcompound.method_10558("Line");
            long time = nbttagcompound.method_10537("Time");
            map.put(line, time);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean giveItems(class_1657 player) {
        PlayerItemGiverData data = PlayerData.get((class_1657)player).itemgiverData;
        if (!this.canPlayerInteract(data)) {
            return false;
        }
        Vector<class_1799> items = new Vector<class_1799>();
        Vector<Object> toGive = new Vector<class_1799>();
        for (Object is : this.inventory.items) {
            if (is.method_7960()) continue;
            items.add(is.method_7972());
        }
        if (items.isEmpty()) {
            return false;
        }
        if (this.isAllGiver()) {
            toGive = items;
        } else if (this.isRemainingGiver()) {
            for (Object is : items) {
                if (this.playerHasItem(player, is.method_7909())) continue;
                toGive.add((class_1799)is);
            }
        } else if (this.isRandomGiver()) {
            toGive.add(((class_1799)items.get(this.npc.method_37908().field_9229.method_43048(items.size()))).method_7972());
        } else if (this.isGiverWhenNotOwnedAny()) {
            boolean ownsItems = false;
            for (class_1799 is : items) {
                if (!this.playerHasItem(player, is.method_7909())) continue;
                return false;
            }
            if (ownsItems) return false;
            toGive = items;
        } else if (this.isChainedGiver()) {
            int itemIndex = data.getItemIndex(this);
            int i = 0;
            for (class_1799 item : this.inventory.items) {
                if (i == itemIndex) {
                    toGive.add(item);
                    break;
                }
                ++i;
            }
        }
        if (toGive.isEmpty()) {
            return false;
        }
        if (!this.givePlayerItems(player, toGive)) return false;
        if (!this.lines.isEmpty()) {
            this.npc.say(player, new Line(this.lines.get(this.npc.method_6051().method_43048(this.lines.size()))));
        }
        if (this.isDaily()) {
            data.setTime(this, this.getDay());
        } else {
            data.setTime(this, System.currentTimeMillis());
        }
        if (!this.isChainedGiver()) return true;
        data.setItemIndex(this, (data.getItemIndex(this) + 1) % this.inventory.items.size());
        return true;
    }

    private int getDay() {
        return (int)(this.npc.method_37908().method_8510() / 24000L);
    }

    private boolean canPlayerInteract(PlayerItemGiverData data) {
        if (this.inventory.items.isEmpty()) {
            return false;
        }
        if (this.isOnTimer()) {
            if (!data.hasInteractedBefore(this)) {
                return true;
            }
            return data.getTime(this) + (long)(this.cooldown * 1000) < System.currentTimeMillis();
        }
        if (this.isGiveOnce()) {
            return !data.hasInteractedBefore(this);
        }
        if (this.isDaily()) {
            if (!data.hasInteractedBefore(this)) {
                return true;
            }
            return (long)this.getDay() > data.getTime(this);
        }
        return false;
    }

    private boolean givePlayerItems(class_1657 player, Vector<class_1799> toGive) {
        if (toGive.isEmpty()) {
            return false;
        }
        if (this.freeInventorySlots(player) < toGive.size()) {
            return false;
        }
        for (class_1799 is : toGive) {
            this.npc.givePlayerItem(player, is);
        }
        return true;
    }

    private boolean playerHasItem(class_1657 player, class_1792 item) {
        for (class_1799 is : player.method_31548().field_7547) {
            if (is.method_7960() || is.method_7909() != item) continue;
            return true;
        }
        for (class_1799 is : player.method_31548().field_7548) {
            if (is.method_7960() || is.method_7909() != item) continue;
            return true;
        }
        return false;
    }

    private int freeInventorySlots(class_1657 player) {
        int i = 0;
        for (class_1799 is : player.method_31548().field_7547) {
            if (!NoppesUtilServer.IsItemStackNull(is)) continue;
            ++i;
        }
        return i;
    }

    private boolean isRandomGiver() {
        return this.givingMethod == 0;
    }

    private boolean isAllGiver() {
        return this.givingMethod == 1;
    }

    private boolean isRemainingGiver() {
        return this.givingMethod == 2;
    }

    private boolean isGiverWhenNotOwnedAny() {
        return this.givingMethod == 3;
    }

    private boolean isChainedGiver() {
        return this.givingMethod == 4;
    }

    public boolean isOnTimer() {
        return this.cooldownType == 0;
    }

    private boolean isGiveOnce() {
        return this.cooldownType == 1;
    }

    private boolean isDaily() {
        return this.cooldownType == 2;
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.npc.isAttacking()) {
            return false;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 10;
        this.toCheck = this.npc.method_37908().method_18467(class_1657.class, this.npc.method_5829().method_1009(3.0, 3.0, 3.0));
        this.toCheck.removeAll(this.recentlyChecked);
        List listMax = this.npc.method_37908().method_18467(class_1657.class, this.npc.method_5829().method_1009(10.0, 10.0, 10.0));
        this.recentlyChecked.retainAll(listMax);
        this.recentlyChecked.addAll(this.toCheck);
        return this.toCheck.size() > 0;
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void aiStartExecuting() {
        for (class_1657 player : this.toCheck) {
            if (!this.npc.canNpcSee((class_1297)player) || !this.availability.isAvailable(player)) continue;
            this.recentlyChecked.add(player);
            this.interact(player);
        }
    }

    @Override
    public void killed() {
    }

    private boolean interact(class_1657 player) {
        if (!this.giveItems(player)) {
            this.npc.say(player, this.npc.advanced.getInteractLine());
        }
        return true;
    }

    @Override
    public void delete() {
    }

    @Override
    public int getType() {
        return 4;
    }
}

