/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.data.role.IJobSpawner;
import noppes.npcs.controllers.data.CloneSpawnData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.IEntityPersistentData;
import noppes.npcs.packets.server.SPacketToolMobSpawner;
import noppes.npcs.roles.JobInterface;
import org.apache.commons.lang3.RandomStringUtils;

public class JobSpawner
extends JobInterface
implements IJobSpawner {
    public Map<Integer, CloneSpawnData> data = new HashMap<Integer, CloneSpawnData>();
    private int number = 0;
    public List<class_1309> spawned = new ArrayList<class_1309>();
    private Map<String, Long> cooldown = new HashMap<String, Long>();
    private String id = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
    public boolean doesntDie = false;
    public int spawnType = 0;
    public int xOffset = 0;
    public int yOffset = 0;
    public int zOffset = 0;
    private class_1309 target;
    public boolean despawnOnTargetLost = true;

    public JobSpawner(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public class_2487 save(class_2487 compound) {
        compound.method_10566("SpawnerData", (class_2520)CloneSpawnData.save(this.data));
        compound.method_10582("SpawnerId", this.id);
        compound.method_10556("SpawnerDoesntDie", this.doesntDie);
        compound.method_10569("SpawnerType", this.spawnType);
        compound.method_10569("SpawnerXOffset", this.xOffset);
        compound.method_10569("SpawnerYOffset", this.yOffset);
        compound.method_10569("SpawnerZOffset", this.zOffset);
        compound.method_10556("DespawnOnTargetLost", this.despawnOnTargetLost);
        return compound;
    }

    public String getTitle(int slot) {
        CloneSpawnData sd = this.data.get(slot);
        if (sd == null) {
            return "gui.selectnpc";
        }
        return sd.tab + ": " + sd.name;
    }

    @Override
    public void load(class_2487 compound) {
        this.data = CloneSpawnData.load(compound.method_10554("SpawnerData", 10));
        this.id = compound.method_10558("SpawnerId");
        this.doesntDie = compound.method_10577("SpawnerDoesntDie");
        this.spawnType = compound.method_10550("SpawnerType");
        this.xOffset = compound.method_10550("SpawnerXOffset");
        this.yOffset = compound.method_10550("SpawnerYOffset");
        this.zOffset = compound.method_10550("SpawnerZOffset");
        this.despawnOnTargetLost = compound.method_10577("DespawnOnTargetLost");
    }

    public void setJobCompound(int slot, int tab, String name) {
        this.data.put(slot, new CloneSpawnData(tab, name));
    }

    public void remove(int i) {
        this.data.remove(i);
    }

    @Override
    public void aiUpdateTask() {
        if (this.spawned.isEmpty()) {
            if (this.spawnType == 0 && this.spawnEntity(this.number) == null && !this.doesntDie) {
                this.npc.method_31472();
            }
            if (this.spawnType == 1) {
                if (this.number >= 6 && !this.doesntDie) {
                    this.npc.method_31472();
                } else {
                    this.spawnEntity(0);
                    this.spawnEntity(1);
                    this.spawnEntity(2);
                    this.spawnEntity(3);
                    this.spawnEntity(4);
                    this.spawnEntity(5);
                    this.number = 6;
                }
            }
            if (this.spawnType == 2) {
                ArrayList<class_2487> list = new ArrayList<class_2487>();
                for (CloneSpawnData d : this.data.values()) {
                    class_2487 c = d.getCompound();
                    if (c == null || !c.method_10545("id")) continue;
                    list.add(c);
                }
                if (!list.isEmpty()) {
                    class_2487 compound = (class_2487)list.get(this.npc.method_6051().method_43048(list.size()));
                    this.spawnEntity(compound);
                } else if (!this.doesntDie) {
                    this.npc.method_31472();
                }
            }
        } else {
            this.checkSpawns();
        }
    }

    public void checkSpawns() {
        Iterator<class_1309> iterator = this.spawned.iterator();
        while (iterator.hasNext()) {
            class_1309 spawn = iterator.next();
            if (this.shouldDelete(spawn)) {
                spawn.method_31472();
                iterator.remove();
                continue;
            }
            this.checkTarget(spawn);
        }
    }

    public void checkTarget(class_1309 entity) {
        if (entity instanceof class_1308) {
            class_1308 liv = (class_1308)entity;
            if (liv.method_5968() == null || this.npc.method_6051().method_43048(100) == 1) {
                liv.method_5980(this.target);
            }
        } else if (entity.method_6065() == null || this.npc.method_6051().method_43048(100) == 1) {
            entity.method_6015(this.target);
        }
    }

    public boolean shouldDelete(class_1309 entity) {
        return !this.npc.isInRange((class_1297)entity, 60.0) || entity.method_31481() || entity.method_6032() <= 0.0f || this.despawnOnTargetLost && this.target == null;
    }

    private class_1309 getTarget() {
        class_1309 target = this.getTarget((class_1309)this.npc);
        if (target != null) {
            return target;
        }
        for (class_1309 entity : this.spawned) {
            target = this.getTarget(entity);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private class_1309 getTarget(class_1309 entity) {
        if (entity instanceof class_1308) {
            this.target = ((class_1308)entity).method_5968();
            if (this.target != null && !this.target.method_31481() && this.target.method_6032() > 0.0f) {
                return this.target;
            }
        }
        this.target = entity.method_6065();
        if (this.target != null && !this.target.method_31481() && this.target.method_6032() > 0.0f) {
            return this.target;
        }
        return null;
    }

    private void setTarget(class_1309 base, class_1309 target) {
        if (base instanceof class_1308) {
            ((class_1308)base).method_5980(target);
        } else {
            base.method_6015(target);
        }
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.data.isEmpty() || this.npc.isKilled()) {
            return false;
        }
        this.target = this.getTarget();
        if (this.npc.method_6051().method_43048(30) == 1 && this.spawned.isEmpty()) {
            this.spawned = this.getNearbySpawned();
        }
        if (!this.spawned.isEmpty()) {
            this.checkSpawns();
        }
        return this.target != null;
    }

    @Override
    public boolean aiContinueExecute() {
        return this.aiShouldExecute();
    }

    @Override
    public void stop() {
        this.reset();
    }

    @Override
    public void aiStartExecuting() {
        this.number = 0;
        for (class_1309 entity : this.spawned) {
            int i = ((IEntityPersistentData)entity).getPersistentData().method_10550("NpcSpawnerNr");
            if (i > this.number) {
                this.number = i;
            }
            this.setTarget(entity, this.npc.method_5968());
        }
    }

    @Override
    public void reset() {
        this.number = 0;
        if (this.spawned.isEmpty()) {
            this.spawned = this.getNearbySpawned();
        }
        this.target = null;
        this.checkSpawns();
    }

    @Override
    public void killed() {
        this.reset();
    }

    private class_1309 spawnEntity(class_2487 compound) {
        double z;
        double y;
        if (compound == null || !compound.method_10545("id")) {
            return null;
        }
        double x = this.npc.method_23317() + (double)this.xOffset - 0.5 + (double)this.npc.method_6051().method_43057();
        class_1297 entity = SPacketToolMobSpawner.spawnClone(compound, x, y = this.npc.method_23318() + (double)this.yOffset, z = this.npc.method_23321() + (double)this.zOffset - 0.5 + (double)this.npc.method_6051().method_43057(), this.npc.method_37908());
        if (entity == null || !(entity instanceof class_1309)) {
            return null;
        }
        class_1309 living = (class_1309)entity;
        ((IEntityPersistentData)living).getPersistentData().method_10582("NpcSpawnerId", this.id);
        ((IEntityPersistentData)living).getPersistentData().method_10569("NpcSpawnerNr", this.number);
        this.setTarget(living, this.npc.method_5968());
        living.method_5814(x, y, z);
        if (living instanceof EntityNPCInterface) {
            EntityNPCInterface snpc = (EntityNPCInterface)living;
            snpc.stats.spawnCycle = 4;
            snpc.stats.respawnTime = 0;
            snpc.ais.returnToStart = false;
        }
        this.spawned.add(living);
        return living;
    }

    private class_2487 getCompound(int i) {
        for (Map.Entry<Integer, CloneSpawnData> entry : this.data.entrySet()) {
            class_2487 compound;
            if (i > entry.getKey() || (compound = entry.getValue().getCompound()) == null || !compound.method_10545("id")) continue;
            this.number = entry.getKey() + 1;
            return compound;
        }
        return null;
    }

    private List<class_1309> getNearbySpawned() {
        ArrayList<class_1309> spawnList = new ArrayList<class_1309>();
        List list = this.npc.method_37908().method_18467(class_1309.class, this.npc.method_5829().method_1009(40.0, 40.0, 40.0));
        for (class_1309 entity : list) {
            if (!((IEntityPersistentData)entity).getPersistentData().method_10558("NpcSpawnerId").equals(this.id) || entity.method_31481()) continue;
            spawnList.add(entity);
        }
        return spawnList;
    }

    public boolean isOnCooldown(String name) {
        if (!this.cooldown.containsKey(name)) {
            return false;
        }
        long time = this.cooldown.get(name);
        return System.currentTimeMillis() < time + 1200000L;
    }

    @Override
    public IEntityLiving spawnEntity(int i) {
        class_2487 compound = this.getCompound(i);
        if (compound == null) {
            return null;
        }
        class_1309 base = this.spawnEntity(compound);
        if (base == null) {
            return null;
        }
        return (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)base);
    }

    @Override
    public void removeAllSpawned() {
        for (class_1309 entity : this.spawned) {
            entity.method_31472();
        }
        this.spawned = new ArrayList<class_1309>();
    }

    @Override
    public int getType() {
        return 6;
    }
}

