/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3417;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.constants.EnumCompanionJobs;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.ArmorMaterialsMixin;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.roles.companion.CompanionFarmer;
import noppes.npcs.roles.companion.CompanionFoodStats;
import noppes.npcs.roles.companion.CompanionGuard;
import noppes.npcs.roles.companion.CompanionJobInterface;
import noppes.npcs.roles.companion.CompanionTrader;

public class RoleCompanion
extends RoleInterface {
    private static final CompanionJobInterface NONE = new CompanionJobInterface(){

        @Override
        public class_2487 getNBT() {
            return null;
        }

        @Override
        public void setNBT(class_2487 compound) {
        }

        @Override
        public EnumCompanionJobs getType() {
            return EnumCompanionJobs.NONE;
        }
    };
    public NpcMiscInventory inventory;
    public String uuid = "";
    public String ownerName = "";
    public Map<EnumCompanionTalent, Integer> talents = new TreeMap<EnumCompanionTalent, Integer>();
    public boolean canAge = true;
    public long ticksActive = 0L;
    public EnumCompanionStage stage = EnumCompanionStage.FULLGROWN;
    public class_1657 owner = null;
    public int companionID;
    public CompanionJobInterface companionJobInterface = NONE;
    public boolean hasInv = true;
    public boolean defendOwner = true;
    public CompanionFoodStats foodstats = new CompanionFoodStats();
    private int eatingTicks = 20;
    private IItemStack eating = null;
    private int eatingDelay = 0;
    public int currentExp = 0;

    public RoleCompanion(EntityNPCInterface npc) {
        super(npc);
        this.inventory = new NpcMiscInventory(12);
    }

    @Override
    public boolean aiShouldExecute() {
        class_1657 prev = this.owner;
        this.owner = this.getOwner();
        if (this.companionJobInterface.isSelfSufficient()) {
            return true;
        }
        if (this.owner == null && !this.uuid.isEmpty()) {
            this.npc.method_31472();
        } else if (prev != this.owner && this.owner != null) {
            this.ownerName = this.owner.method_5476().getString();
            PlayerData data = PlayerData.get(this.owner);
            if (data.companionID != this.companionID) {
                this.npc.method_31472();
            }
        }
        return this.owner != null;
    }

    @Override
    public void aiUpdateTask() {
        if (this.owner != null && !this.companionJobInterface.isSelfSufficient()) {
            this.foodstats.onUpdate(this.npc);
        }
        if (this.foodstats.getFoodLevel() >= 18) {
            this.npc.stats.healthRegen = 0;
            this.npc.stats.combatRegen = 0;
        }
        if (this.foodstats.needFood() && this.isSitting()) {
            if (this.eatingDelay > 0) {
                --this.eatingDelay;
                return;
            }
            IItemStack prev = this.eating;
            this.eating = this.getFood();
            if (prev != null && this.eating == null) {
                this.npc.setRoleData("");
            }
            if (prev == null && this.eating != null) {
                this.npc.setRoleData("eating");
                this.eatingTicks = 20;
            }
            if (this.isEating()) {
                this.doEating();
            }
        } else if (this.eating != null && !this.isSitting()) {
            this.eating = null;
            this.eatingDelay = 20;
            this.npc.setRoleData("");
        }
        ++this.ticksActive;
        if (this.canAge && this.stage != EnumCompanionStage.FULLGROWN) {
            if (this.stage == EnumCompanionStage.BABY && this.ticksActive > (long)EnumCompanionStage.CHILD.matureAge) {
                this.matureTo(EnumCompanionStage.CHILD);
            } else if (this.stage == EnumCompanionStage.CHILD && this.ticksActive > (long)EnumCompanionStage.TEEN.matureAge) {
                this.matureTo(EnumCompanionStage.TEEN);
            } else if (this.stage == EnumCompanionStage.TEEN && this.ticksActive > (long)EnumCompanionStage.ADULT.matureAge) {
                this.matureTo(EnumCompanionStage.ADULT);
            } else if (this.stage == EnumCompanionStage.ADULT && this.ticksActive > (long)EnumCompanionStage.FULLGROWN.matureAge) {
                this.matureTo(EnumCompanionStage.FULLGROWN);
            }
        }
    }

    @Override
    public void clientUpdate() {
        if (this.npc.getRoleData().equals("eating")) {
            this.eating = this.getFood();
            if (this.isEating()) {
                this.doEating();
            }
        } else if (this.eating != null) {
            this.eating = null;
        }
    }

    private void doEating() {
        if (this.eating == null || this.eating.isEmpty()) {
            return;
        }
        class_1799 eating = this.eating.getMCItemStack();
        if (this.npc.method_37908().field_9236) {
            class_5819 rand = this.npc.method_6051();
            for (int j = 0; j < 2; ++j) {
                class_243 vec3 = new class_243(((double)rand.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3.method_1037(-this.npc.method_36455() * (float)Math.PI / 180.0f);
                vec3.method_1024(-this.npc.field_6283 * (float)Math.PI / 180.0f);
                class_243 vec31 = new class_243(((double)rand.method_43057() - 0.5) * 0.3, (double)(-rand.method_43057()) * 0.6 - 0.3, (double)(this.npc.method_17681() / 2.0f) + 0.1);
                vec31.method_1037(-this.npc.method_36455() * (float)Math.PI / 180.0f);
                vec31.method_1024(-this.npc.field_6283 * (float)Math.PI / 180.0f);
                vec31 = vec31.method_1031(this.npc.method_23317(), this.npc.method_23318() + (double)this.npc.method_17682() + 0.1, this.npc.method_23321());
                String s = "iconcrack_" + class_1792.method_7880((class_1792)eating.method_7909());
                this.npc.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, eating), vec31.field_1352, vec31.field_1351, vec31.field_1350, vec3.field_1352, vec3.field_1351 + 0.05, vec3.field_1350);
            }
        } else {
            --this.eatingTicks;
            if (this.eatingTicks <= 0) {
                class_4174 food = eating.method_7909().method_19264();
                if (this.inventory.removeItem(eating, 1)) {
                    this.foodstats.onFoodEaten(food, eating);
                    this.npc.method_5783(class_3417.field_19149, 0.5f, this.npc.method_6051().method_43057() * 0.1f + 0.9f);
                }
                this.eatingDelay = 20;
                this.npc.setRoleData("");
                this.eating = null;
            } else if (this.eatingTicks > 3 && this.eatingTicks % 2 == 0) {
                class_5819 rand = this.npc.method_6051();
                this.npc.method_5783(class_3417.field_20614, 0.5f + 0.5f * (float)rand.method_43048(2), (rand.method_43057() - rand.method_43057()) * 0.2f + 1.0f);
            }
        }
    }

    public void matureTo(EnumCompanionStage stage) {
        this.stage = stage;
        EntityCustomNpc npc = (EntityCustomNpc)this.npc;
        npc.ais.animationType = stage.animation;
        if (stage == EnumCompanionStage.BABY) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(0.5f, 0.5f, 0.5f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(0.5f, 0.5f, 0.5f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(0.5f, 0.5f, 0.5f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(0.7f, 0.7f, 0.7f);
            npc.ais.onAttack = 1;
            npc.ais.setWalkingSpeed(3);
            if (!this.talents.containsKey((Object)EnumCompanionTalent.INVENTORY)) {
                this.talents.put(EnumCompanionTalent.INVENTORY, 0);
            }
        }
        if (stage == EnumCompanionStage.CHILD) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(0.6f, 0.6f, 0.6f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(0.6f, 0.6f, 0.6f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(0.6f, 0.6f, 0.6f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(0.8f, 0.8f, 0.8f);
            npc.ais.onAttack = 0;
            npc.ais.setWalkingSpeed(4);
            if (!this.talents.containsKey((Object)EnumCompanionTalent.SWORD)) {
                this.talents.put(EnumCompanionTalent.SWORD, 0);
            }
        }
        if (stage == EnumCompanionStage.TEEN) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(0.8f, 0.8f, 0.8f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(0.8f, 0.8f, 0.8f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(0.8f, 0.8f, 0.8f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(0.9f, 0.9f, 0.9f);
            npc.ais.onAttack = 0;
            npc.ais.setWalkingSpeed(5);
            if (!this.talents.containsKey((Object)EnumCompanionTalent.ARMOR)) {
                this.talents.put(EnumCompanionTalent.ARMOR, 0);
            }
        }
        if (stage == EnumCompanionStage.ADULT || stage == EnumCompanionStage.FULLGROWN) {
            npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(1.0f, 1.0f, 1.0f);
            npc.modelData.getPartConfig(EnumParts.LEG_LEFT).setScale(1.0f, 1.0f, 1.0f);
            npc.modelData.getPartConfig(EnumParts.BODY).setScale(1.0f, 1.0f, 1.0f);
            npc.modelData.getPartConfig(EnumParts.HEAD).setScale(1.0f, 1.0f, 1.0f);
            npc.ais.onAttack = 0;
            npc.ais.setWalkingSpeed(5);
        }
    }

    @Override
    public class_2487 save(class_2487 compound) {
        compound.method_10566("CompanionInventory", (class_2520)this.inventory.getToNBT());
        compound.method_10582("CompanionOwner", this.uuid);
        compound.method_10582("CompanionOwnerName", this.ownerName);
        compound.method_10569("CompanionID", this.companionID);
        compound.method_10569("CompanionStage", this.stage.ordinal());
        compound.method_10569("CompanionExp", this.currentExp);
        compound.method_10556("CompanionCanAge", this.canAge);
        compound.method_10544("CompanionAge", this.ticksActive);
        compound.method_10556("CompanionHasInv", this.hasInv);
        compound.method_10556("CompanionDefendOwner", this.defendOwner);
        this.foodstats.writeNBT(compound);
        compound.method_10569("CompanionJob", this.companionJobInterface.getType().ordinal());
        if (this.companionJobInterface.getType() != EnumCompanionJobs.NONE) {
            compound.method_10566("CompanionJobData", (class_2520)this.companionJobInterface.getNBT());
        }
        class_2499 list = new class_2499();
        for (EnumCompanionTalent talent : this.talents.keySet()) {
            class_2487 c = new class_2487();
            c.method_10569("Talent", talent.ordinal());
            c.method_10569("Exp", this.talents.get((Object)talent).intValue());
            list.add((Object)c);
        }
        compound.method_10566("CompanionTalents", (class_2520)list);
        return compound;
    }

    @Override
    public void load(class_2487 compound) {
        this.inventory.setFromNBT(compound.method_10562("CompanionInventory"));
        this.uuid = compound.method_10558("CompanionOwner");
        this.ownerName = compound.method_10558("CompanionOwnerName");
        this.companionID = compound.method_10550("CompanionID");
        this.stage = EnumCompanionStage.values()[compound.method_10550("CompanionStage")];
        this.currentExp = compound.method_10550("CompanionExp");
        this.canAge = compound.method_10577("CompanionCanAge");
        this.ticksActive = compound.method_10537("CompanionAge");
        this.hasInv = compound.method_10577("CompanionHasInv");
        this.defendOwner = compound.method_10577("CompanionDefendOwner");
        this.foodstats.readNBT(compound);
        class_2499 list = compound.method_10554("CompanionTalents", 10);
        TreeMap<EnumCompanionTalent, Integer> talents = new TreeMap<EnumCompanionTalent, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 c = list.method_10602(i);
            EnumCompanionTalent talent = EnumCompanionTalent.values()[c.method_10550("Talent")];
            talents.put(talent, c.method_10550("Exp"));
        }
        this.talents = talents;
        this.setJob(compound.method_10550("CompanionJob"));
        this.companionJobInterface.setNBT(compound.method_10562("CompanionJobData"));
        this.setStats();
    }

    private void setJob(int i) {
        EnumCompanionJobs companionJob = EnumCompanionJobs.values()[i];
        this.companionJobInterface = companionJob == EnumCompanionJobs.SHOP ? new CompanionTrader() : (companionJob == EnumCompanionJobs.FARMER ? new CompanionFarmer() : (companionJob == EnumCompanionJobs.GUARD ? new CompanionGuard() : NONE));
        this.companionJobInterface.npc = this.npc;
    }

    @Override
    public void interact(class_1657 player) {
        this.interact(player, false);
    }

    public void interact(class_1657 player, boolean openGui) {
        if (player != null && this.companionJobInterface.getType() == EnumCompanionJobs.SHOP) {
            ((CompanionTrader)this.companionJobInterface).interact(player);
        }
        if (player != this.owner || !this.npc.method_5805() || this.npc.isAttacking()) {
            return;
        }
        if (player.method_18276() || openGui) {
            this.openGui(player);
        } else {
            this.setSitting(!this.isSitting());
        }
    }

    public int getTotalLevel() {
        int level = 0;
        for (EnumCompanionTalent talent : this.talents.keySet()) {
            level += this.getTalentLevel(talent);
        }
        return level;
    }

    public int getMaxExp() {
        return 500 + this.getTotalLevel() * 200;
    }

    public void addExp(int exp) {
        if (this.canAddExp(exp)) {
            this.currentExp += exp;
        }
    }

    public boolean canAddExp(int exp) {
        int newExp = this.currentExp + exp;
        return newExp >= 0 && newExp < this.getMaxExp();
    }

    public void gainExp(int chance) {
        if (this.npc.method_6051().method_43048(chance) == 0) {
            this.addExp(1);
        }
    }

    private void openGui(class_1657 player) {
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.Companion, this.npc);
    }

    public class_1657 getOwner() {
        if (this.uuid == null || this.uuid.isEmpty()) {
            return null;
        }
        try {
            UUID id = UUID.fromString(this.uuid);
            if (id != null) {
                return NoppesUtilServer.getPlayer(this.npc.method_5682(), id);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public void setOwner(class_1657 player) {
        this.uuid = player.method_5667().toString();
    }

    public boolean hasTalent(EnumCompanionTalent talent) {
        return this.getTalentLevel(talent) > 0;
    }

    public int getTalentLevel(EnumCompanionTalent talent) {
        if (!this.talents.containsKey((Object)talent)) {
            return 0;
        }
        int exp = this.talents.get((Object)talent);
        if (exp >= 5000) {
            return 5;
        }
        if (exp >= 3000) {
            return 4;
        }
        if (exp >= 1700) {
            return 3;
        }
        if (exp >= 1000) {
            return 2;
        }
        if (exp >= 400) {
            return 1;
        }
        return 0;
    }

    public Integer getNextLevel(EnumCompanionTalent talent) {
        if (!this.talents.containsKey((Object)talent)) {
            return 0;
        }
        int exp = this.talents.get((Object)talent);
        if (exp < 400) {
            return 400;
        }
        if (exp < 1000) {
            return 700;
        }
        if (exp < 1700) {
            return 1700;
        }
        if (exp < 3000) {
            return 3000;
        }
        return 5000;
    }

    public void levelSword() {
        if (!this.talents.containsKey((Object)EnumCompanionTalent.SWORD)) {
            return;
        }
    }

    public void levelTalent(EnumCompanionTalent talent, int exp) {
        if (!this.talents.containsKey((Object)EnumCompanionTalent.SWORD)) {
            return;
        }
        this.talents.put(talent, exp + this.talents.get((Object)talent));
    }

    public int getExp(EnumCompanionTalent talent) {
        if (this.talents.containsKey((Object)talent)) {
            return this.talents.get((Object)talent);
        }
        return -1;
    }

    public void setExp(EnumCompanionTalent talent, int exp) {
        this.talents.put(talent, exp);
    }

    private boolean isWeapon(class_1799 item) {
        if (item == null || item.method_7909() == null) {
            return false;
        }
        return item.method_7909() instanceof class_1829 || item.method_7909() instanceof class_1753 || item.method_7909() == class_1792.method_7867((class_2248)class_2246.field_10445);
    }

    public boolean canWearWeapon(IItemStack stack) {
        if (stack == null || stack.getMCItemStack().method_7909() == null) {
            return false;
        }
        class_1792 item = stack.getMCItemStack().method_7909();
        if (item instanceof class_1829) {
            return this.canWearSword(stack);
        }
        if (item instanceof class_1753) {
            return this.getTalentLevel(EnumCompanionTalent.RANGED) > 2;
        }
        if (item == class_1792.method_7867((class_2248)class_2246.field_10445)) {
            return this.getTalentLevel(EnumCompanionTalent.RANGED) > 1;
        }
        return false;
    }

    public boolean canWearArmor(class_1799 item) {
        int level = this.getTalentLevel(EnumCompanionTalent.ARMOR);
        if (item == null || !(item.method_7909() instanceof class_1738) || level <= 0) {
            return false;
        }
        if (level >= 5) {
            return true;
        }
        class_1738 armor = (class_1738)item.method_7909();
        int reduction = 1;
        if (armor.method_7686() instanceof class_1740) {
            reduction = ((ArmorMaterialsMixin)armor.method_7686()).durabilityMultiplier();
        }
        if (reduction <= 5 && level >= 1) {
            return true;
        }
        if (reduction <= 7 && level >= 2) {
            return true;
        }
        if (reduction <= 15 && level >= 3) {
            return true;
        }
        return reduction <= 33 && level >= 4;
    }

    public boolean canWearSword(IItemStack item) {
        int level = this.getTalentLevel(EnumCompanionTalent.SWORD);
        if (item == null || !(item.getMCItemStack().method_7909() instanceof class_1829) || level <= 0) {
            return false;
        }
        if (level >= 5) {
            return true;
        }
        return this.getSwordDamage(item) - (double)level < 4.0;
    }

    private double getSwordDamage(IItemStack item) {
        if (item == null || !(item.getMCItemStack().method_7909() instanceof class_1829)) {
            return 0.0;
        }
        Multimap map = item.getMCItemStack().method_7926(class_1304.field_6173);
        for (Map.Entry entry : map.entries()) {
            if (entry.getKey() != class_5134.field_23721) continue;
            class_1322 mod = (class_1322)entry.getValue();
            return mod.method_6186();
        }
        return 0.0;
    }

    public void setStats() {
        IItemStack weapon = this.npc.inventory.getRightHand();
        this.npc.stats.melee.setStrength((int)(1.0 + this.getSwordDamage(weapon)));
        this.npc.stats.healthRegen = 0;
        this.npc.stats.combatRegen = 0;
        int ranged = this.getTalentLevel(EnumCompanionTalent.RANGED);
        if (ranged > 0 && weapon != null) {
            class_1792 item = weapon.getMCItemStack().method_7909();
            if (ranged > 0 && item == class_1792.method_7867((class_2248)class_2246.field_10445)) {
                this.npc.inventory.setProjectile(weapon);
            }
            if (ranged > 0 && item instanceof class_1753) {
                this.npc.inventory.setProjectile(NpcAPI.Instance().getIItemStack(new class_1799((class_1935)class_1802.field_8107)));
            }
        }
        this.inventory.setSize(2 + this.getTalentLevel(EnumCompanionTalent.INVENTORY) * 2);
    }

    public void setSelfsuficient(boolean bo) {
        if (this.owner == null || bo == this.companionJobInterface.isSelfSufficient()) {
            return;
        }
        PlayerData data = PlayerData.get(this.owner);
        if (!bo && data.hasCompanion()) {
            return;
        }
        data.setCompanion(bo ? null : this.npc);
        if (this.companionJobInterface.getType() == EnumCompanionJobs.GUARD) {
            ((CompanionGuard)this.companionJobInterface).isStanding = bo;
        } else if (this.companionJobInterface.getType() == EnumCompanionJobs.FARMER) {
            ((CompanionFarmer)this.companionJobInterface).isStanding = bo;
        }
    }

    public void setSitting(boolean sit) {
        if (sit) {
            this.npc.ais.animationType = 1;
            this.npc.ais.onAttack = 3;
            this.npc.ais.setStartPos(this.npc.method_24515());
            this.npc.method_5942().method_6340();
            this.npc.method_5859(this.npc.getStartXPos(), this.npc.method_23318(), this.npc.getStartZPos());
        } else {
            this.npc.ais.animationType = this.stage.animation;
            this.npc.ais.onAttack = 0;
        }
        this.npc.updateAI = true;
    }

    public boolean isSitting() {
        return this.npc.ais.animationType == 1;
    }

    public float getDamageAfterArmorAbsorb(class_1282 source, float damage) {
        if (!this.hasInv || this.getTalentLevel(EnumCompanionTalent.ARMOR) <= 0) {
            return damage;
        }
        if (!source.method_48789(class_8103.field_43116)) {
            this.damageArmor(damage);
            int i = 25 - this.getTotalArmorValue();
            float f1 = damage * (float)i;
            damage = f1 / 25.0f;
        }
        return damage;
    }

    private void damageArmor(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        boolean hasArmor = false;
        Iterator<Map.Entry<Integer, IItemStack>> ita = this.npc.inventory.armor.entrySet().iterator();
        while (ita.hasNext()) {
            Map.Entry<Integer, IItemStack> entry = ita.next();
            IItemStack item = entry.getValue();
            if (item == null || !(item.getMCItemStack().method_7909() instanceof class_1738)) continue;
            hasArmor = true;
            item.getMCItemStack().method_7956((int)damage, (class_1309)this.npc, entity -> entity.method_20235(class_1304.method_20234((class_1304.class_1305)class_1304.class_1305.field_6178, (int)((Integer)entry.getKey()))));
            if (item.getStackSize() > 0) continue;
            ita.remove();
        }
        this.gainExp(hasArmor ? 4 : 8);
    }

    public int getTotalArmorValue() {
        int armorValue = 0;
        for (IItemStack armor : this.npc.inventory.armor.values()) {
            if (armor == null || !(armor.getMCItemStack().method_7909() instanceof class_1738)) continue;
            armorValue += ((class_1738)armor.getMCItemStack().method_7909()).method_7687();
        }
        return armorValue;
    }

    @Override
    public boolean isFollowing() {
        if (this.companionJobInterface.isSelfSufficient()) {
            return false;
        }
        return this.owner != null && !this.isSitting();
    }

    @Override
    public boolean defendOwner() {
        return this.defendOwner && this.owner != null && this.stage != EnumCompanionStage.BABY && !this.companionJobInterface.isSelfSufficient();
    }

    public boolean hasOwner() {
        return !this.uuid.isEmpty();
    }

    public void addMovementStat(double x, double y, double z) {
        long i = Math.round(Math.sqrt(x * x + y * y + z * z) * 100.0);
        if (this.npc.isAttacking()) {
            this.foodstats.addExhaustion(0.04f * (float)i * 0.01f);
        } else {
            this.foodstats.addExhaustion(0.02f * (float)i * 0.01f);
        }
    }

    private IItemStack getFood() {
        for (class_1799 item : this.inventory.items) {
            if (item.method_7960() || item.method_7909().method_19264() == null) continue;
            return NpcAPI.Instance().getIItemStack(item);
        }
        return null;
    }

    public IItemStack getItemInHand() {
        if (this.eating != null && !this.eating.isEmpty()) {
            return this.eating;
        }
        return this.npc.inventory.getRightHand();
    }

    public boolean isEating() {
        return this.eating != null && !this.eating.isEmpty();
    }

    public boolean hasInv() {
        if (!this.hasInv) {
            return false;
        }
        return this.hasTalent(EnumCompanionTalent.INVENTORY) || this.hasTalent(EnumCompanionTalent.ARMOR) || this.hasTalent(EnumCompanionTalent.SWORD);
    }

    public void attackedEntity(class_1297 entity) {
        IItemStack weapon = this.npc.inventory.getRightHand();
        this.gainExp(weapon == null ? 8 : 4);
        if (weapon == null) {
            return;
        }
        weapon.getMCItemStack().method_7956(1, (class_1309)this.npc, e -> e.method_20235(class_1304.field_6173));
        if (weapon.getMCItemStack().method_7947() <= 0) {
            this.npc.inventory.setRightHand(null);
        }
    }

    public void addTalentExp(EnumCompanionTalent talent, int exp) {
        if (this.talents.containsKey((Object)talent)) {
            exp += this.talents.get((Object)talent).intValue();
        }
        this.talents.put(talent, exp);
    }

    @Override
    public int getType() {
        return 6;
    }
}

